/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public abstract class BasePreviewSection
extends FormSection {
    private LogEntry entry;
    private Text text;
    private ScrollableSectionForm form;

    public BasePreviewSection(ScrollableSectionForm form, String title, boolean collapsed) {
        this.form = form;
        this.setHeaderText(title);
        this.setCollapsable(true);
        this.setCompactMode(true);
        this.setCollapsed(collapsed);
    }

    public LogEntry getEntry() {
        return this.entry;
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.text = new Text(container, 2);
        GridData gd = new GridData(1808);
        gd.widthHint = -1;
        this.text.setLayoutData((Object)gd);
        this.text.setEditable(false);
        this.text.setBackground(factory.getBackgroundColor());
        return container;
    }

    public void expandTo(Object object) {
        this.entry = (LogEntry)((Object)object);
        this.refresh();
    }

    private void refresh() {
        if (this.entry == null) {
            this.text.setText("");
        } else {
            this.text.setText(this.getTextFromEntry());
        }
        if (!this.isCollapsed()) {
            this.reflow();
        }
    }

    protected abstract String getTextFromEntry();

    protected void reflow() {
        super.reflow();
        this.form.update();
    }

    public boolean hasFocus() {
        return this.text.isFocusControl();
    }
}

