/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal.engine;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.update.ui.forms.internal.HyperlinkSettings;
import org.eclipse.update.ui.forms.internal.engine.HyperlinkAction;
import org.eclipse.update.ui.forms.internal.engine.IHyperlinkSegment;
import org.eclipse.update.ui.forms.internal.engine.Locator;
import org.eclipse.update.ui.forms.internal.engine.TextSegment;

public class HyperlinkSegment
extends TextSegment
implements IHyperlinkSegment {
    private String actionId;
    private String arg;
    private HyperlinkSettings settings;

    public HyperlinkSegment(String text, HyperlinkSettings settings, String fontId) {
        super(text, fontId);
        this.settings = settings;
        this.underline = settings.getHyperlinkUnderlineMode() == 3;
    }

    public HyperlinkAction getAction(Hashtable objectTable) {
        if (this.actionId == null) {
            return null;
        }
        Object obj = objectTable.get(this.actionId);
        if (obj == null) {
            return null;
        }
        if (obj instanceof HyperlinkAction) {
            return (HyperlinkAction)obj;
        }
        return null;
    }

    public String getObjectId() {
        return this.actionId;
    }

    void setActionId(String id) {
        this.actionId = id;
    }

    public void paint(GC gc, int width, Locator locator, Hashtable objectTable, boolean selected) {
        this.setColor(this.settings.getForeground());
        super.paint(gc, width, locator, objectTable, selected);
    }

    public void repaint(GC gc, boolean hover) {
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = fm.getDescent();
        boolean rolloverMode = this.settings.getHyperlinkUnderlineMode() == 2;
        int i = 0;
        while (i < this.areaRectangles.size()) {
            TextSegment.AreaRectangle areaRectangle = (TextSegment.AreaRectangle)this.areaRectangles.get(i);
            Rectangle rect = areaRectangle.rect;
            String text = areaRectangle.getText();
            Point extent = gc.textExtent(text);
            int textX = rect.x + 1;
            gc.drawString(text, textX, rect.y, true);
            if (this.underline || hover || rolloverMode) {
                int lineY = rect.y + lineHeight - descent + 1;
                Color saved = null;
                if (rolloverMode && !hover) {
                    saved = gc.getForeground();
                    gc.setForeground(gc.getBackground());
                }
                gc.drawLine(textX, lineY, textX + extent.x, lineY);
                if (saved != null) {
                    gc.setForeground(saved);
                }
            }
            ++i;
        }
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String string) {
        this.arg = string;
    }
}

