/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.update.ui.forms.internal.AbstractSectionForm;
import org.eclipse.update.ui.forms.internal.FormLabel;
import org.eclipse.update.ui.forms.internal.HTMLTableLayout;

public class WebForm
extends AbstractSectionForm {
    protected ScrolledComposite scrollComposite;
    private Composite control;
    private Composite client;
    private static final int HMARGIN = 5;
    private static final int VMARGIN = 5;
    private Image headingUnderlineImage;

    public Control createControl(Composite parent) {
        this.scrollComposite = new ScrolledComposite(parent, 768);
        this.scrollComposite.setBackground(this.factory.getBackgroundColor());
        this.scrollComposite.setMenu(parent.getMenu());
        Composite form = this.factory.createComposite((Composite)this.scrollComposite);
        this.scrollComposite.setContent((Control)form);
        this.scrollComposite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                WebForm.this.updateSize();
            }
        });
        WebFormLayout layout = new WebFormLayout();
        form.setLayout((Layout)layout);
        form.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                WebForm.this.paint(e);
            }
        });
        this.control = form;
        this.client = this.factory.createComposite(form);
        this.createContents(this.client);
        this.initializeScrollBars(this.scrollComposite);
        return this.scrollComposite;
    }

    private void initializeScrollBars(ScrolledComposite scomp) {
        ScrollBar vbar;
        ScrollBar hbar = scomp.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(5);
        }
        if ((vbar = scomp.getVerticalBar()) != null) {
            vbar.setIncrement(64);
        }
        AbstractSectionForm.updatePageIncrement(scomp);
    }

    public int getHeadingHeight(Composite parent) {
        int width = parent.getSize().x;
        int height = 0;
        int imageHeight = 0;
        if (this.getHeadingImage() != null) {
            Rectangle ibounds = this.getHeadingImage().getBounds();
            imageHeight = ibounds.height;
        }
        GC gc = new GC((Drawable)parent);
        gc.setFont(this.titleFont);
        int textWidth = width - 10;
        height = FormLabel.computeWrapHeight(gc, this.getHeadingText(), textWidth);
        height += 10;
        height = Math.max(height, imageHeight);
        if (this.headingUnderlineImage != null) {
            Rectangle ibounds = this.headingUnderlineImage.getBounds();
            height += ibounds.height;
        }
        gc.dispose();
        return height;
    }

    protected void createContents(Composite parent) {
    }

    public Control getControl() {
        return this.control;
    }

    public void setHeadingVisible(boolean newHeadingVisible) {
        super.setHeadingVisible(newHeadingVisible);
        if (this.control != null) {
            this.control.layout();
        }
    }

    public Image getHeadingUnderlineImage() {
        return this.headingUnderlineImage;
    }

    public void setHeadingUnderlineImage(Image image) {
        this.headingUnderlineImage = image;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.titleFont = JFaceResources.getHeaderFont();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.layout();
        }
    }

    protected void updateHyperlinkColors() {
        this.factory.updateHyperlinkColors();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.redraw();
        }
    }

    public void updateSize() {
        Rectangle ssize = this.scrollComposite.getClientArea();
        int swidth = ssize.width;
        WebFormLayout layout = (WebFormLayout)this.control.getLayout();
        Point size = layout.computeSize(this.control, swidth, -1, true);
        if (size.x < swidth) {
            size.x = swidth;
        }
        Rectangle trim = this.control.computeTrim(0, 0, size.x, size.y);
        size = new Point(trim.width, trim.height);
        this.control.setSize(size);
        AbstractSectionForm.updatePageIncrement(this.scrollComposite);
    }

    private void paint(PaintEvent e) {
        if (!this.isHeadingVisible()) {
            return;
        }
        GC gc = e.gc;
        if (this.headingImage != null) {
            gc.drawImage(this.headingImage, 0, 0);
        }
        Point size = this.control.getSize();
        if (this.getHeadingBackground() != null) {
            gc.setBackground(this.getHeadingBackground());
        }
        if (this.getHeadingForeground() != null) {
            gc.setForeground(this.getHeadingForeground());
        }
        gc.setFont(this.titleFont);
        FormLabel.paintWrapText(gc, size, this.getHeadingText(), 5, 5);
        if (this.headingUnderlineImage != null) {
            int y = this.getHeadingHeight(this.control) - this.headingUnderlineImage.getBounds().height;
            gc.drawImage(this.headingUnderlineImage, 0, y);
        }
    }

    public void setHeadingText(String headingText) {
        super.setHeadingText(headingText);
        if (this.control != null) {
            this.control.redraw();
        }
    }

    class WebFormLayout
    extends Layout {
        WebFormLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            Point csize;
            Layout layout;
            Rectangle bounds = parent.getClientArea();
            int x = 0;
            int y = 0;
            if (WebForm.this.isHeadingVisible()) {
                y = WebForm.this.getHeadingHeight(parent);
            }
            if ((layout = WebForm.this.client.getLayout()) != null && layout instanceof HTMLTableLayout) {
                HTMLTableLayout hlayout = (HTMLTableLayout)layout;
                csize = hlayout.computeSize(WebForm.this.client, bounds.width, -1, true);
                if (csize.x < bounds.width) {
                    csize.x = bounds.width;
                }
                Rectangle trim = WebForm.this.control.computeTrim(0, 0, csize.x, csize.y);
                csize = new Point(trim.width, trim.height);
            } else {
                csize = WebForm.this.client.computeSize(bounds.width, -1, changed);
            }
            WebForm.this.client.setBounds(x, y, csize.x, csize.y);
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            Point csize;
            Layout layout;
            int width = wHint;
            int height = 0;
            if (WebForm.this.isHeadingVisible()) {
                height = WebForm.this.getHeadingHeight(parent);
            }
            if ((layout = WebForm.this.client.getLayout()) != null && layout instanceof HTMLTableLayout) {
                HTMLTableLayout hlayout = (HTMLTableLayout)layout;
                csize = hlayout.computeSize(WebForm.this.client, width, -1, true);
                if (csize.x < width) {
                    csize.x = width;
                }
                Rectangle trim = WebForm.this.control.computeTrim(0, 0, csize.x, csize.y);
                csize = new Point(trim.width, trim.height);
            } else {
                csize = WebForm.this.client.computeSize(width, -1, changed);
            }
            width = csize.x;
            return new Point(width, height += csize.y);
        }
    }
}

