/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.AbstractSectionForm;

public class SectionForm
extends AbstractSectionForm
implements PaintListener {
    private Composite control;
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    private int widthHint = -1;
    private int heightHint = -1;

    public Control createControl(Composite parent) {
        Composite canvas = new Composite(parent, 0);
        canvas.setBackground(this.factory.getBackgroundColor());
        canvas.setForeground(this.factory.getForegroundColor());
        canvas.addPaintListener((PaintListener)this);
        canvas.setLayout((Layout)new FormLayout());
        canvas.setMenu(parent.getMenu());
        Composite formParent = this.factory.createComposite(canvas);
        this.createFormClient(formParent);
        this.control = canvas;
        return canvas;
    }

    protected void createFormClient(Composite parent) {
        this.factory.createComposite(parent);
    }

    public Control getControl() {
        return this.control;
    }

    private int getTitleHeight() {
        int imageHeight = 0;
        if (this.headingImage != null && !SWT.getPlatform().equals("motif")) {
            imageHeight = this.headingImage.getBounds().height;
        }
        GC gc = new GC((Drawable)this.control);
        gc.setFont(this.titleFont);
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        gc.dispose();
        int height = fontHeight + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(height, imageHeight);
    }

    private void paint(Control form, GC gc) {
        Rectangle bounds = form.getBounds();
        int height = this.getTitleHeight();
        if (this.headingImage != null) {
            Rectangle imageBounds = this.headingImage.getBounds();
            int x = bounds.width - imageBounds.width;
            int y = 0;
            x = 0;
            if (this.headingBackground != null) {
                gc.setBackground(this.headingBackground);
                gc.fillRectangle(0, 0, bounds.width, height);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gc.drawImage(this.headingImage, x, y);
            }
            if (this.headingForeground != null) {
                gc.setForeground(this.headingForeground);
            } else {
                gc.setForeground(this.factory.getForegroundColor());
            }
            gc.setFont(this.titleFont);
            gc.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        } else {
            gc.setFont(this.titleFont);
            gc.setBackground(this.factory.getColor("__default__header__"));
            gc.setForeground(this.factory.getForegroundColor());
            gc.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        }
    }

    public final void paintControl(PaintEvent event) {
        if (!this.headingVisible) {
            return;
        }
        GC gc = event.gc;
        Control form = (Control)event.widget;
        this.paint(form, gc);
    }

    public void setHeadingVisible(boolean newHeadingVisible) {
        super.setHeadingVisible(newHeadingVisible);
        if (this.control != null) {
            this.control.layout(true);
        }
    }

    public void setHeadingText(String headingText) {
        super.setHeadingText(headingText);
        if (this.control != null) {
            this.control.layout(true);
            this.control.redraw();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.titleFont = JFaceResources.getHeaderFont();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.layout(true);
            this.control.redraw();
        }
    }

    class FormLayout
    extends Layout {
        FormLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Control client = composite.getChildren()[0];
            Point csize = client.computeSize(SectionForm.this.widthHint, SectionForm.this.heightHint, flushCache);
            if (SectionForm.this.headingVisible) {
                csize.y += SectionForm.this.getTitleHeight();
            }
            return csize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control client = composite.getChildren()[0];
            if (client != null && !client.isDisposed()) {
                int theight = SectionForm.this.headingVisible ? SectionForm.this.getTitleHeight() : 0;
                client.setBounds(clientArea.x, clientArea.y + theight, clientArea.width, clientArea.height - theight);
            }
        }
    }
}

