/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.PageBook;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IFormSelectionListener;
import org.eclipse.update.ui.forms.internal.IFormWorkbook;

public class NoTabsWorkbook
implements IFormWorkbook {
    private Vector pages;
    private boolean firstPageSelected = true;
    private PageBook pageBook;
    private Vector listeners = new Vector();
    private IFormPage currentPage;

    public NoTabsWorkbook() {
        this.pages = new Vector();
    }

    public void addFormSelectionListener(IFormSelectionListener listener) {
        this.listeners.addElement(listener);
    }

    public void addPage(IFormPage page) {
        this.pages.add(page);
        if (this.firstPageSelected && this.currentPage == null) {
            this.selectPage(page, true);
        }
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
    }

    private void fireSelectionChanged(IFormPage page, boolean setFocus) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IFormSelectionListener listener = (IFormSelectionListener)iter.next();
            listener.formSelected(page, setFocus);
        }
    }

    public IFormPage[] getPages() {
        return this.pages.toArray(new IFormPage[this.pages.size()]);
    }

    public Control getControl() {
        return this.pageBook;
    }

    public IFormPage getCurrentPage() {
        return this.currentPage;
    }

    public boolean isFirstPageSelected() {
        return this.firstPageSelected;
    }

    public void removeFormSelectionListener(IFormSelectionListener listener) {
        this.listeners.removeElement(listener);
    }

    public void removePage(IFormPage page) {
        if (this.pages.contains(page)) {
            Control c = page.getControl();
            if (c != null && !c.isDisposed()) {
                c.dispose();
            }
            this.pages.remove(page);
        }
    }

    public void selectPage(final IFormPage page, final boolean setFocus) {
        final IFormPage oldPage = this.currentPage;
        this.currentPage = page;
        if (this.pageBook != null) {
            BusyIndicator.showWhile((Display)this.pageBook.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    NoTabsWorkbook.this.switchPages(oldPage, page, setFocus);
                }
            });
        }
    }

    public void setFirstPageSelected(boolean newFirstPageSelected) {
        this.firstPageSelected = newFirstPageSelected;
    }

    private void switchPages(IFormPage oldPage, IFormPage newPage, boolean setFocus) {
        if (oldPage != null && oldPage != newPage) {
            oldPage.becomesInvisible(newPage);
        }
        if (newPage.getControl() == null) {
            newPage.createControl((Composite)this.pageBook);
        }
        this.pageBook.showPage(newPage.getControl());
        newPage.becomesVisible(oldPage);
        this.fireSelectionChanged(newPage, setFocus);
    }
}

