/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HyperlinkAdapter;
import org.eclipse.update.ui.forms.internal.HyperlinkHandler;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public abstract class ExpandableGroup {
    private String text;
    private boolean expanded;
    private Composite expansion;
    protected SelectableFormLabel textLabel;
    private Composite control;
    private boolean expandable = true;

    public ExpandableGroup() {
    }

    public ExpandableGroup(int style) {
    }

    public Control getControl() {
        return this.control;
    }

    public void createControl(Composite parent, final FormWidgetFactory factory) {
        final Canvas container = new Canvas(parent, 0);
        container.setBackground(factory.getBackgroundColor());
        container.setLayout((Layout)new ExpandableLayout());
        container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ExpandableGroup.this.expandable) {
                    ExpandableGroup.this.repaint(e);
                }
            }
        });
        container.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Rectangle box = ExpandableGroup.this.getBoxBounds(null);
                if (box.contains(e.x, e.y)) {
                    container.setCursor(factory.getBusyCursor());
                    ExpandableGroup.this.setExpanded(!ExpandableGroup.this.isExpanded());
                    container.setCursor(null);
                }
            }
        });
        this.textLabel = this.createTextLabel((Composite)container, factory);
        this.getHyperlinkHandler(factory).registerHyperlink((Control)this.textLabel, new HyperlinkAdapter(){

            public void linkActivated(Control link) {
                ExpandableGroup.this.linkActivated();
                if (ExpandableGroup.this.expandable) {
                    ExpandableGroup.this.setExpanded(!ExpandableGroup.this.isExpanded());
                }
            }
        });
        this.textLabel.addFocusListener((FocusListener)factory.visibilityHandler);
        this.textLabel.addKeyListener((KeyListener)factory.keyboardHandler);
        if (this.text != null) {
            this.textLabel.setText(this.text);
        }
        this.expansion = factory.createComposite((Composite)container);
        this.fillExpansion(this.expansion, factory);
        this.control = container;
    }

    protected SelectableFormLabel createTextLabel(Composite parent, FormWidgetFactory factory) {
        SelectableFormLabel text = new SelectableFormLabel(parent, 64);
        text.setBackground(factory.getBackgroundColor());
        return text;
    }

    protected HyperlinkHandler getHyperlinkHandler(FormWidgetFactory factory) {
        return factory.getHyperlinkHandler();
    }

    public abstract void fillExpansion(Composite var1, FormWidgetFactory var2);

    public void setText(String text) {
        this.text = text;
        if (this.textLabel != null) {
            this.textLabel.setText(text);
        }
    }

    public String getText() {
        return this.text;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            if (expanded) {
                this.aboutToExpand();
            } else {
                this.aboutToCollapse();
            }
            this.expanded = expanded;
            this.expansion.setVisible(expanded);
            this.control.layout();
            if (expanded) {
                this.expanded();
            } else {
                this.collapsed();
            }
        }
    }

    private void repaint(PaintEvent e) {
        GC gc = e.gc;
        Rectangle box = this.getBoxBounds(gc);
        gc.setForeground(this.control.getDisplay().getSystemColor(18));
        gc.drawRectangle(box);
        gc.setForeground(this.control.getDisplay().getSystemColor(24));
        gc.drawLine(box.x + 2, box.y + 4, box.x + 6, box.y + 4);
        if (!this.isExpanded()) {
            gc.drawLine(box.x + 4, box.y + 2, box.x + 4, box.y + 6);
        }
    }

    private Rectangle getBoxBounds(GC gc) {
        int x = 0;
        int y = 0;
        boolean noGC = false;
        if (gc == null) {
            gc = new GC((Drawable)this.control);
            noGC = true;
        }
        gc.setFont(this.textLabel.getFont());
        int height = gc.getFontMetrics().getHeight();
        y = height / 2 - 4 + 1;
        y = Math.max(y, 0);
        if (noGC) {
            gc.dispose();
        }
        return new Rectangle(x, y, 8, 8);
    }

    protected void updateLayout() {
        this.control.layout();
    }

    protected void aboutToExpand() {
    }

    protected void aboutToCollapse() {
    }

    protected void expanded() {
    }

    protected void collapsed() {
    }

    protected void linkActivated() {
    }

    class ExpandableLayout
    extends Layout {
        ExpandableLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            Rectangle clientArea = parent.getClientArea();
            Point size = ExpandableGroup.this.textLabel.computeSize(-1, -1, changed);
            int x = 0;
            int y = 1;
            if (ExpandableGroup.this.expandable) {
                x = 16;
            }
            ExpandableGroup.this.textLabel.setBounds(x, y, size.x, size.y);
            y = ExpandableGroup.this.expandable ? Math.max(size.y, 8) + 2 + 2 : size.y + 2;
            if (ExpandableGroup.this.expanded) {
                int areaWidth = clientArea.width - x;
                size = ExpandableGroup.this.expansion.computeSize(areaWidth, -1, changed);
                ExpandableGroup.this.expansion.setBounds(x, y, size.x, size.y);
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            int width = 0;
            int height = 0;
            Point size = ExpandableGroup.this.textLabel.computeSize(-1, -1, changed);
            width = size.x;
            height = size.y + 2 + 2;
            if (ExpandableGroup.this.expanded) {
                size = ExpandableGroup.this.expansion.computeSize(wHint, -1, changed);
                width = Math.max(width, size.x);
                height += size.y;
            }
            if (ExpandableGroup.this.expandable) {
                height = Math.max(height, 8);
                width += 16;
            }
            return new Point(width, height);
        }
    }
}

