/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.ui.forms.internal;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IFormSelectionListener;
import org.eclipse.update.ui.forms.internal.IFormWorkbook;

public class CustomWorkbook
implements IFormWorkbook {
    private Hashtable pages;
    private boolean firstPageSelected = true;
    private CTabFolder tabFolder;
    private Vector listeners = new Vector();
    private IFormPage currentPage;

    public CustomWorkbook() {
        this.pages = new Hashtable();
    }

    public void addFormSelectionListener(IFormSelectionListener listener) {
        this.listeners.addElement(listener);
    }

    public void addPage(IFormPage page) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(page.getLabel());
        item.setToolTipText(page.getTitle());
        item.setData((Object)page);
        this.pages.put(page, item);
        if (this.firstPageSelected && this.currentPage == null) {
            this.selectPage(page, true);
        }
    }

    public void createControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 1024);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                IFormPage page = (IFormPage)item.getData();
                if (page != null) {
                    CustomWorkbook.this.selectPage(page, true);
                }
            }
        });
        this.tabFolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (CustomWorkbook.this.currentPage != null) {
                    CustomWorkbook.this.setControlSize(CustomWorkbook.this.currentPage.getControl());
                }
            }
        });
    }

    private void fireSelectionChanged(IFormPage page, boolean setFocus) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IFormSelectionListener listener = (IFormSelectionListener)iter.next();
            listener.formSelected(page, setFocus);
        }
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public IFormPage getCurrentPage() {
        return this.currentPage;
    }

    public boolean isFirstPageSelected() {
        return this.firstPageSelected;
    }

    public void removeFormSelectionListener(IFormSelectionListener listener) {
        this.listeners.removeElement(listener);
    }

    public void removePage(IFormPage page) {
        CTabItem item = (CTabItem)this.pages.get(page);
        if (item != null) {
            item.dispose();
        }
    }

    private void reselectPage(final IFormPage page) {
        this.tabFolder.getDisplay().asyncExec(new Runnable(){

            public void run() {
                CustomWorkbook.this.selectPage(page, true);
            }
        });
    }

    public void selectPage(final IFormPage page, final boolean setFocus) {
        final IFormPage oldPage = this.currentPage;
        this.currentPage = page;
        BusyIndicator.showWhile((Display)this.tabFolder.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CustomWorkbook.this.switchPages(oldPage, page, setFocus);
            }
        });
    }

    private void setControlSize(Control control) {
        Rectangle bounds = this.tabFolder.getBounds();
        Rectangle offset = this.tabFolder.getClientArea();
        bounds.x += offset.x;
        bounds.y += offset.y;
        bounds.width = offset.width;
        bounds.height = offset.height;
        control.setBounds(bounds);
        control.moveAbove((Control)this.tabFolder);
    }

    private void setControlVisible(Control control) {
        if (control == null) {
            return;
        }
        this.setControlSize(control);
        control.setVisible(true);
    }

    public void setFirstPageSelected(boolean newFirstPageSelected) {
        this.firstPageSelected = newFirstPageSelected;
    }

    private void switchPages(IFormPage oldPage, IFormPage newPage, boolean setFocus) {
        Control oldControl;
        boolean okToSwitch;
        if (oldPage != null && oldPage != newPage && !(okToSwitch = oldPage.becomesInvisible(newPage))) {
            this.reselectPage(oldPage);
            return;
        }
        if (newPage.getControl() == null) {
            newPage.createControl((Composite)this.tabFolder);
        }
        this.tabFolder.setSelection((CTabItem)this.pages.get(newPage));
        if (oldPage != null && oldPage != newPage && (oldControl = oldPage.getControl()) != null) {
            oldControl.setVisible(false);
        }
        Control newControl = newPage.getControl();
        newPage.becomesVisible(oldPage);
        this.setControlVisible(newControl);
        this.fireSelectionChanged(newPage, setFocus);
    }
}

