/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.forms.parts.FormLabel;

public class TraversableLabel
extends FormLabel {
    private boolean hasFocus;

    public TraversableLabel(Composite parent, int style) {
        super(parent, style);
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    TraversableLabel.this.notifyListeners(14);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                e.doit = true;
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                if (!TraversableLabel.this.hasFocus) {
                    TraversableLabel.this.hasFocus = true;
                    TraversableLabel.this.notifyListeners(13);
                    TraversableLabel.this.redraw();
                }
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                if (TraversableLabel.this.hasFocus) {
                    TraversableLabel.this.hasFocus = false;
                    TraversableLabel.this.notifyListeners(13);
                    TraversableLabel.this.redraw();
                }
            }
        });
        this.textMarginWidth = 1;
        this.textMarginHeight = 1;
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = TraversableLabel.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = TraversableLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = TraversableLabel.this.toControl(new Point(e.x, e.y));
                e.childID = TraversableLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = TraversableLabel.this.getBounds();
                Point pt = TraversableLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = TraversableLabel.this.getSelection() ? 2 : 0;
            }
        });
    }

    private void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    protected void paint(PaintEvent e) {
        super.paint(e);
        if (this.hasFocus) {
            GC gc = e.gc;
            Point size = this.getSize();
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }
}

