/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.FormsResources;
import org.eclipse.ui.forms.parts.FormToolkit;
import org.eclipse.ui.forms.parts.ILayoutExtension;
import org.eclipse.ui.forms.parts.SectionChangeManager;
import org.eclipse.ui.forms.parts.Twistie;

public abstract class SectionPart
implements IPropertyChangeListener {
    public static final int TITLE = 1;
    public static final int SEPARATOR = 2;
    public static final int DESCRIPTION = 4;
    public static final int COLLAPSABLE = 8;
    public static final int COMPACT = 16;
    public static final int SELECTION = 1;
    private String title;
    private Control client;
    protected Label titleLabel;
    protected Control separator;
    private SectionChangeManager sectionManager;
    private String description;
    private boolean dirty;
    protected Label descriptionLabel;
    private Twistie twistie;
    private boolean readOnly;
    private boolean collapsed = false;
    private Composite control;
    private int style;

    public SectionPart() {
        this(7);
    }

    public SectionPart(int style) {
        this.style = style;
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    public void commitChanges(boolean onSave) {
    }

    protected abstract Composite createClient(Composite var1, FormToolkit var2);

    public final Control createControl(Composite parent, FormToolkit toolkit) {
        Composite section = toolkit.createComposite(parent);
        SectionLayout slayout = new SectionLayout();
        section.setLayout((Layout)slayout);
        section.setData((Object)this);
        if (this.hasStyle(1)) {
            this.titleLabel = toolkit.createHeadingLabel(section, this.getTitle(), 64);
            if (this.hasStyle(8)) {
                this.twistie = toolkit.createTwistie(section);
                this.twistie.setSelection(this.collapsed);
                this.twistie.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SectionPart.this.doToggle();
                    }
                });
                this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        SectionPart.this.twistie.setSelection(!SectionPart.this.twistie.getSelection());
                        SectionPart.this.twistie.redraw();
                        SectionPart.this.doToggle();
                    }
                });
                this.titleLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent e) {
                        SectionPart.this.titleLabel.setCursor(FormsResources.getHandCursor());
                    }

                    public void mouseExit(MouseEvent e) {
                        SectionPart.this.titleLabel.setCursor(null);
                    }
                });
            }
        }
        if (this.hasStyle(2)) {
            this.separator = toolkit.createCompositeSeparator(section);
        }
        if (this.hasStyle(4) && this.description != null) {
            this.descriptionLabel = toolkit.createLabel(section, this.description, 64);
        }
        this.client = this.createClient(section, toolkit);
        section.setData((Object)this);
        this.control = section;
        return section;
    }

    private void doToggle() {
        this.collapsed = this.twistie.getSelection();
        this.reflow();
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setVisible(!this.collapsed);
        }
        if (this.client != null) {
            this.client.setVisible(!this.collapsed);
        }
    }

    protected void reflow() {
        this.control.setRedraw(false);
        this.control.getParent().setRedraw(false);
        this.control.layout(true);
        this.control.getParent().layout(true);
        this.control.setRedraw(true);
        this.control.getParent().setRedraw(true);
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public boolean doGlobalAction(String actionId) {
        return false;
    }

    public void expandTo(Object object) {
    }

    public final void fireChangeNotification(int changeType, Object changeObject) {
        if (this.sectionManager == null) {
            return;
        }
        this.sectionManager.dispatchNotification(this, changeType, changeObject);
    }

    public final void fireSelectionNotification(Object changeObject) {
        this.fireChangeNotification(1, changeObject);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public void initialize(Object input) {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void sectionChanged(SectionPart source, int changeType, Object changeObject) {
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(newDescription);
        }
    }

    public void setDirty(boolean newDirty) {
        this.dirty = newDirty;
    }

    public void setFocus() {
        if (this.twistie != null) {
            this.twistie.setFocus();
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.title);
        }
    }

    void setManager(SectionChangeManager manager) {
        this.sectionManager = manager;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
    }

    public void update() {
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.control != null && this.titleLabel != null && !this.control.isDisposed() && !this.titleLabel.isDisposed()) {
            this.titleLabel.setFont(JFaceResources.getBannerFont());
            this.control.layout(true);
        }
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    private boolean hasStyle(int value) {
        return (this.style & value) != 0;
    }

    private class SectionLayout
    extends Layout
    implements ILayoutExtension {
        int vspacing = 3;
        int sepHeight = 2;

        SectionLayout() {
        }

        public int computeMinimumWidth(Composite parent, boolean flush) {
            return 30;
        }

        public int computeMaximumWidth(Composite parent, boolean flush) {
            int maxWidth = 0;
            if (SectionPart.this.client != null) {
                Layout cl;
                if (SectionPart.this.client instanceof Composite && (cl = ((Composite)SectionPart.this.client).getLayout()) instanceof ILayoutExtension) {
                    maxWidth = ((ILayoutExtension)cl).computeMaximumWidth((Composite)SectionPart.this.client, flush);
                }
                if (maxWidth == 0) {
                    Point csize = SectionPart.this.client.computeSize(-1, -1, flush);
                    maxWidth = csize.x;
                }
            }
            if (SectionPart.this.hasStyle(1) && SectionPart.this.titleLabel != null) {
                Point hsize = SectionPart.this.titleLabel.computeSize(-1, -1, flush);
                maxWidth = Math.max(maxWidth, hsize.x);
            }
            if (SectionPart.this.hasStyle(4) && SectionPart.this.descriptionLabel != null) {
                Point dsize = SectionPart.this.descriptionLabel.computeSize(-1, -1, flush);
                maxWidth = Math.max(maxWidth, dsize.x);
            }
            return maxWidth;
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flush) {
            int width = 0;
            int height = 0;
            int cwidth = 0;
            int collapsedHeight = 0;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            cwidth = width;
            if (!(SectionPart.this.client == null || SectionPart.this.client.isDisposed() || SectionPart.this.twistie != null && SectionPart.this.twistie.getSelection() && SectionPart.this.hasStyle(16))) {
                Point csize = SectionPart.this.client.computeSize(wHint, -1);
                if (width == 0) {
                    cwidth = width = csize.x;
                }
                if (height == 0) {
                    height = csize.y;
                }
            }
            Point toggleSize = null;
            if (SectionPart.this.hasStyle(8) && SectionPart.this.twistie != null) {
                toggleSize = SectionPart.this.twistie.computeSize(-1, -1, flush);
            }
            if (hHint == -1 && SectionPart.this.hasStyle(1) && SectionPart.this.titleLabel != null) {
                int hwidth = cwidth;
                if (toggleSize != null) {
                    hwidth = cwidth - toggleSize.x - 5;
                }
                Point hsize = SectionPart.this.titleLabel.computeSize(hwidth, -1, flush);
                height += hsize.y;
                collapsedHeight = hsize.y;
                height += this.vspacing;
            }
            if (hHint == -1 && SectionPart.this.hasStyle(2)) {
                height += this.sepHeight;
                height += this.vspacing;
                collapsedHeight += this.vspacing + this.sepHeight;
            }
            if (hHint == -1 && SectionPart.this.hasStyle(4) && SectionPart.this.descriptionLabel != null) {
                Point dsize = SectionPart.this.descriptionLabel.computeSize(cwidth, -1, flush);
                height += dsize.y;
                height += this.vspacing;
            }
            if (SectionPart.this.twistie != null && SectionPart.this.twistie.getSelection()) {
                height = collapsedHeight;
            }
            return new Point(width, height);
        }

        protected void layout(Composite parent, boolean flush) {
            int width = parent.getClientArea().width;
            int height = parent.getClientArea().height;
            int y = 0;
            Point toggleSize = null;
            if (SectionPart.this.hasStyle(8)) {
                toggleSize = SectionPart.this.twistie.computeSize(-1, -1, flush);
            }
            if (SectionPart.this.hasStyle(1) && SectionPart.this.titleLabel != null) {
                int availableWidth = width;
                if (toggleSize != null) {
                    availableWidth = width - toggleSize.x - 5;
                }
                Point hsize = SectionPart.this.titleLabel.computeSize(availableWidth, -1, flush);
                int hx = 0;
                if (SectionPart.this.twistie != null) {
                    int ty = y + hsize.y - toggleSize.y;
                    SectionPart.this.twistie.setBounds(0, ty, toggleSize.x, toggleSize.y);
                    hx = toggleSize.x;
                }
                SectionPart.this.titleLabel.setBounds(hx, y, availableWidth, hsize.y);
                y += hsize.y + this.vspacing;
            }
            if (SectionPart.this.hasStyle(2) && SectionPart.this.separator != null) {
                SectionPart.this.separator.setBounds(0, y, width, 2);
                y += this.sepHeight + this.vspacing;
            }
            if (SectionPart.this.twistie != null && SectionPart.this.twistie.getSelection()) {
                return;
            }
            if (SectionPart.this.hasStyle(4) && SectionPart.this.descriptionLabel != null) {
                Point dsize = SectionPart.this.descriptionLabel.computeSize(width, -1, flush);
                SectionPart.this.descriptionLabel.setBounds(0, y, width, dsize.y);
                y += dsize.y + this.vspacing;
            }
            if (SectionPart.this.client != null) {
                SectionPart.this.client.setBounds(0, y, width, height - y);
            }
        }
    }
}

