/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.parts.FormToolkit;
import org.eclipse.ui.forms.parts.RichText;

public class ScrollableRichText {
    private ScrolledComposite scomp;
    private RichText richText;
    private String text;
    private FormToolkit factory;
    private int style;

    public ScrollableRichText(int style) {
        this.style = style;
        this.factory = new FormToolkit();
    }

    public ScrollableRichText(FormColors colors, int style) {
        this.style = style;
        this.factory = new FormToolkit(colors);
    }

    public void createControl(Composite parent) {
        this.scomp = new ScrolledComposite(parent, this.style);
        this.scomp.setBackground(this.factory.getColors().getBackground());
        this.richText = this.factory.createRichText((Composite)this.scomp, false);
        this.richText.marginWidth = 2;
        this.richText.marginHeight = 2;
        this.richText.setHyperlinkSettings(this.factory.getHyperlinkGroup());
        this.scomp.setContent((Control)this.richText);
        this.scomp.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ScrollableRichText.this.updateSize();
            }
        });
        this.richText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ScrollableRichText.this.factory != null) {
                    ScrollableRichText.this.factory.dispose();
                    ScrollableRichText.this.factory = null;
                }
            }
        });
        if (this.text != null) {
            this.loadText(this.text);
        }
    }

    public Control getControl() {
        return this.scomp;
    }

    public void setText(String text) {
        this.text = text;
        this.loadText(text);
    }

    private void loadText(String text) {
        if (this.richText != null) {
            String markup = text;
            if (!markup.startsWith("<form>")) {
                markup = "<form>" + text + "</form>";
            }
            this.richText.setText(markup, true, false);
            this.updateSize();
            this.richText.redraw();
            this.scomp.layout();
        }
    }

    private void updateSize() {
        Rectangle ssize = this.scomp.getClientArea();
        int swidth = ssize.width;
        ScrollBar vbar = this.scomp.getVerticalBar();
        if (vbar != null) {
            swidth -= vbar.getSize().x;
        }
        Point size = this.richText.computeSize(swidth, -1, true);
        this.richText.setSize(size);
    }

    public void dispose() {
        this.factory.dispose();
    }
}

