/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.parts.HyperlinkSegment;
import org.eclipse.ui.forms.internal.parts.Locator;
import org.eclipse.ui.forms.internal.parts.Paragraph;
import org.eclipse.ui.forms.internal.parts.ParagraphSegment;
import org.eclipse.ui.forms.internal.parts.RichTextModel;
import org.eclipse.ui.forms.internal.parts.TextSegment;
import org.eclipse.ui.forms.parts.FormUtil;
import org.eclipse.ui.forms.parts.HyperlinkEvent;
import org.eclipse.ui.forms.parts.HyperlinkListener;
import org.eclipse.ui.forms.parts.ILayoutExtension;
import org.eclipse.update.ui.forms.internal.FormsPlugin;

public class RichText
extends Canvas {
    public static final String URL_HANDLER_ID = "urlHandler";
    public int marginWidth = 0;
    public int marginHeight = 1;
    private boolean hasFocus;
    private boolean paragraphsSeparated = true;
    private RichTextModel model;
    private Vector listeners;
    private Hashtable imageTable = new Hashtable();
    private HyperlinkSegment entered;
    private boolean mouseDown = false;
    private Action openAction;
    private Action copyShortcutAction;
    private boolean loading = true;
    private String loadingText = "Loading...";

    public RichText(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new RichTextLayout());
        this.model = new RichTextModel();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RichText.this.model.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                RichText.this.paint(e);
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    RichText.this.activateSelectedLink();
                    return;
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                if (!RichText.this.model.hasFocusSegments()) {
                    e.doit = true;
                    return;
                }
                if (e.detail == 16) {
                    e.doit = RichText.this.advance(true);
                } else if (e.detail == 8) {
                    e.doit = RichText.this.advance(false);
                } else if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!RichText.this.hasFocus) {
                    RichText.this.hasFocus = true;
                    RichText.this.handleFocusChange();
                }
            }

            public void focusLost(FocusEvent e) {
                if (RichText.this.hasFocus) {
                    RichText.this.hasFocus = false;
                    RichText.this.handleFocusChange();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                RichText.this.handleMouseClick(e, true);
            }

            public void mouseUp(MouseEvent e) {
                RichText.this.handleMouseClick(e, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                RichText.this.handleMouseMove(e);
            }

            public void mouseExit(MouseEvent e) {
                if (RichText.this.entered != null) {
                    RichText.this.exitLink(RichText.this.entered);
                    RichText.this.paintLinkHover(RichText.this.entered, false);
                    RichText.this.entered = null;
                    RichText.this.setCursor(null);
                }
            }

            public void mouseHover(MouseEvent e) {
                RichText.this.handleMouseHover(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                RichText.this.handleMouseMove(e);
            }
        });
        this.initAccessible();
        this.makeActions();
    }

    public boolean getFocus() {
        return this.hasFocus;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public String getLoadingText() {
        return this.loadingText;
    }

    public void setLoadingText(String loadingText) {
        this.loadingText = loadingText;
    }

    public void setParagraphsSeparated(boolean value) {
        this.paragraphsSeparated = value;
    }

    public boolean getParagraphsSeparated() {
        return this.paragraphsSeparated;
    }

    public void setImage(String key, Image image) {
        this.imageTable.put(key, image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setText(String text, boolean parseTags, boolean expandURLs) {
        try {
            block6: {
                try {
                    if (parseTags) {
                        this.model.parseTaggedText(text, expandURLs);
                        break block6;
                    }
                    this.model.parseRegularText(text, expandURLs);
                }
                catch (CoreException e) {
                    FormsPlugin.logException(e);
                }
            }
            Object var5_7 = null;
            this.loading = false;
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.loading = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setContents(InputStream is, boolean expandURLs) {
        try {
            try {
                this.model.parseInputStream(is, expandURLs);
            }
            catch (CoreException e) {
                FormsPlugin.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.loading = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.loading = false;
            return;
        }
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.model.getHyperlinkSettings();
    }

    public void setHyperlinkSettings(HyperlinkSettings settings) {
        this.model.setHyperlinkSettings(settings);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        HyperlinkSegment link = this.model.getSelectedLink();
        if (link != null) {
            this.contributeLinkActions(manager, link);
        }
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                RichText.this.activateSelectedLink();
            }
        };
        this.openAction.setText(FormsPlugin.getResourceString("FormEgine.linkPopup.open"));
        this.copyShortcutAction = new Action(){

            public void run() {
                RichText.this.copyShortcut(RichText.this.model.getSelectedLink());
            }
        };
        this.copyShortcutAction.setText(FormsPlugin.getResourceString("FormEgine.linkPopup.copyShortcut"));
    }

    private String getAcessibleText() {
        return this.model.getAccessibleText();
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = RichText.this.getAcessibleText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = RichText.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = RichText.this.toControl(new Point(e.x, e.y));
                e.childID = RichText.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = RichText.this.getBounds();
                Point pt = RichText.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    private void handleMouseClick(MouseEvent e, boolean down) {
        if (down) {
            HyperlinkSegment segmentUnder = this.model.findHyperlinkAt(e.x, e.y);
            if (segmentUnder != null) {
                HyperlinkSegment oldLink = this.model.getSelectedLink();
                this.model.selectLink(segmentUnder);
                this.enterLink(segmentUnder);
                this.paintFocusTransfer(oldLink, segmentUnder);
            }
            this.mouseDown = true;
        } else {
            HyperlinkSegment segmentUnder;
            if (e.button == 1 && (segmentUnder = this.model.findHyperlinkAt(e.x, e.y)) != null) {
                this.activateLink(segmentUnder);
            }
            this.mouseDown = false;
        }
    }

    private void handleMouseHover(MouseEvent e) {
    }

    private void handleMouseMove(MouseEvent e) {
        if (this.mouseDown) {
            this.handleDrag(e);
            return;
        }
        TextSegment segmentUnder = this.model.findSegmentAt(e.x, e.y);
        if (segmentUnder == null) {
            if (this.entered != null) {
                this.exitLink(this.entered);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(null);
        } else if (segmentUnder instanceof HyperlinkSegment) {
            HyperlinkSegment linkUnder = (HyperlinkSegment)segmentUnder;
            if (this.entered == null) {
                this.entered = linkUnder;
                this.enterLink(linkUnder);
                this.paintLinkHover(this.entered, true);
                this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
            }
        } else {
            if (this.entered != null) {
                this.exitLink(this.entered);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(this.model.getHyperlinkSettings().getTextCursor());
        }
    }

    private boolean advance(boolean next) {
        HyperlinkSegment current = this.model.getSelectedLink();
        if (current != null) {
            this.exitLink(current);
        }
        boolean valid = this.model.traverseLinks(next);
        HyperlinkSegment newLink = this.model.getSelectedLink();
        if (valid) {
            this.enterLink(newLink);
        }
        this.paintFocusTransfer(current, newLink);
        if (newLink != null) {
            this.ensureVisible(newLink);
        }
        return !valid;
    }

    private void handleFocusChange() {
        if (this.hasFocus) {
            this.model.traverseLinks(true);
            this.enterLink(this.model.getSelectedLink());
            this.paintFocusTransfer(null, this.model.getSelectedLink());
        } else {
            this.paintFocusTransfer(this.model.getSelectedLink(), null);
            this.model.selectLink(null);
        }
    }

    private void enterLink(HyperlinkSegment link) {
        if (link == null || this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent e = new HyperlinkEvent((Object)this, link.getHref(), link.getText());
        int i = 0;
        while (i < size) {
            HyperlinkListener listener = (HyperlinkListener)this.listeners.get(i);
            listener.linkEntered(e);
            ++i;
        }
    }

    private void exitLink(HyperlinkSegment link) {
        if (link == null || this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent e = new HyperlinkEvent((Object)this, link.getHref(), link.getText());
        int i = 0;
        while (i < size) {
            HyperlinkListener listener = (HyperlinkListener)this.listeners.get(i);
            listener.linkExited(e);
            ++i;
        }
    }

    private void paintLinkHover(HyperlinkSegment link, boolean hover) {
        GC gc = new GC((Drawable)this);
        HyperlinkSettings settings = this.getHyperlinkSettings();
        gc.setForeground(hover ? settings.getActiveForeground() : settings.getForeground());
        gc.setBackground(this.getBackground());
        gc.setFont(this.getFont());
        boolean selected = link == this.model.getSelectedLink();
        link.repaint(gc, hover);
        if (selected) {
            link.paintFocus(gc, this.getBackground(), this.getForeground(), false);
            link.paintFocus(gc, this.getBackground(), this.getForeground(), true);
        }
        gc.dispose();
    }

    private void activateSelectedLink() {
        HyperlinkSegment link = this.model.getSelectedLink();
        if (link != null) {
            this.activateLink(link);
        }
    }

    private void activateLink(HyperlinkSegment link) {
        this.setCursor(this.model.getHyperlinkSettings().getBusyCursor());
        if (this.listeners != null) {
            int size = this.listeners.size();
            HyperlinkEvent e = new HyperlinkEvent((Object)this, link.getHref(), link.getText());
            int i = 0;
            while (i < size) {
                HyperlinkListener listener = (HyperlinkListener)this.listeners.get(i);
                listener.linkActivated(e);
                ++i;
            }
        }
        if (!this.isDisposed()) {
            this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
        }
    }

    private void paint(PaintEvent e) {
        int width = this.getClientArea().width;
        GC gc = e.gc;
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
        Locator loc = new Locator();
        loc.marginWidth = this.marginWidth;
        loc.marginHeight = this.marginHeight;
        loc.x = this.marginWidth;
        loc.y = this.marginHeight;
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        if (this.loading) {
            int textWidth = gc.textExtent((String)this.loadingText).x;
            gc.drawText(this.loadingText, width / 2 - textWidth / 2, this.getClientArea().height / 2 - lineHeight / 2);
            return;
        }
        Paragraph[] paragraphs = this.model.getParagraphs();
        HyperlinkSegment selectedLink = this.model.getSelectedLink();
        int i = 0;
        while (i < paragraphs.length) {
            Paragraph p = paragraphs[i];
            if (i > 0 && this.paragraphsSeparated && p.getAddVerticalSpace()) {
                loc.y += this.getParagraphSpacing(lineHeight);
            }
            loc.indent = p.getIndent();
            loc.resetCaret();
            loc.rowHeight = 0;
            p.paint(gc, width, loc, lineHeight, this.imageTable, selectedLink);
            ++i;
        }
    }

    private int getParagraphSpacing(int lineHeight) {
        return lineHeight / 2;
    }

    private void paintFocusTransfer(HyperlinkSegment oldLink, HyperlinkSegment newLink) {
        GC gc = new GC((Drawable)this);
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        gc.setFont(this.getFont());
        if (oldLink != null) {
            gc.setBackground(bg);
            gc.setForeground(fg);
            oldLink.paintFocus(gc, bg, fg, false);
        }
        if (newLink != null) {
            gc.setBackground(bg);
            gc.setForeground(fg);
            newLink.paintFocus(gc, bg, fg, true);
        }
        gc.dispose();
    }

    private void contributeLinkActions(IMenuManager manager, HyperlinkSegment link) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.copyShortcutAction);
        manager.add((IContributionItem)new Separator());
    }

    private void copyShortcut(HyperlinkSegment link) {
        String text = link.getText();
        Clipboard clipboard = new Clipboard(this.getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void ensureVisible(HyperlinkSegment segment) {
        Rectangle bounds = segment.getBounds();
        ScrolledComposite scomp = this.getScrolledComposite();
        if (scomp == null) {
            return;
        }
        Point origin = FormUtil.getControlLocation(scomp, (Control)this);
        origin.x += bounds.x;
        origin.y += bounds.y;
        FormUtil.ensureVisible(scomp, origin, new Point(bounds.width, bounds.height));
    }

    private ScrolledComposite getScrolledComposite() {
        Composite parent = this.getParent();
        while (parent != null) {
            if (parent instanceof ScrolledComposite) {
                return (ScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void handleDrag(MouseEvent e) {
    }

    private class RichTextLayout
    extends Layout
    implements ILayoutExtension {
        public int computeMaximumWidth(Composite parent, boolean changed) {
            return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return 30;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean changed) {
            int innerWidth = wHint;
            if (RichText.this.isLoading()) {
                return this.computeLoading();
            }
            if (innerWidth != -1) {
                innerWidth -= RichText.this.marginWidth * 2;
            }
            Point textSize = this.computeTextSize(innerWidth);
            int textWidth = textSize.x + 2 * RichText.this.marginWidth;
            int textHeight = textSize.y + 2 * RichText.this.marginHeight;
            Point result = new Point(textWidth, textHeight);
            return result;
        }

        private Point computeLoading() {
            GC gc = new GC((Drawable)RichText.this);
            gc.setFont(RichText.this.getFont());
            String loadingText = RichText.this.getLoadingText();
            Point size = gc.textExtent(loadingText);
            gc.dispose();
            size.x += 2 * RichText.this.marginWidth;
            size.y += 2 * RichText.this.marginHeight;
            return size;
        }

        private Point computeTextSize(int wHint) {
            Paragraph[] paragraphs = RichText.this.model.getParagraphs();
            GC gc = new GC((Drawable)RichText.this);
            gc.setFont(RichText.this.getFont());
            Locator loc = new Locator();
            int width = wHint != -1 ? wHint : 0;
            FontMetrics fm = gc.getFontMetrics();
            int lineHeight = fm.getHeight();
            int i = 0;
            while (i < paragraphs.length) {
                Paragraph p = paragraphs[i];
                if (i > 0 && RichText.this.getParagraphsSeparated() && p.getAddVerticalSpace()) {
                    loc.y += RichText.this.getParagraphSpacing(lineHeight);
                }
                loc.rowHeight = 0;
                loc.indent = p.getIndent();
                loc.x = p.getIndent();
                ParagraphSegment[] segments = p.getSegments();
                if (segments.length > 0) {
                    int j = 0;
                    while (j < segments.length) {
                        ParagraphSegment segment = segments[j];
                        segment.advanceLocator(gc, wHint, loc, RichText.this.imageTable);
                        width = Math.max(width, loc.width);
                        ++j;
                    }
                    loc.y += loc.rowHeight;
                } else {
                    loc.y += lineHeight;
                }
                ++i;
            }
            gc.dispose();
            return new Point(width, loc.y);
        }

        protected void layout(Composite composite, boolean flushCache) {
        }
    }
}

