/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.FormsResources;
import org.eclipse.ui.forms.parts.HyperlinkEvent;
import org.eclipse.ui.forms.parts.HyperlinkListener;
import org.eclipse.ui.forms.parts.TraversableLabel;

public class Hyperlink
extends TraversableLabel {
    private Vector listeners;

    public Hyperlink(Composite parent, int style) {
        super(parent, style);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        if (Hyperlink.this.getSelection()) {
                            Hyperlink.this.handleEnter();
                            break;
                        }
                        Hyperlink.this.handleExit();
                        break;
                    }
                    case 14: {
                        Hyperlink.this.handleActivate();
                        break;
                    }
                    case 6: {
                        Hyperlink.this.handleEnter();
                        break;
                    }
                    case 7: {
                        Hyperlink.this.handleExit();
                        break;
                    }
                    case 4: {
                        Hyperlink.this.handleMouseUp(e);
                    }
                }
            }
        };
        this.addListener(13, listener);
        this.addListener(14, listener);
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(4, listener);
        this.setCursor(FormsResources.getHandCursor());
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setHref(Object href) {
        this.setData("href", href);
    }

    public Object getHref() {
        return this.getData("href");
    }

    private void handleEnter() {
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent e = new HyperlinkEvent((Object)this, this.getHref(), this.getText());
        int i = 0;
        while (i < size) {
            HyperlinkListener listener = (HyperlinkListener)this.listeners.get(i);
            listener.linkEntered(e);
            ++i;
        }
    }

    private void handleExit() {
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent e = new HyperlinkEvent((Object)this, this.getHref(), this.getText());
        int i = 0;
        while (i < size) {
            HyperlinkListener listener = (HyperlinkListener)this.listeners.get(i);
            listener.linkExited(e);
            ++i;
        }
    }

    private void handleActivate() {
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        this.setCursor(FormsResources.getBusyCursor());
        HyperlinkEvent e = new HyperlinkEvent((Object)this, this.getHref(), this.getText());
        int i = 0;
        while (i < size) {
            HyperlinkListener listener = (HyperlinkListener)this.listeners.get(i);
            listener.linkActivated(e);
            ++i;
        }
        if (!this.isDisposed()) {
            this.setCursor(FormsResources.getHandCursor());
        }
    }

    private void handleMouseUp(Event e) {
        if (e.button != 1) {
            return;
        }
        Point size = this.getSize();
        if (e.x < 0) {
            return;
        }
        if (e.y < 0) {
            return;
        }
        if (e.x >= size.x) {
            return;
        }
        if (e.y >= size.y) {
            return;
        }
        this.handleActivate();
    }
}

