/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.parts.ILayoutExtension;
import org.eclipse.ui.forms.parts.TableData;

public class HTMLTableLayout
extends Layout
implements ILayoutExtension {
    public int numColumns = 1;
    public int leftMargin = 5;
    public int rightMargin = 5;
    public int topMargin = 5;
    public int bottomMargin = 5;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public boolean makeColumnsEqualWidth = false;
    private boolean initialLayout = true;
    private Vector grid = null;
    private int[] minColumnWidths;
    private int[] maxColumnWidths;
    private int widestColumnWidth;
    private int[] growingColumns;

    public int computeMinimumWidth(Composite parent, boolean changed) {
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        if (this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.numColumns];
        }
        int i = 0;
        while (i < this.numColumns) {
            this.minColumnWidths[i] = 0;
            ++i;
        }
        return this.internalGetMinimumWidth(parent, changed);
    }

    public int computeMaximumWidth(Composite parent, boolean changed) {
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        if (this.maxColumnWidths == null) {
            this.maxColumnWidths = new int[this.numColumns];
        }
        int i = 0;
        while (i < this.numColumns) {
            this.maxColumnWidths[i] = 0;
            ++i;
        }
        return this.internalGetMaximumWidth(parent, changed);
    }

    protected void layout(Composite parent, boolean changed) {
        int i;
        int[] columnWidths;
        Rectangle clientArea = parent.getClientArea();
        Control[] children = parent.getChildren();
        if (children.length == 0) {
            return;
        }
        int parentWidth = clientArea.width;
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        this.resetColumnWidths();
        int minWidth = this.internalGetMinimumWidth(parent, changed);
        int maxWidth = this.internalGetMaximumWidth(parent, changed);
        int tableWidth = parentWidth;
        if (parentWidth < minWidth) {
            tableWidth = minWidth;
            if (this.makeColumnsEqualWidth) {
                columnWidths = new int[this.numColumns];
                int i2 = 0;
                while (i2 < this.numColumns) {
                    columnWidths[i2] = this.widestColumnWidth;
                    ++i2;
                }
            } else {
                columnWidths = this.minColumnWidths;
            }
        } else if (parentWidth > maxWidth) {
            if (this.growingColumns.length == 0) {
                tableWidth = maxWidth;
                columnWidths = this.maxColumnWidths;
            } else {
                columnWidths = new int[this.numColumns];
                int colSpace = tableWidth - this.leftMargin - this.rightMargin;
                colSpace -= (this.numColumns - 1) * this.horizontalSpacing;
                int extra = parentWidth - maxWidth;
                int colExtra = extra / this.growingColumns.length;
                int i3 = 0;
                while (i3 < this.numColumns) {
                    columnWidths[i3] = this.maxColumnWidths[i3];
                    if (this.isGrowingColumn(i3)) {
                        int n = i3;
                        columnWidths[n] = columnWidths[n] + colExtra;
                    }
                    ++i3;
                }
            }
        } else {
            columnWidths = new int[this.numColumns];
            if (this.makeColumnsEqualWidth) {
                int colSpace = tableWidth - this.leftMargin - this.rightMargin;
                int col = (colSpace -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                i = 0;
                while (i < this.numColumns) {
                    columnWidths[i] = col;
                    ++i;
                }
            } else {
                int[] extraSpace = this.calculateExtraSpace(tableWidth, maxWidth, minWidth);
                int i4 = 0;
                while (i4 < this.numColumns) {
                    int minCWidth = this.minColumnWidths[i4];
                    columnWidths[i4] = minCWidth + extraSpace[i4];
                    ++i4;
                }
            }
        }
        int x = 0;
        int y = this.topMargin;
        i = 0;
        while (i < this.grid.size()) {
            Control child;
            TableData td;
            TableData[] row = (TableData[])this.grid.elementAt(i);
            int rowHeight = 0;
            x = this.leftMargin;
            int j = 0;
            while (j < this.numColumns) {
                td = row[j];
                if (td.isItemData) {
                    child = children[td.childIndex];
                    int span = td.colspan;
                    int cwidth = 0;
                    int k = j;
                    while (k < j + span) {
                        cwidth += columnWidths[k];
                        if (k < j + span - 1) {
                            cwidth += this.horizontalSpacing;
                        }
                        ++k;
                    }
                    Point size = this.computeSize(child, cwidth, changed);
                    td.compWidth = cwidth;
                    if (td.heightHint != -1) {
                        size = new Point(size.x, td.heightHint);
                    }
                    td.compSize = size;
                    rowHeight = Math.max(rowHeight, size.y);
                }
                ++j;
            }
            j = 0;
            while (j < this.numColumns) {
                td = row[j];
                if (td.isItemData) {
                    child = children[td.childIndex];
                    this.placeControl(child, td, x, y, rowHeight);
                    x += td.compWidth;
                    if (j < this.numColumns - 1) {
                        x += this.horizontalSpacing;
                    }
                }
                ++j;
            }
            y += rowHeight + this.verticalSpacing;
            ++i;
        }
    }

    boolean isGrowingColumn(int col) {
        if (this.growingColumns == null) {
            return false;
        }
        int i = 0;
        while (i < this.growingColumns.length) {
            if (col == this.growingColumns[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int[] calculateExtraSpace(int tableWidth, int maxWidth, int minWidth) {
        int fixedPart = this.leftMargin + this.rightMargin + (this.numColumns - 1) * this.horizontalSpacing;
        int D = maxWidth - minWidth;
        int W = tableWidth - fixedPart - minWidth;
        int[] extraSpace = new int[this.numColumns];
        int rem = 0;
        int i = 0;
        while (i < this.numColumns) {
            int extra;
            int cmin = this.minColumnWidths[i];
            int cmax = this.maxColumnWidths[i];
            int d = cmax - cmin;
            int n = extra = D != 0 ? d * W / D : 0;
            if (i < this.numColumns - 1) {
                extraSpace[i] = extra;
                rem += extra;
            } else {
                extraSpace[i] = W - rem;
            }
            ++i;
        }
        return extraSpace;
    }

    Point computeSize(Control child, int width, boolean changed) {
        int widthArg = width;
        if (!this.isWrap(child)) {
            widthArg = -1;
        }
        Point size = child.computeSize(widthArg, -1, changed);
        return size;
    }

    void placeControl(Control control, TableData td, int x, int y, int rowHeight) {
        int xloc = x + td.indent;
        int yloc = y;
        int width = td.compSize.x;
        int height = td.compSize.y;
        int colWidth = td.compWidth;
        if (td.align == 2) {
            xloc = x + colWidth / 2 - width / 2;
        } else if (td.align == 3) {
            xloc = x + colWidth - width;
        } else if (td.align == 7) {
            width = colWidth;
        }
        if (td.valign == 5) {
            yloc = y + rowHeight / 2 - height / 2;
        } else if (td.valign == 6) {
            yloc = y + rowHeight - height;
        } else if (td.valign == 7) {
            height = rowHeight;
        }
        control.setBounds(xloc, yloc, width, height);
    }

    void createGrid(Composite composite) {
        TableData spacerSpec;
        Vector growingCols = new Vector();
        Control[] children = composite.getChildren();
        if (children.length == 0) {
            return;
        }
        this.grid.addElement(this.createEmptyRow());
        int row = 0;
        int column = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            TableData spec = (TableData)child.getLayoutData();
            while (((TableData[])this.grid.elementAt(row))[column] != null) {
                if (++column < this.numColumns) continue;
                column = 0;
                if (++row < this.grid.size()) continue;
                this.grid.addElement(this.createEmptyRow());
            }
            if (column + spec.colspan - 1 >= this.numColumns) {
                this.grid.addElement(this.createEmptyRow());
                ++row;
                column = 0;
            }
            int j = 2;
            while (j <= spec.rowspan) {
                if (row + j > this.grid.size()) {
                    this.grid.addElement(this.createEmptyRow());
                }
                ++j;
            }
            ((TableData[])this.grid.elementAt((int)row))[column] = spec;
            spec.childIndex = i;
            if (spec.grabHorizontal) {
                this.updateGrowingColumns(growingCols, spec, column);
            }
            int rowFill = spec.rowspan - 1;
            int columnFill = spec.colspan - 1;
            int r = 1;
            while (r <= rowFill) {
                int c = 0;
                while (c < spec.colspan) {
                    spacerSpec = new TableData();
                    spacerSpec.isItemData = false;
                    ((TableData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                    ++c;
                }
                ++r;
            }
            int c = 1;
            while (c <= columnFill) {
                int r2 = 0;
                while (r2 < spec.rowspan) {
                    spacerSpec = new TableData();
                    spacerSpec.isItemData = false;
                    ((TableData[])this.grid.elementAt((int)(row + r2)))[column + c] = spacerSpec;
                    ++r2;
                }
                ++c;
            }
            column = column + spec.colspan - 1;
            ++i;
        }
        int k = column + 1;
        while (k < this.numColumns) {
            spacerSpec = new TableData();
            spacerSpec.isItemData = false;
            ((TableData[])this.grid.elementAt((int)row))[k] = spacerSpec;
            ++k;
        }
        k = row + 1;
        while (k < this.grid.size()) {
            spacerSpec = new TableData();
            spacerSpec.isItemData = false;
            ((TableData[])this.grid.elementAt((int)k))[column] = spacerSpec;
            ++k;
        }
        this.growingColumns = new int[growingCols.size()];
        i = 0;
        while (i < growingCols.size()) {
            this.growingColumns[i] = (Integer)growingCols.get(i);
            ++i;
        }
    }

    private void updateGrowingColumns(Vector growingColumns, TableData spec, int column) {
        int affectedColumn = column + spec.colspan - 1;
        int i = 0;
        while (i < growingColumns.size()) {
            Integer col = (Integer)growingColumns.get(i);
            if (col == affectedColumn) {
                return;
            }
            ++i;
        }
        growingColumns.add(new Integer(affectedColumn));
    }

    private TableData[] createEmptyRow() {
        TableData[] row = new TableData[this.numColumns];
        int i = 0;
        while (i < this.numColumns) {
            row[i] = null;
            ++i;
        }
        return row;
    }

    protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
        int i;
        int col;
        int[] columnWidths;
        Control[] children = parent.getChildren();
        if (children.length == 0) {
            return new Point(0, 0);
        }
        int parentWidth = wHint;
        changed = true;
        this.initializeIfNeeded(parent, changed);
        if (this.initialLayout) {
            changed = true;
            this.initialLayout = false;
        }
        if (this.grid == null || changed) {
            changed = true;
            this.grid = new Vector();
            this.createGrid(parent);
        }
        this.resetColumnWidths();
        int minWidth = this.internalGetMinimumWidth(parent, changed);
        int maxWidth = this.internalGetMaximumWidth(parent, changed);
        int tableWidth = parentWidth;
        if (parentWidth < minWidth) {
            tableWidth = minWidth;
            if (this.makeColumnsEqualWidth) {
                columnWidths = new int[this.numColumns];
                int i2 = 0;
                while (i2 < this.numColumns) {
                    columnWidths[i2] = this.widestColumnWidth;
                    ++i2;
                }
            } else {
                columnWidths = this.minColumnWidths;
            }
        } else if (parentWidth > maxWidth) {
            if (this.makeColumnsEqualWidth) {
                columnWidths = new int[this.numColumns];
                int colSpace = parentWidth - this.leftMargin - this.rightMargin;
                col = (colSpace -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                i = 0;
                while (i < this.numColumns) {
                    columnWidths[i] = col;
                    ++i;
                }
            } else {
                tableWidth = maxWidth;
                columnWidths = this.maxColumnWidths;
            }
        } else {
            columnWidths = new int[this.numColumns];
            if (this.makeColumnsEqualWidth) {
                int colSpace = tableWidth - this.leftMargin - this.rightMargin;
                col = (colSpace -= (this.numColumns - 1) * this.horizontalSpacing) / this.numColumns;
                i = 0;
                while (i < this.numColumns) {
                    columnWidths[i] = col;
                    ++i;
                }
            } else {
                int[] extraSpace = this.calculateExtraSpace(tableWidth, maxWidth, minWidth);
                int i3 = 0;
                while (i3 < this.numColumns) {
                    int minCWidth = this.minColumnWidths[i3];
                    columnWidths[i3] = minCWidth + extraSpace[i3];
                    ++i3;
                }
            }
        }
        int totalHeight = 0;
        int y = this.topMargin;
        i = 0;
        while (i < this.grid.size()) {
            TableData[] row = (TableData[])this.grid.elementAt(i);
            int rowHeight = 0;
            int j = 0;
            while (j < this.numColumns) {
                TableData td = row[j];
                if (td.isItemData) {
                    Control child = children[td.childIndex];
                    int span = td.colspan;
                    int cwidth = 0;
                    int k = j;
                    while (k < j + span) {
                        if (k > j) {
                            cwidth += this.horizontalSpacing;
                        }
                        cwidth += columnWidths[k];
                        ++k;
                    }
                    int cy = td.heightHint;
                    if (cy == -1) {
                        Point size = this.computeSize(child, cwidth, changed);
                        cy = size.y;
                    }
                    rowHeight = Math.max(rowHeight, cy);
                }
                ++j;
            }
            y += rowHeight + this.verticalSpacing;
            ++i;
        }
        totalHeight = y + this.bottomMargin;
        return new Point(tableWidth, totalHeight);
    }

    int internalGetMinimumWidth(Composite parent, boolean changed) {
        int i;
        if (changed) {
            this.calculateMinimumColumnWidths(parent, true);
        }
        int minimumWidth = 0;
        this.widestColumnWidth = 0;
        if (this.makeColumnsEqualWidth) {
            i = 0;
            while (i < this.numColumns) {
                this.widestColumnWidth = Math.max(this.widestColumnWidth, this.minColumnWidths[i]);
                ++i;
            }
        }
        i = 0;
        while (i < this.numColumns) {
            if (i > 0) {
                minimumWidth += this.horizontalSpacing;
            }
            minimumWidth = this.makeColumnsEqualWidth ? (minimumWidth += this.widestColumnWidth) : (minimumWidth += this.minColumnWidths[i]);
            ++i;
        }
        return minimumWidth += this.leftMargin + this.rightMargin;
    }

    int internalGetMaximumWidth(Composite parent, boolean changed) {
        if (changed) {
            this.calculateMaximumColumnWidths(parent, true);
        }
        int maximumWidth = 0;
        int i = 0;
        while (i < this.numColumns) {
            if (i > 0) {
                maximumWidth += this.horizontalSpacing;
            }
            maximumWidth += this.maxColumnWidths[i];
            ++i;
        }
        return maximumWidth += this.leftMargin + this.rightMargin;
    }

    void resetColumnWidths() {
        if (this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.numColumns];
        }
        if (this.maxColumnWidths == null) {
            this.maxColumnWidths = new int[this.numColumns];
        }
        int i = 0;
        while (i < this.numColumns) {
            this.minColumnWidths[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.numColumns) {
            this.maxColumnWidths[i] = 0;
            ++i;
        }
    }

    void calculateMinimumColumnWidths(Composite parent, boolean changed) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < this.grid.size()) {
            TableData[] row = (TableData[])this.grid.elementAt(i);
            int j = 0;
            while (j < this.numColumns) {
                TableData td = row[j];
                if (td.isItemData) {
                    Composite cc;
                    Layout l;
                    Control child = children[td.childIndex];
                    int minWidth = -1;
                    if (child instanceof Composite && (l = (cc = (Composite)child).getLayout()) instanceof ILayoutExtension) {
                        minWidth = ((ILayoutExtension)l).computeMinimumWidth(cc, changed);
                    }
                    if (minWidth == -1) {
                        if (this.isWrap(child)) {
                            minWidth = 30;
                        } else {
                            Point size = child.computeSize(-1, -1, changed);
                            minWidth = size.x;
                        }
                    }
                    this.minColumnWidths[j] = Math.max(this.minColumnWidths[j], minWidth += td.indent);
                }
                ++j;
            }
            ++i;
        }
    }

    boolean isWrap(Control control) {
        if (control instanceof Composite && ((Composite)control).getLayout() instanceof ILayoutExtension) {
            return true;
        }
        return (control.getStyle() & 0x40) != 0;
    }

    void calculateMaximumColumnWidths(Composite parent, boolean changed) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < this.numColumns) {
            this.maxColumnWidths[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.grid.size()) {
            TableData[] row = (TableData[])this.grid.elementAt(i);
            int j = 0;
            while (j < this.numColumns) {
                TableData td = row[j];
                if (td.isItemData) {
                    Composite cc;
                    Layout l;
                    Control child = children[td.childIndex];
                    int maxWidth = -1;
                    if (child instanceof Composite && (l = (cc = (Composite)child).getLayout()) instanceof ILayoutExtension) {
                        maxWidth = ((ILayoutExtension)l).computeMaximumWidth(cc, changed);
                    }
                    if (maxWidth == -1) {
                        Point size = child.computeSize(-1, -1, changed);
                        maxWidth = size.x;
                    }
                    maxWidth += td.indent;
                    if (td.colspan == 1) {
                        this.maxColumnWidths[j] = Math.max(this.maxColumnWidths[j], maxWidth);
                    } else {
                        int last = j + td.colspan - 1;
                        int rem = 0;
                        int k = j;
                        while (k < j + td.colspan - 1) {
                            rem += this.maxColumnWidths[k];
                            ++k;
                        }
                        int reduced = maxWidth - rem;
                        this.maxColumnWidths[last] = Math.max(this.maxColumnWidths[last], reduced);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeIfNeeded(Composite parent, boolean changed) {
        if (changed) {
            this.initialLayout = true;
        }
        if (this.initialLayout) {
            this.initializeLayoutData(parent);
            this.initialLayout = false;
        }
    }

    void initializeLayoutData(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getLayoutData() == null) {
                child.setLayoutData((Object)new TableData());
            }
            ++i;
        }
    }
}

