/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.FormsResources;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.parts.ExpandableComposite;
import org.eclipse.ui.forms.parts.FormUtil;
import org.eclipse.ui.forms.parts.Hyperlink;
import org.eclipse.ui.forms.parts.RichText;
import org.eclipse.ui.forms.parts.SectionPart;
import org.eclipse.ui.forms.parts.TraversableLabel;
import org.eclipse.ui.forms.parts.Twistie;

public class FormToolkit {
    public static final String KEY_DRAW_BORDER = "FormWidgetFactory.drawBorder";
    public static final String TREE_BORDER = "treeBorder";
    private FormColors colors;
    private KeyListener deleteListener;
    private BorderPainter borderPainter;
    private HyperlinkGroup hyperlinkGroup;
    VisibilityHandler visibilityHandler;
    KeyboardHandler keyboardHandler;

    public FormToolkit() {
        this(new FormColors());
    }

    public FormToolkit(FormColors colors) {
        this.colors = colors;
        this.initialize();
    }

    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style | 0x800000);
        button.setBackground(this.colors.getBackground());
        button.setForeground(this.colors.getForeground());
        if (text != null) {
            button.setText(text);
        }
        button.addFocusListener((FocusListener)this.visibilityHandler);
        return button;
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setBackground(this.colors.getBackground());
        composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        composite.setMenu(parent.getMenu());
        return composite;
    }

    public Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.colors.getColor("org.eclipse.ui.forms.SEPARATOR"));
        return composite;
    }

    public Label createHeadingLabel(Composite parent, String text) {
        return this.createHeadingLabel(parent, text, 0);
    }

    public Label createHeadingLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.colors.getBackground());
        label.setForeground(this.colors.getForeground());
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.colors.getBackground());
        label.setForeground(this.colors.getForeground());
        return label;
    }

    public TraversableLabel createSelectableLabel(Composite parent, String text) {
        return this.createSelectableLabel(parent, text, 0);
    }

    public TraversableLabel createSelectableLabel(Composite parent, String text, int style) {
        TraversableLabel label = new TraversableLabel(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.colors.getBackground());
        label.setForeground(this.colors.getForeground());
        label.addFocusListener((FocusListener)this.visibilityHandler);
        label.addKeyListener((KeyListener)this.keyboardHandler);
        return label;
    }

    public RichText createRichText(Composite parent, boolean trackFocus) {
        RichText engine = new RichText(parent, 64);
        engine.setBackground(this.colors.getBackground());
        engine.setForeground(this.colors.getForeground());
        engine.marginWidth = 1;
        engine.marginHeight = 0;
        engine.setHyperlinkSettings(this.getHyperlinkGroup());
        if (trackFocus) {
            engine.addFocusListener((FocusListener)this.visibilityHandler);
        }
        engine.addKeyListener((KeyListener)this.keyboardHandler);
        engine.setMenu(parent.getMenu());
        return engine;
    }

    public Twistie createTwistie(Composite parent) {
        Twistie twistie = new Twistie(parent, 0);
        twistie.setBackground(this.colors.getBackground());
        twistie.setActiveDecorationColor(this.getHyperlinkGroup().getActiveForeground());
        twistie.setDecorationColor(this.colors.getColor("org.eclipse.ui.forms.SEPARATOR"));
        twistie.setActiveCursor(FormsResources.getHandCursor());
        twistie.addFocusListener((FocusListener)this.visibilityHandler);
        twistie.addKeyListener((KeyListener)this.keyboardHandler);
        return twistie;
    }

    public ExpandableComposite createExpandableComposite(Composite parent) {
        ExpandableComposite ec = new ExpandableComposite(parent, 0);
        ec.setBackground(this.colors.getBackground());
        ec.setForeground(this.colors.getForeground());
        ec.textLabel.setBackground(this.colors.getBackground());
        this.hyperlinkGroup.add(ec.textLabel);
        ec.textLabel.addFocusListener((FocusListener)this.visibilityHandler);
        ec.textLabel.addKeyListener((KeyListener)this.keyboardHandler);
        ec.textLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return ec;
    }

    public Label createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 2 | style);
        label.setBackground(this.colors.getBackground());
        label.setForeground(this.colors.getBorderColor());
        return label;
    }

    public Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        table.setBackground(this.colors.getBackground());
        table.setForeground(this.colors.getForeground());
        this.hookDeleteListener((Control)table);
        return table;
    }

    public Text createText(Composite parent, String value) {
        return this.createText(parent, value, 4);
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, style);
        if (value != null) {
            text.setText(value);
        }
        text.setBackground(this.colors.getBackground());
        text.setForeground(this.colors.getForeground());
        text.addFocusListener((FocusListener)this.visibilityHandler);
        return text;
    }

    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setBackground(this.colors.getBackground());
        tree.setForeground(this.colors.getForeground());
        this.hookDeleteListener((Control)tree);
        return tree;
    }

    private void deleteKeyPressed(Widget widget) {
        if (!(widget instanceof Control)) {
            return;
        }
        Control control = (Control)widget;
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent.getData() instanceof SectionPart) {
                SectionPart section = (SectionPart)parent.getData();
                section.doGlobalAction(ActionFactory.DELETE.getId());
                break;
            }
            parent = parent.getParent();
        }
    }

    public void dispose() {
        if (!this.colors.isShared()) {
            this.colors.dispose();
            this.colors = null;
        }
    }

    public HyperlinkGroup getHyperlinkGroup() {
        return this.hyperlinkGroup;
    }

    public void hookDeleteListener(Control control) {
        if (this.deleteListener == null) {
            this.deleteListener = new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\u007f' && event.stateMask == 0) {
                        FormToolkit.this.deleteKeyPressed(event.widget);
                    }
                }
            };
        }
        control.addKeyListener(this.deleteListener);
    }

    private void initialize() {
        this.hyperlinkGroup = new HyperlinkGroup();
        this.hyperlinkGroup.setBackground(this.colors.getBackground());
        this.visibilityHandler = new VisibilityHandler();
        this.keyboardHandler = new KeyboardHandler();
    }

    public void updateHyperlinkColors() {
        this.hyperlinkGroup.initializeDefaultForegrounds();
    }

    public void paintBordersFor(Composite parent) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.borderPainter);
    }

    public FormColors getColors() {
        return this.colors;
    }

    private class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                block10: {
                    GC gc;
                    Rectangle b;
                    boolean inactiveBorder;
                    Control c;
                    block11: {
                        c = children[i];
                        inactiveBorder = false;
                        if (!c.getEnabled() && !(c instanceof CCombo) || c instanceof Hyperlink) break block10;
                        Object flag = c.getData(FormToolkit.KEY_DRAW_BORDER);
                        if (flag == null) break block11;
                        if (flag.equals(Boolean.FALSE)) break block10;
                        if (flag.equals(FormToolkit.TREE_BORDER)) {
                            inactiveBorder = true;
                        }
                    }
                    if (!inactiveBorder && (c instanceof Text || c instanceof Canvas || c instanceof CCombo)) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(c.getBackground());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        gc.setForeground(FormToolkit.this.colors.getForeground());
                        if (c instanceof CCombo) {
                            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        } else {
                            gc.drawRectangle(b.x - 1, b.y - 2, b.width + 1, b.height + 3);
                        }
                    } else if (inactiveBorder || c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(FormToolkit.this.colors.getBorderColor());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                    }
                }
                ++i;
            }
        }
    }

    private static class VisibilityHandler
    extends FocusAdapter {
        VisibilityHandler() {
        }

        public void focusGained(FocusEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormUtil.ensureVisible((Control)w);
            }
        }
    }

    private static class KeyboardHandler
    extends KeyAdapter {
        KeyboardHandler() {
        }

        public void keyPressed(KeyEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormUtil.processKey(e.keyCode, (Control)w);
            }
        }
    }
}

