/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.parts.FormUtil;

public class FormLabel
extends Canvas {
    private String text = "";
    protected int textMarginWidth = 5;
    protected int textMarginHeight = 5;
    private boolean underlined;

    public FormLabel(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FormLabel.this.paint(e);
            }
        });
        this.initAccessible();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text != null) {
            this.text = text;
        } else {
            text = "";
        }
        this.redraw();
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = FormLabel.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = FormLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = FormLabel.this.toControl(new Point(e.x, e.y));
                e.childID = FormLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FormLabel.this.getBounds();
                Point pt = FormLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
        this.redraw();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= this.textMarginWidth * 2;
        }
        Point textSize = this.computeTextSize(innerWidth, hHint);
        int textWidth = textSize.x + 2 * this.textMarginWidth;
        int textHeight = textSize.y + 2 * this.textMarginHeight;
        return new Point(textWidth, textHeight);
    }

    private Point computeTextSize(int wHint, int hHint) {
        Point extent;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && wHint != -1) {
            int height = FormUtil.computeWrapHeight(gc, this.text, wHint);
            extent = new Point(wHint, height);
        } else {
            extent = gc.textExtent(this.getText());
        }
        gc.dispose();
        return extent;
    }

    protected void paint(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.getSize();
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            FormUtil.paintWrapText(gc, size, this.text, this.textMarginWidth, this.textMarginHeight, this.underlined);
        } else {
            gc.drawText(this.getText(), this.textMarginWidth, this.textMarginHeight, true);
            if (this.underlined) {
                FontMetrics fm = gc.getFontMetrics();
                int descent = fm.getDescent();
                int lineY = size.y - this.textMarginHeight - descent + 1;
                gc.drawLine(this.textMarginWidth, lineY, size.x - this.textMarginWidth, lineY);
            }
        }
    }
}

