/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.parts.IFormEntryListener;

public class FormEntry {
    private Text text;
    private String value;
    private boolean dirty;
    private Vector listeners = new Vector();
    boolean ignoreModify = false;

    public FormEntry(Text text) {
        this.text = text;
        this.value = text.getText();
        this.addListeners();
    }

    public void addFormTextListener(IFormEntryListener listener) {
        this.listeners.addElement(listener);
    }

    private void addListeners() {
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FormEntry.this.keyReleaseOccured(e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormEntry.this.editOccured(e);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (FormEntry.this.dirty) {
                    FormEntry.this.commit();
                }
            }
        });
    }

    public void commit() {
        if (this.dirty) {
            this.value = this.text.getText();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((IFormEntryListener)iter.next()).textValueChanged(this);
            }
        }
        this.dirty = false;
    }

    protected void editOccured(ModifyEvent e) {
        if (this.ignoreModify) {
            return;
        }
        this.dirty = true;
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((IFormEntryListener)iter.next()).textDirty(this);
        }
    }

    public Text getControl() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void keyReleaseOccured(KeyEvent e) {
        if (e.character == '\r') {
            if (this.dirty) {
                this.commit();
            }
        } else if (e.character == '\u001b') {
            this.text.setText(this.value != null ? this.value : "");
            this.dirty = false;
        }
    }

    public void removeFormTextListener(IFormEntryListener listener) {
        this.listeners.removeElement(listener);
    }

    public void setDirty(boolean newDirty) {
        this.dirty = newDirty;
    }

    public void setValue(String value) {
        if (this.text != null) {
            this.text.setText(value != null ? value : "");
        }
        this.value = value;
    }

    public void setValue(String value, boolean blockNotification) {
        this.ignoreModify = blockNotification;
        this.setValue(value);
        this.ignoreModify = false;
    }
}

