/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.parts;

import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.FormsResources;
import org.eclipse.ui.forms.parts.Hyperlink;
import org.eclipse.ui.forms.parts.HyperlinkAdapter;

public class ExpandableComposite
extends Composite {
    public static final int TWISTIE = 1;
    public static final int TREE = 2;
    private boolean expandable = true;
    private boolean expanded;
    private Control client;
    protected Hyperlink textLabel;

    public ExpandableComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new ExpandableLayout());
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ExpandableComposite.this.isExpandable()) {
                    ExpandableComposite.this.repaint(e);
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Rectangle box = ExpandableComposite.this.getBoxBounds(null);
                if (box.contains(e.x, e.y)) {
                    ExpandableComposite.this.setCursor(FormsResources.getBusyCursor());
                    ExpandableComposite.this.setExpanded(!ExpandableComposite.this.isExpanded());
                    ExpandableComposite.this.setCursor(null);
                }
            }
        });
        this.textLabel = new Hyperlink(this, 64);
        this.textLabel.addHyperlinkListener(new HyperlinkAdapter(){

            public void linkActivated(Control link) {
                if (ExpandableComposite.this.isExpandable()) {
                    ExpandableComposite.this.setExpanded(!ExpandableComposite.this.isExpanded());
                }
            }
        });
    }

    public void setClient(Control client) {
        Assert.isTrue((client != null && client.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.client = client;
    }

    public Control getClient() {
        return this.client;
    }

    public void setTitle(String title) {
        this.textLabel.setText(title);
    }

    public String getTitle() {
        return this.textLabel.getText();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            if (this.client != null) {
                this.client.setVisible(expanded);
            }
            this.layout();
        }
    }

    private void repaint(PaintEvent e) {
        GC gc = e.gc;
        Rectangle box = this.getBoxBounds(gc);
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawRectangle(box);
        gc.setForeground(this.getDisplay().getSystemColor(24));
        gc.drawLine(box.x + 2, box.y + 4, box.x + 6, box.y + 4);
        if (!this.isExpanded()) {
            gc.drawLine(box.x + 4, box.y + 2, box.x + 4, box.y + 6);
        }
    }

    private Rectangle getBoxBounds(GC gc) {
        int x = 0;
        int y = 0;
        boolean noGC = false;
        if (gc == null) {
            gc = new GC((Drawable)this);
            noGC = true;
        }
        gc.setFont(this.textLabel.getFont());
        int height = gc.getFontMetrics().getHeight();
        y = height / 2 - 4 + 1;
        y = Math.max(y, 0);
        if (noGC) {
            gc.dispose();
        }
        return new Rectangle(x, y, 8, 8);
    }

    private class ExpandableLayout
    extends Layout {
        ExpandableLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            Rectangle clientArea = parent.getClientArea();
            Point size = ExpandableComposite.this.textLabel.computeSize(-1, -1, changed);
            int x = 0;
            int y = 1;
            if (ExpandableComposite.this.isExpandable()) {
                x = 16;
            }
            ExpandableComposite.this.textLabel.setBounds(x, y, size.x, size.y);
            y = ExpandableComposite.this.isExpandable() ? Math.max(size.y, 8) + 2 + 2 : size.y + 2;
            if (ExpandableComposite.this.expanded) {
                int areaWidth = clientArea.width - x;
                if (ExpandableComposite.this.client != null) {
                    size = ExpandableComposite.this.client.computeSize(areaWidth, -1, changed);
                    ExpandableComposite.this.client.setBounds(x, y, size.x, size.y);
                }
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            int width = 0;
            int height = 0;
            Point size = ExpandableComposite.this.textLabel.computeSize(-1, -1, changed);
            width = size.x;
            height = size.y + 2 + 2;
            if (ExpandableComposite.this.expanded && ExpandableComposite.this.client != null) {
                size = ExpandableComposite.this.client.computeSize(wHint, -1, changed);
                width = Math.max(width, size.x);
                height += size.y;
            }
            if (ExpandableComposite.this.isExpandable()) {
                height = Math.max(height, 8);
                width += 16;
            }
            return new Point(width, height);
        }
    }
}

