/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.parts;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.parts.HyperlinkSegment;
import org.eclipse.ui.forms.internal.parts.Locator;
import org.eclipse.ui.forms.internal.parts.ParagraphSegment;
import org.eclipse.ui.forms.internal.parts.TextSegment;

public class Paragraph {
    public static final String HTTP = "http://";
    private Vector segments;
    private boolean addVerticalSpace = true;

    public Paragraph(boolean addVerticalSpace) {
        this.addVerticalSpace = addVerticalSpace;
    }

    public int getIndent() {
        return 0;
    }

    public boolean getAddVerticalSpace() {
        return this.addVerticalSpace;
    }

    public ParagraphSegment[] getSegments() {
        if (this.segments == null) {
            return new ParagraphSegment[0];
        }
        return this.segments.toArray(new ParagraphSegment[this.segments.size()]);
    }

    public void addSegment(ParagraphSegment segment) {
        if (this.segments == null) {
            this.segments = new Vector();
        }
        this.segments.add(segment);
    }

    public void parseRegularText(String text, boolean expandURLs, HyperlinkSettings settings, String fontId) {
        if (text.length() == 0) {
            return;
        }
        if (expandURLs) {
            int loc = text.indexOf(HTTP);
            if (loc == -1) {
                this.addSegment(new TextSegment(text, fontId));
            } else {
                int textLoc = 0;
                while (loc != -1) {
                    this.addSegment(new TextSegment(text.substring(textLoc, loc), fontId));
                    boolean added = false;
                    textLoc = loc;
                    while (textLoc < text.length()) {
                        char c = text.charAt(textLoc);
                        if (Character.isSpaceChar(c)) {
                            this.addHyperlinkSegment(text.substring(loc, textLoc), settings, fontId);
                            added = true;
                            break;
                        }
                        ++textLoc;
                    }
                    if (!added) {
                        this.addHyperlinkSegment(text.substring(loc), settings, fontId);
                        break;
                    }
                    loc = text.indexOf(HTTP, textLoc);
                }
                if (textLoc < text.length()) {
                    this.addSegment(new TextSegment(text.substring(textLoc), fontId));
                }
            }
        } else {
            this.addSegment(new TextSegment(text, fontId));
        }
    }

    private void addHyperlinkSegment(String text, HyperlinkSettings settings, String fontId) {
        HyperlinkSegment hs = new HyperlinkSegment(text, settings, fontId);
        hs.setWordWrapAllowed(false);
        hs.setHref(text);
        this.addSegment(hs);
    }

    public void paint(GC gc, int width, Locator loc, int lineHeight, Hashtable objectTable, HyperlinkSegment selectedLink) {
        ParagraphSegment[] segments = this.getSegments();
        if (segments.length > 0) {
            if (segments[0] instanceof TextSegment && ((TextSegment)segments[0]).isSelectable()) {
                ++loc.x;
            }
            int j = 0;
            while (j < segments.length) {
                ParagraphSegment segment = segments[j];
                boolean doSelect = false;
                if (selectedLink != null && segment.equals(selectedLink)) {
                    doSelect = true;
                }
                segment.paint(gc, width, loc, objectTable, doSelect);
                ++j;
            }
            loc.y += loc.rowHeight;
        } else {
            loc.y += lineHeight;
        }
    }

    public String getAccessibleText() {
        ParagraphSegment[] segments = this.getSegments();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        int i = 0;
        while (i < segments.length) {
            ParagraphSegment segment = segments[i];
            if (segment instanceof TextSegment) {
                String text = ((TextSegment)segment).getText();
                writer.print(text);
            }
            ++i;
        }
        writer.println();
        swriter.flush();
        return swriter.toString();
    }

    public TextSegment findSegmentAt(int x, int y) {
        if (this.segments != null) {
            int i = 0;
            while (i < this.segments.size()) {
                TextSegment textSegment;
                ParagraphSegment segment = (ParagraphSegment)this.segments.get(i);
                if (segment instanceof TextSegment && (textSegment = (TextSegment)segment).contains(x, y)) {
                    return textSegment;
                }
                ++i;
            }
        }
        return null;
    }
}

