/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.parts.Hyperlink;
import org.eclipse.ui.forms.parts.HyperlinkEvent;
import org.eclipse.ui.forms.parts.HyperlinkListener;

public class HyperlinkGroup
extends HyperlinkSettings {
    private ArrayList links;
    private Hyperlink lastActivated;
    private Hyperlink lastEntered;
    private GroupListener listener = new GroupListener();

    public HyperlinkGroup() {
        this.links = new ArrayList();
    }

    public Hyperlink getLastActivated() {
        return this.lastActivated;
    }

    public void add(Hyperlink link) {
        if (this.getBackground() != null) {
            link.setBackground(this.getBackground());
        }
        if (this.getForeground() != null) {
            link.setForeground(this.getForeground());
        }
        if (this.getHyperlinkUnderlineMode() == 3) {
            link.setUnderlined(true);
        }
        this.hook(link);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        int i = 0;
        while (i < this.links.size()) {
            Hyperlink label = (Hyperlink)((Object)this.links.get(i));
            label.setBackground(color);
            ++i;
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        int i = 0;
        while (i < this.links.size()) {
            Hyperlink label = (Hyperlink)((Object)this.links.get(i));
            label.setForeground(color);
            ++i;
        }
    }

    public void setHyperlinkUnderlineMode(int newHyperlinkUnderlineMode) {
        super.setHyperlinkUnderlineMode(newHyperlinkUnderlineMode);
        int i = 0;
        while (i < this.links.size()) {
            Hyperlink label = (Hyperlink)((Object)this.links.get(i));
            label.setUnderlined(newHyperlinkUnderlineMode == 3);
            ++i;
        }
    }

    private void hook(Hyperlink link) {
        link.addListener(3, this.listener);
        link.addHyperlinkListener(this.listener);
        link.addListener(12, this.listener);
    }

    private void unhook(Hyperlink link) {
        link.removeListener(3, this.listener);
        link.removeHyperlinkListener(this.listener);
        if (this.lastActivated == link) {
            this.lastActivated = null;
        }
        if (this.lastEntered == link) {
            this.lastEntered = null;
        }
        this.links.remove((Object)link);
    }

    private void onMouseDown(Event e) {
        if (e.button == 1) {
            return;
        }
        this.lastActivated = (Hyperlink)e.widget;
    }

    private class GroupListener
    implements Listener,
    HyperlinkListener {
        GroupListener() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 3: {
                    HyperlinkGroup.this.onMouseDown(e);
                    break;
                }
                case 12: {
                    HyperlinkGroup.this.unhook((Hyperlink)e.widget);
                }
            }
        }

        public void linkActivated(HyperlinkEvent e) {
        }

        public void linkEntered(HyperlinkEvent e) {
            if (HyperlinkGroup.this.lastEntered != null) {
                this.linkExited(HyperlinkGroup.this.lastEntered);
            }
            Hyperlink link = (Hyperlink)e.widget;
            link.setCursor(HyperlinkGroup.this.getHyperlinkCursor());
            if (HyperlinkGroup.this.getActiveBackground() != null) {
                link.setBackground(HyperlinkGroup.this.getActiveBackground());
            }
            if (HyperlinkGroup.this.getActiveForeground() != null) {
                link.setForeground(HyperlinkGroup.this.getActiveForeground());
            }
            if (HyperlinkGroup.this.getHyperlinkUnderlineMode() == 2) {
                link.setUnderlined(true);
            }
            HyperlinkGroup.this.lastEntered = link;
        }

        public void linkExited(HyperlinkEvent e) {
            this.linkExited((Hyperlink)e.widget);
        }

        private void linkExited(Hyperlink link) {
            link.setCursor(null);
            if (HyperlinkGroup.this.getHyperlinkUnderlineMode() == 2) {
                link.setUnderlined(false);
            }
            if (HyperlinkGroup.this.getBackground() != null) {
                link.setBackground(HyperlinkGroup.this.getBackground());
            }
            if (HyperlinkGroup.this.getForeground() != null) {
                link.setForeground(HyperlinkGroup.this.getForeground());
            }
            if (HyperlinkGroup.this.lastEntered == link) {
                HyperlinkGroup.this.lastEntered = null;
            }
        }
    }
}

