/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.eclipse.ui.views.tasklist.TaskList;

public class SelectMarkerRulerAction
extends ResourceAction
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List fMarkers;
    private ResourceBundle fBundle;
    private String fPrefix;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, IVerticalRuler ruler, ITextEditor editor) {
        this(bundle, prefix, editor, (IVerticalRulerInfo)ruler);
    }

    public void update() {
        this.fMarkers = this.getMarkers();
        this.setEnabled(!this.fMarkers.isEmpty());
    }

    public void run() {
        IMarker marker = this.chooseMarker(this.fMarkers);
        if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.taskmarker") || MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
            IWorkbenchPage page = this.fTextEditor.getSite().getPage();
            IViewPart view = page.findView("org.eclipse.ui.views.TaskList");
            if (view instanceof TaskList) {
                StructuredSelection ss = new StructuredSelection((Object)marker);
                ((TaskList)view).setSelection((ISelection)ss, true);
            } else {
                int offset = MarkerUtilities.getCharStart(marker);
                int endOffset = MarkerUtilities.getCharEnd(marker);
                if (offset > -1 && endOffset > -1) {
                    this.fTextEditor.selectAndReveal(offset, endOffset - offset);
                }
            }
        }
    }

    protected IMarker chooseMarker(List markers) {
        Object adapter;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension access = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jface.text.source.IAnnotationAccess;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = this.fTextEditor.getAdapter((Class)clazz)) instanceof IAnnotationAccessExtension) {
            access = (IAnnotationAccessExtension)adapter;
        }
        IMarker marker = null;
        int maxLayer = 0;
        Iterator iter = markers.iterator();
        while (iter.hasNext()) {
            IMarker m = (IMarker)iter.next();
            MarkerAnnotation a = model.getMarkerAnnotation(m);
            if (a == null) continue;
            if (access == null) {
                marker = m;
                break;
            }
            int l = access.getLayer((Annotation)a);
            if (l == maxLayer) {
                if (marker != null) continue;
                marker = m;
                continue;
            }
            if (l <= maxLayer) continue;
            maxLayer = l;
            marker = m;
        }
        return marker;
    }

    protected IResource getResource() {
        IResource resource;
        IEditorInput input = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IFile;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void handleCoreException(CoreException exception, String message) {
        ILog log = Platform.getPlugin((String)"org.eclipse.ui").getLog();
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
        Shell shell = this.fTextEditor.getSite().getShell();
        String title = ResourceAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.title"), (String)(String.valueOf(this.fPrefix) + "error.dialog.title"));
        String msg = ResourceAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected List getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource != null && model != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(null, true, 0);
                if (allMarkers != null) {
                    int i = 0;
                    while (i < allMarkers.length) {
                        if (this.includesRulerLine(model.getMarkerPosition(allMarkers[i]), document)) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.getString("SelectMarkerRulerAction.getMarker"));
            }
        }
        return markers;
    }
}

