/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MarkerAnnotation
extends Annotation {
    public static final int PROBLEM_LAYER = 5;
    private static Map fgImageRegistry;
    private IMarker fMarker;
    private Image fImage;
    private String fImageName;
    static /* synthetic */ Class class$0;

    protected static Image getImage(Display display, ImageDescriptor descriptor) {
        Map map = MarkerAnnotation.getImageRegistry(display);
        Image image = (Image)map.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            map.put(descriptor, image);
        }
        return image;
    }

    protected static Map getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new HashMap();
            display.disposeExec(new Runnable(){

                public void run() {
                    if (fgImageRegistry != null) {
                        Map map = fgImageRegistry;
                        fgImageRegistry = null;
                        Iterator e = map.values().iterator();
                        while (e.hasNext()) {
                            Image image = (Image)e.next();
                            if (image.isDisposed()) continue;
                            image.dispose();
                        }
                    }
                }
            });
        }
        return fgImageRegistry;
    }

    public MarkerAnnotation(IMarker marker) {
        this(null, marker);
    }

    public MarkerAnnotation(String annotationType, IMarker marker) {
        super(annotationType, true, null);
        Assert.isNotNull((Object)marker);
        this.fMarker = marker;
        this.initialize();
    }

    protected void setImage(Image image) {
        this.fImage = image;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == ((Object)((Object)this)).getClass()) {
            return this.fMarker.equals((Object)((MarkerAnnotation)((Object)o)).fMarker);
        }
        return false;
    }

    public int hashCode() {
        return this.fMarker.hashCode();
    }

    public IMarker getMarker() {
        return this.fMarker;
    }

    protected void initialize() {
        String name = this.getUnknownImageName(this.fMarker);
        int layer = 1;
        if (MarkerUtilities.isMarkerType(this.fMarker, "org.eclipse.core.resources.taskmarker")) {
            name = "IMG_OBJS_TASK_TSK";
            layer = 1;
        } else if (MarkerUtilities.isMarkerType(this.fMarker, "org.eclipse.core.resources.bookmark")) {
            name = "IMG_OBJS_BKMRK_TSK";
            layer = 2;
        } else if (MarkerUtilities.isMarkerType(this.fMarker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtilities.getSeverity(this.fMarker)) {
                case 0: {
                    name = "IMG_OBJS_INFO_TSK";
                    layer = 3;
                    break;
                }
                case 1: {
                    name = "IMG_OBJS_WARN_TSK";
                    layer = 4;
                    break;
                }
                case 2: {
                    name = "IMG_OBJS_ERROR_TSK";
                    layer = 5;
                }
            }
        }
        this.fImage = null;
        this.fImageName = name;
        this.setLayer(layer);
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            Annotation.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    public void update() {
        this.initialize();
    }

    protected String getUnknownImageName(IMarker marker) {
        return null;
    }

    protected Image getImage(String name) {
        if (name != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(name);
        }
        return null;
    }

    protected Image getImage(Display display) {
        if (this.fImage == null) {
            if (this.fMarker.exists()) {
                ImageDescriptor descriptor;
                IWorkbenchAdapter adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)this.fMarker.getAdapter((Class)clazz)) != null && (descriptor = adapter.getImageDescriptor((Object)this.fMarker)) != null) {
                    this.fImage = MarkerAnnotation.getImage(display, descriptor);
                }
            }
            if (this.fImage == null) {
                this.fImage = this.getImage(this.fImageName);
            }
        }
        return this.fImage;
    }

    public String getText() {
        return MarkerUtilities.getMessage(this.fMarker);
    }
}

