/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;

public class DefaultAnnotation
extends Annotation
implements IAnnotationPresentation {
    public static final int TASK_LAYER = 1;
    public static final int BOOKMARK_LAYER = 2;
    public static final int INFO_LAYER = 3;
    public static final int WARNING_LAYER = 4;
    public static final int ERROR_LAYER = 5;
    private static Map fgImageRegistry;
    private static Map fgType2Descriptor;
    private static final Object NO_DESCRIPTOR;
    protected Image fImage;
    protected String fImageName;
    private int fSeverity;
    private String fMarkerType;
    private boolean fIsInitialized = false;
    static /* synthetic */ Class class$0;

    static {
        fgType2Descriptor = new HashMap();
        NO_DESCRIPTOR = new Object();
    }

    protected static Image getImage(Display display, ImageDescriptor descriptor) {
        Map map = DefaultAnnotation.getImageRegistry(display);
        Image image = (Image)map.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            map.put(descriptor, image);
        }
        return image;
    }

    protected static Map getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new HashMap();
            display.disposeExec(new Runnable(){

                public void run() {
                    if (fgImageRegistry != null) {
                        Map map = fgImageRegistry;
                        fgImageRegistry = null;
                        Iterator e = map.values().iterator();
                        while (e.hasNext()) {
                            Image image = (Image)e.next();
                            if (image.isDisposed()) continue;
                            image.dispose();
                        }
                    }
                }
            });
        }
        return fgImageRegistry;
    }

    private static boolean isAnnotationType(String annotationType, String type) {
        return annotationType != null && annotationType.equals(type);
    }

    public DefaultAnnotation(String markerType, int severity, boolean isTemporary, String message) {
        super(!isTemporary);
        Assert.isTrue((severity == 0 || severity == 1 || severity == 2 ? 1 : 0) != 0);
        this.fSeverity = severity;
        this.fMarkerType = markerType;
        this.setText(message);
        this.setType(this.computeAnnotationType(markerType, severity));
    }

    private String computeAnnotationType(String markerType, int severity) {
        AnnotationTypeLookup lookup = EditorsPlugin.getDefault().getAnnotationTypeLookup();
        return lookup.getAnnotationType(markerType, severity);
    }

    protected void initialize() {
        String name = this.getUnknownImageName(this.fMarkerType);
        int layer = 1;
        if (DefaultAnnotation.isAnnotationType(this.fMarkerType, "org.eclipse.core.resources.taskmarker")) {
            name = "IMG_OBJS_TASK_TSK";
            layer = 1;
        } else if (DefaultAnnotation.isAnnotationType(this.fMarkerType, "org.eclipse.core.resources.bookmark")) {
            name = "IMG_OBJS_BKMRK_TSK";
            layer = 2;
        } else if (DefaultAnnotation.isAnnotationType(this.fMarkerType, "org.eclipse.core.resources.problemmarker")) {
            switch (this.fSeverity) {
                case 0: {
                    name = "IMG_OBJS_INFO_TSK";
                    layer = 3;
                    break;
                }
                case 1: {
                    name = "IMG_OBJS_WARN_TSK";
                    layer = 4;
                    break;
                }
                case 2: {
                    name = "IMG_OBJS_ERROR_TSK";
                    layer = 5;
                }
            }
        }
        this.fImage = null;
        this.fImageName = name;
        this.setLayer(layer);
    }

    protected String getUnknownImageName(String annotationType) {
        return null;
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            Annotation.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    protected void setImage(Image image) {
        this.fImage = image;
    }

    protected Image getImage(String name) {
        if (name != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(name);
        }
        return null;
    }

    protected Image getImage(final Display display) {
        if (!this.fIsInitialized) {
            this.fIsInitialized = true;
            this.initialize();
        }
        if (this.fImage != null) {
            return this.fImage;
        }
        final String key = String.valueOf(this.fMarkerType) + this.fSeverity;
        Object descriptor = fgType2Descriptor.get(key);
        if (descriptor != null) {
            this.fImage = descriptor == NO_DESCRIPTOR ? this.getImage(this.fImageName) : DefaultAnnotation.getImage(display, (ImageDescriptor)descriptor);
            return this.fImage;
        }
        WorkspaceModifyOperation r = new WorkspaceModifyOperation(null){

            public void execute(IProgressMonitor monitor) throws CoreException {
                IMarker tempMarker = ResourcesPlugin.getWorkspace().getRoot().createMarker(DefaultAnnotation.this.fMarkerType);
                tempMarker.setAttribute("severity", DefaultAnnotation.this.fSeverity);
                if (tempMarker.exists()) {
                    IWorkbenchAdapter adapter;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (IWorkbenchAdapter)tempMarker.getAdapter((Class)clazz)) != null) {
                        ImageDescriptor imageDescriptor = adapter.getImageDescriptor((Object)tempMarker);
                        if (imageDescriptor != null) {
                            DefaultAnnotation.this.fImage = DefaultAnnotation.getImage(display, imageDescriptor);
                            fgType2Descriptor.put(key, imageDescriptor);
                        } else {
                            fgType2Descriptor.put(key, NO_DESCRIPTOR);
                        }
                    }
                    tempMarker.delete();
                }
            }
        };
        try {
            r.run(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            fgType2Descriptor.put(key, NO_DESCRIPTOR);
        }
        catch (InterruptedException interruptedException) {
            fgType2Descriptor.put(key, NO_DESCRIPTOR);
        }
        if (this.fImage == null) {
            this.fImage = this.getImage(this.fImageName);
        }
        return this.fImage;
    }
}

