/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AnnotationTypeLookup {
    private Map fMapping;

    public String getAnnotationType(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType(marker);
        if (markerType != null) {
            int severity = MarkerUtilities.getSeverity(marker);
            return this.getAnnotationType(markerType, severity);
        }
        return null;
    }

    public String getAnnotationType(String markerType, int markerSeverity) {
        String annotationType = this.lookupAnnotationType(markerType, markerSeverity);
        if (annotationType != null) {
            return annotationType;
        }
        String[] superTypes = MarkerUtilities.getSuperTypes(markerType);
        int i = 0;
        while (i < superTypes.length) {
            annotationType = this.lookupAnnotationType(superTypes[i], markerSeverity);
            if (annotationType != null) {
                return annotationType;
            }
            ++i;
        }
        return null;
    }

    private String lookupAnnotationType(String markerType, int severity) {
        Object value;
        if (this.fMapping == null) {
            this.initializeMapping();
        }
        if ((value = this.fMapping.get(markerType)) instanceof String) {
            return (String)value;
        }
        if (value instanceof Map) {
            Map severityMap = (Map)value;
            return (String)severityMap.get(new Integer(severity));
        }
        return null;
    }

    private void initializeMapping() {
        this.fMapping = new HashMap();
        List mappings = this.getAnnotationTypeMappings();
        int i = 0;
        int l = mappings.size();
        while (i < l) {
            AnnotationTypeMapping atm = (AnnotationTypeMapping)mappings.get(i);
            if (atm.isMarkerSeverityDefined()) {
                Object severityMap = this.fMapping.get(atm.fMarkerType);
                if (!(severityMap instanceof Map)) {
                    severityMap = new HashMap();
                    this.fMapping.put(atm.fMarkerType, severityMap);
                }
                Map map = (Map)severityMap;
                map.put(new Integer(atm.fMarkerSeverity), atm.fAnnotationType);
            } else {
                this.fMapping.put(atm.fMarkerType, atm.fAnnotationType);
            }
            ++i;
        }
    }

    private List getAnnotationTypeMappings() {
        ArrayList annotationTypeMappings = new ArrayList();
        this.readExtensionPoint(annotationTypeMappings, "markerAnnotationSpecification", "annotationType");
        this.readExtensionPoint(annotationTypeMappings, "annotationTypes", "name");
        return annotationTypeMappings;
    }

    private void readExtensionPoint(List annotationTypeMappings, String extensionPointName, String typeAttributeName) {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(EditorsPlugin.getPluginId(), extensionPointName);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                AnnotationTypeMapping mapping = this.createMapping(elements[i], typeAttributeName);
                if (mapping != null) {
                    annotationTypeMappings.add(mapping);
                }
                ++i;
            }
        }
    }

    private AnnotationTypeMapping createMapping(IConfigurationElement element, String typeAttributeName) {
        AnnotationTypeMapping mapping = new AnnotationTypeMapping();
        String s = element.getAttribute(typeAttributeName);
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        mapping.fAnnotationType = s;
        s = element.getAttribute("markerType");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        mapping.fMarkerType = s;
        s = element.getAttribute("markerSeverity");
        if (s != null && s.trim().length() > 0) {
            mapping.fMarkerSeverity = StringConverter.asInt((String)s, (int)-1);
        }
        return mapping;
    }

    private static class AnnotationTypeMapping {
        static final int UNDEFINED = -1;
        String fAnnotationType;
        String fMarkerType;
        int fMarkerSeverity = -1;

        AnnotationTypeMapping() {
        }

        boolean isMarkerSeverityDefined() {
            return this.fMarkerSeverity != -1;
        }
    }
}

