/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

class StatusInfo
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public StatusInfo() {
        this(0, null);
    }

    public StatusInfo(int severity, String message) {
        this.fStatusMessage = message;
        this.fSeverity = severity;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public void setError(String errorMessage) {
        Assert.isNotNull((Object)errorMessage);
        this.fStatusMessage = errorMessage;
        this.fSeverity = 4;
    }

    public void setWarning(String warningMessage) {
        Assert.isNotNull((Object)warningMessage);
        this.fStatusMessage = warningMessage;
        this.fSeverity = 2;
    }

    public void setInfo(String infoMessage) {
        Assert.isNotNull((Object)infoMessage);
        this.fStatusMessage = infoMessage;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public boolean matches(int severityMask) {
        return (this.fSeverity & severityMask) != 0;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getPlugin() {
        return EditorsPlugin.getPluginId();
    }

    public Throwable getException() {
        return null;
    }

    public int getCode() {
        return this.fSeverity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }
}

