/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ISynchronizationContext;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.internal.filebuffers.ContainerGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ISchedulingRuleProvider;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.editors.text.UISynchronizationContext;
import org.eclipse.ui.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IElementStateListenerExtension;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class TextFileDocumentProvider
implements IDocumentProvider,
IDocumentProviderExtension,
IDocumentProviderExtension2,
IDocumentProviderExtension3,
IStorageDocumentProvider {
    private IDocumentProvider fParentProvider;
    private final Map fFileInfoMap = new HashMap();
    private final Map fFileBufferMap = new HashMap();
    private List fElementStateListeners = new ArrayList();
    private final IFileBufferListener fFileBufferListener = new FileBufferListener();
    private IProgressMonitor fProgressMonitor;
    private WorkspaceOperationRunner fOperationRunner;
    static /* synthetic */ Class class$0;

    public TextFileDocumentProvider() {
        this(null);
    }

    public TextFileDocumentProvider(IDocumentProvider parentProvider) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.addFileBufferListener(this.fFileBufferListener);
        manager.setSynchronizationContext((ISynchronizationContext)new UISynchronizationContext());
        if (parentProvider != null) {
            this.setParentDocumentProvider(parentProvider);
        }
    }

    public final void setParentDocumentProvider(IDocumentProvider parentProvider) {
        Assert.isTrue((boolean)(parentProvider instanceof IDocumentProviderExtension));
        Assert.isTrue((boolean)(parentProvider instanceof IDocumentProviderExtension2));
        Assert.isTrue((boolean)(parentProvider instanceof IDocumentProviderExtension3));
        Assert.isTrue((boolean)(parentProvider instanceof IStorageDocumentProvider));
        this.fParentProvider = parentProvider;
        if (this.fParentProvider == null) {
            this.fParentProvider = new NullProvider();
        }
    }

    protected final IDocumentProvider getParentProvider() {
        if (this.fParentProvider == null) {
            this.fParentProvider = new StorageDocumentProvider();
        }
        return this.fParentProvider;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }

    protected void executeOperation(DocumentProviderOperation operation, IProgressMonitor monitor) throws CoreException {
        try {
            IRunnableContext runner = this.getOperationRunner(monitor);
            if (runner != null) {
                runner.run(false, false, (IRunnableWithProgress)operation);
            } else {
                operation.run(monitor);
            }
        }
        catch (InvocationTargetException x) {
            Throwable e = x.getTargetException();
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            String message = e.getMessage() != null ? e.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, EditorsPlugin.getPluginId(), 4, message, e));
        }
        catch (InterruptedException x) {
            String message = x.getMessage() != null ? x.getMessage() : "";
            throw new CoreException((IStatus)new Status(8, EditorsPlugin.getPluginId(), 0, message, (Throwable)x));
        }
    }

    public void connect(Object element) throws CoreException {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info == null) {
            info = this.createFileInfo(element);
            if (info == null) {
                this.getParentProvider().connect(element);
                return;
            }
            info.fElement = element;
            this.fFileInfoMap.put(element, info);
            this.storeFileBufferMapping(element, info);
        }
        ++info.fCount;
    }

    private void storeFileBufferMapping(Object element, FileInfo info) {
        Object value = this.fFileBufferMap.get(info.fTextFileBuffer);
        if (value instanceof List) {
            List list = (List)value;
            list.add(element);
            return;
        }
        if (value == null) {
            value = element;
        } else {
            ArrayList<Object> list = new ArrayList<Object>(2);
            list.add(value);
            list.add(element);
            value = list;
        }
        this.fFileBufferMap.put(info.fTextFileBuffer, value);
    }

    protected FileInfo createEmptyFileInfo() {
        return new FileInfo();
    }

    protected FileInfo createFileInfo(Object element) throws CoreException {
        IPath location = null;
        if (element instanceof IAdaptable) {
            ILocationProvider provider;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.editors.text.ILocationProvider;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (ILocationProvider)adaptable.getAdapter((Class)clazz)) != null) {
                location = provider.getPath(element);
            }
        }
        if (location != null) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            manager.connect(location, this.getProgressMonitor());
            manager.requestSynchronizationContext(location);
            ITextFileBuffer fileBuffer = manager.getTextFileBuffer(location);
            FileInfo info = this.createEmptyFileInfo();
            info.fTextFileBuffer = fileBuffer;
            info.fCachedReadOnlyState = this.isSystemFileReadOnly(info);
            IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
            if (file != null && file.exists()) {
                info.fModel = this.createAnnotationModel(file);
            }
            return info;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ResourceMarkerAnnotationModel((IResource)file);
    }

    public void disconnect(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info == null) {
            this.getParentProvider().disconnect(element);
            return;
        }
        if (info.fCount == 1) {
            this.fFileInfoMap.remove(element);
            this.removeFileBufferMapping(element, info);
            this.disposeFileInfo(element, info);
        } else {
            --info.fCount;
        }
    }

    private void removeFileBufferMapping(Object element, FileInfo info) {
        Object value = this.fFileBufferMap.get(info.fTextFileBuffer);
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            list.remove(element);
            if (list.size() == 1) {
                this.fFileBufferMap.put(info.fTextFileBuffer, list.get(0));
            }
        } else if (value == element) {
            this.fFileBufferMap.remove(info.fTextFileBuffer);
        }
    }

    protected void disposeFileInfo(Object element, FileInfo info) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            IPath location = info.fTextFileBuffer.getLocation();
            manager.releaseSynchronizationContext(location);
            manager.disconnect(location, this.getProgressMonitor());
        }
        catch (CoreException x) {
            this.handleCoreException(x, "FileDocumentProvider.disposeElementInfo");
        }
    }

    protected Iterator getElements(IFileBuffer file) {
        Object value = this.fFileBufferMap.get(file);
        if (value instanceof List) {
            return new ArrayList((List)value).iterator();
        }
        return new SingleElementIterator(value);
    }

    public IDocument getDocument(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.getDocument();
        }
        return this.getParentProvider().getDocument(element);
    }

    public void resetDocument(Object element) throws CoreException {
        final FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            DocumentProviderOperation operation = new DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    info.fTextFileBuffer.revert(monitor);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        return ((IFileEditorInput)info.fElement).getFile();
                    }
                    return null;
                }
            };
            this.executeOperation(operation, this.getProgressMonitor());
        } else {
            this.getParentProvider().resetDocument(element);
        }
    }

    public final void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element == null) {
            return;
        }
        DocumentProviderOperation operation = this.createSaveOperation(element, document, overwrite);
        if (operation != null) {
            this.executeOperation(operation, monitor);
        } else {
            this.getParentProvider().saveDocument(monitor, element, document, overwrite);
        }
    }

    protected DocumentProviderOperation createSaveOperation(Object element, final IDocument document, final boolean overwrite) throws CoreException {
        final FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            if (info.fTextFileBuffer.getDocument() != document) {
                Status status = new Status(2, EditorsPlugin.getPluginId(), 4, "not the same document", null);
                throw new CoreException((IStatus)status);
            }
            return new DocumentProviderOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    TextFileDocumentProvider.this.commitFileBuffer(monitor, info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        return ((IFileEditorInput)info.fElement).getFile().getParent();
                    }
                    return null;
                }
            };
        }
        if (element instanceof IFileEditorInput) {
            final IFile file = ((IFileEditorInput)element).getFile();
            return new DocumentProviderOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    TextFileDocumentProvider.this.createFileFromDocument(monitor, file, document);
                }

                public ISchedulingRule getSchedulingRule() {
                    IContainer existingParent = file.getParent();
                    while (!existingParent.exists()) {
                        existingParent = existingParent.getParent();
                    }
                    return existingParent;
                }
            };
        }
        return null;
    }

    protected void commitFileBuffer(IProgressMonitor monitor, FileInfo info, boolean overwrite) throws CoreException {
        Assert.isNotNull((Object)info);
        info.fTextFileBuffer.commit(monitor, overwrite);
        if (info.fModel instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
            model.updateMarkers(info.fTextFileBuffer.getDocument());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createFileFromDocument(IProgressMonitor monitor, IFile file, IDocument document) throws CoreException {
        try {
            try {
                monitor.beginTask("Saving", 2000);
                ByteArrayInputStream stream = new ByteArrayInputStream(document.get().getBytes(this.getDefaultEncoding()));
                ContainerGenerator generator = new ContainerGenerator(file.getWorkspace(), file.getParent().getFullPath());
                generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            catch (UnsupportedEncodingException x) {
                String message = x.getMessage() != null ? x.getMessage() : "";
                Status s = new Status(4, EditorsPlugin.getPluginId(), 0, message, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        monitor.done();
    }

    public long getModificationStamp(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.getModifcationStamp();
        }
        return this.getParentProvider().getModificationStamp(element);
    }

    public long getSynchronizationStamp(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return 0L;
        }
        return this.getParentProvider().getSynchronizationStamp(element);
    }

    public boolean isDeleted(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            File file = this.getSystemFile(info);
            return file == null ? true : !file.exists();
        }
        return this.getParentProvider().isDeleted(element);
    }

    public boolean mustSaveDocument(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fCount == 1 && info.fTextFileBuffer.isDirty();
        }
        return this.getParentProvider().mustSaveDocument(element);
    }

    public boolean canSaveDocument(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.isDirty();
        }
        return this.getParentProvider().canSaveDocument(element);
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fModel;
        }
        return this.getParentProvider().getAnnotationModel(element);
    }

    public void aboutToChange(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info == null) {
            this.getParentProvider().aboutToChange(element);
        }
    }

    public void changed(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info == null) {
            this.getParentProvider().changed(element);
        }
    }

    public void addElementStateListener(IElementStateListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fElementStateListeners.contains(listener)) {
            this.fElementStateListeners.add(listener);
        }
        this.getParentProvider().addElementStateListener(listener);
    }

    public void removeElementStateListener(IElementStateListener listener) {
        Assert.isNotNull((Object)listener);
        this.fElementStateListeners.remove(listener);
        this.getParentProvider().removeElementStateListener(listener);
    }

    public boolean isReadOnly(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fCachedReadOnlyState;
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.isStateValidated() ? !this.isSystemFileReadOnly(info) : true;
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).isModifiable(element);
    }

    public void validateState(Object element, final Object computationContext) throws CoreException {
        final FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            DocumentProviderOperation operation = new DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    info.fTextFileBuffer.validateState(monitor, computationContext);
                }

                public ISchedulingRule getSchedulingRule() {
                    return ResourcesPlugin.getWorkspace().getRoot();
                }
            };
            this.executeOperation(operation, this.getProgressMonitor());
        } else {
            ((IDocumentProviderExtension)this.getParentProvider()).validateState(element, computationContext);
        }
    }

    public boolean isStateValidated(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.isStateValidated();
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).isStateValidated(element);
    }

    public void updateStateCache(Object element) throws CoreException {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            boolean isReadOnly = this.isSystemFileReadOnly(info);
            if (!info.fCachedReadOnlyState && isReadOnly && info.fTextFileBuffer.isDirty()) {
                info.fTextFileBuffer.resetStateValidation();
            }
            info.fCachedReadOnlyState = isReadOnly;
        } else {
            ((IDocumentProviderExtension)this.getParentProvider()).updateStateCache(element);
        }
    }

    public void setCanSaveDocument(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info == null) {
            ((IDocumentProviderExtension)this.getParentProvider()).setCanSaveDocument(element);
        }
    }

    public IStatus getStatus(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.getStatus();
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).getStatus(element);
    }

    public void synchronize(Object element) throws CoreException {
        final FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            DocumentProviderOperation operation = new DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    info.fTextFileBuffer.revert(monitor);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        return ((IFileEditorInput)info.fElement).getFile().getParent();
                    }
                    return null;
                }
            };
            this.executeOperation(operation, this.getProgressMonitor());
        } else {
            ((IDocumentProviderExtension)this.getParentProvider()).synchronize(element);
        }
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
        ((IDocumentProviderExtension2)this.getParentProvider()).setProgressMonitor(progressMonitor);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public boolean isSynchronized(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.isSynchronized();
        }
        return ((IDocumentProviderExtension3)this.getParentProvider()).isSynchronized(element);
    }

    public String getDefaultEncoding() {
        return FileBuffers.getTextFileBufferManager().getDefaultEncoding();
    }

    public String getEncoding(Object element) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            return info.fTextFileBuffer.getEncoding();
        }
        return ((IStorageDocumentProvider)this.getParentProvider()).getEncoding(element);
    }

    public void setEncoding(Object element, String encoding) {
        FileInfo info = (FileInfo)this.fFileInfoMap.get(element);
        if (info != null) {
            info.fTextFileBuffer.setEncoding(encoding);
        } else {
            ((IStorageDocumentProvider)this.getParentProvider()).setEncoding(element, encoding);
        }
    }

    protected void handleCoreException(CoreException exception, String message) {
        ILog log = Platform.getPlugin((String)"org.eclipse.ui").getLog();
        Status status = message != null ? new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception) : exception.getStatus();
        log.log((IStatus)status);
    }

    protected File getSystemFile(FileInfo info) {
        IPath path = info.fTextFileBuffer.getLocation();
        return FileBuffers.getSystemFileAtLocation((IPath)path);
    }

    protected boolean isSystemFileReadOnly(FileInfo info) {
        File file = this.getSystemFile(info);
        return file == null ? true : !file.canWrite();
    }

    protected FileInfo getFileInfo(Object element) {
        return (FileInfo)this.fFileInfoMap.get(element);
    }

    protected Iterator getConnectedElementsIterator() {
        return new HashSet(this.fFileInfoMap.keySet()).iterator();
    }

    protected Iterator getFileInfosIterator() {
        return new ArrayList(this.fFileInfoMap.values()).iterator();
    }

    protected void fireElementStateChanging(Object element) {
        ArrayList list = new ArrayList(this.fElementStateListeners);
        Iterator e = list.iterator();
        while (e.hasNext()) {
            Object l = e.next();
            if (!(l instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension x = (IElementStateListenerExtension)l;
            x.elementStateChanging(element);
        }
    }

    protected void fireElementStateChangeFailed(Object element) {
        ArrayList list = new ArrayList(this.fElementStateListeners);
        Iterator e = list.iterator();
        while (e.hasNext()) {
            Object l = e.next();
            if (!(l instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension x = (IElementStateListenerExtension)l;
            x.elementStateChangeFailed(element);
        }
    }

    protected static abstract class DocumentProviderOperation
    implements IRunnableWithProgress,
    ISchedulingRuleProvider {
        protected DocumentProviderOperation() {
        }

        protected abstract void execute(IProgressMonitor var1) throws CoreException;

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.execute(monitor);
            }
            catch (CoreException x) {
                throw new InvocationTargetException(x);
            }
        }

        public ISchedulingRule getSchedulingRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }

    protected static class NullProvider
    implements IDocumentProvider,
    IDocumentProviderExtension,
    IDocumentProviderExtension2,
    IDocumentProviderExtension3,
    IStorageDocumentProvider {
        private static final IStatus STATUS_ERROR = new Status(4, EditorsPlugin.getPluginId(), 1, TextEditorMessages.getString("NullProvider.error"), null);

        protected NullProvider() {
        }

        public void connect(Object element) throws CoreException {
        }

        public void disconnect(Object element) {
        }

        public IDocument getDocument(Object element) {
            return null;
        }

        public void resetDocument(Object element) throws CoreException {
        }

        public void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        }

        public long getModificationStamp(Object element) {
            return 0L;
        }

        public long getSynchronizationStamp(Object element) {
            return 0L;
        }

        public boolean isDeleted(Object element) {
            return true;
        }

        public boolean mustSaveDocument(Object element) {
            return false;
        }

        public boolean canSaveDocument(Object element) {
            return false;
        }

        public IAnnotationModel getAnnotationModel(Object element) {
            return null;
        }

        public void aboutToChange(Object element) {
        }

        public void changed(Object element) {
        }

        public void addElementStateListener(IElementStateListener listener) {
        }

        public void removeElementStateListener(IElementStateListener listener) {
        }

        public boolean isReadOnly(Object element) {
            return true;
        }

        public boolean isModifiable(Object element) {
            return false;
        }

        public void validateState(Object element, Object computationContext) throws CoreException {
        }

        public boolean isStateValidated(Object element) {
            return true;
        }

        public void updateStateCache(Object element) throws CoreException {
        }

        public void setCanSaveDocument(Object element) {
        }

        public IStatus getStatus(Object element) {
            return STATUS_ERROR;
        }

        public void synchronize(Object element) throws CoreException {
        }

        public void setProgressMonitor(IProgressMonitor progressMonitor) {
        }

        public IProgressMonitor getProgressMonitor() {
            return new NullProgressMonitor();
        }

        public boolean isSynchronized(Object element) {
            return true;
        }

        public String getDefaultEncoding() {
            return null;
        }

        public String getEncoding(Object element) {
            return null;
        }

        public void setEncoding(Object element, String encoding) {
        }
    }

    protected static class FileInfo {
        public Object fElement;
        public int fCount;
        public ITextFileBuffer fTextFileBuffer;
        public IAnnotationModel fModel;
        public boolean fCachedReadOnlyState;

        protected FileInfo() {
        }
    }

    private static class SingleElementIterator
    implements Iterator {
        private Object fElement;

        public SingleElementIterator(Object element) {
            this.fElement = element;
        }

        public boolean hasNext() {
            return this.fElement != null;
        }

        public Object next() {
            if (this.fElement != null) {
                Object result = this.fElement;
                this.fElement = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class FileBufferListener
    implements IFileBufferListener {
        public void bufferContentAboutToBeReplaced(IFileBuffer file) {
            ArrayList list = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IElementStateListener l = (IElementStateListener)e.next();
                Iterator i = TextFileDocumentProvider.this.getElements(file);
                while (i.hasNext()) {
                    l.elementContentAboutToBeReplaced(i.next());
                }
            }
        }

        public void bufferContentReplaced(IFileBuffer file) {
            ArrayList list = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IElementStateListener l = (IElementStateListener)e.next();
                Iterator i = TextFileDocumentProvider.this.getElements(file);
                while (i.hasNext()) {
                    l.elementContentReplaced(i.next());
                }
            }
        }

        public void stateChanging(IFileBuffer file) {
            Iterator i = TextFileDocumentProvider.this.getElements(file);
            while (i.hasNext()) {
                TextFileDocumentProvider.this.fireElementStateChanging(i.next());
            }
        }

        public void dirtyStateChanged(IFileBuffer file, boolean isDirty) {
            ArrayList list = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IElementStateListener l = (IElementStateListener)e.next();
                Iterator i = TextFileDocumentProvider.this.getElements(file);
                while (i.hasNext()) {
                    l.elementDirtyStateChanged(i.next(), isDirty);
                }
            }
        }

        public void stateValidationChanged(IFileBuffer file, boolean isStateValidated) {
            ArrayList list = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                Object l = e.next();
                if (!(l instanceof IElementStateListenerExtension)) continue;
                IElementStateListenerExtension x = (IElementStateListenerExtension)l;
                Iterator i = TextFileDocumentProvider.this.getElements(file);
                while (i.hasNext()) {
                    x.elementStateValidationChanged(i.next(), isStateValidated);
                }
            }
        }

        public void underlyingFileMoved(IFileBuffer file, IPath newLocation) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile newFile = workspace.getRoot().getFile(newLocation);
            FileEditorInput input = newFile == null ? null : new FileEditorInput(newFile);
            ArrayList list = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IElementStateListener l = (IElementStateListener)e.next();
                Iterator i = TextFileDocumentProvider.this.getElements(file);
                while (i.hasNext()) {
                    l.elementMoved(i.next(), (Object)input);
                }
            }
        }

        public void underlyingFileDeleted(IFileBuffer file) {
            ArrayList list = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                IElementStateListener l = (IElementStateListener)e.next();
                Iterator i = TextFileDocumentProvider.this.getElements(file);
                while (i.hasNext()) {
                    l.elementDeleted(i.next());
                }
            }
        }

        public void stateChangeFailed(IFileBuffer file) {
            Iterator i = TextFileDocumentProvider.this.getElements(file);
            while (i.hasNext()) {
                TextFileDocumentProvider.this.fireElementStateChangeFailed(i.next());
            }
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
        }
    }
}

