/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ConvertLineDelimitersAction;
import org.eclipse.ui.texteditor.ExtendedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class TextEditor
extends ExtendedTextEditor {
    protected DefaultEncodingSupport fEncodingSupport;
    static /* synthetic */ Class class$0;

    public TextEditor() {
        this.initializeKeyBindingScopes();
        this.setSourceViewerConfiguration(new TextSourceViewerConfiguration());
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.configureInsertMode(ITextEditorExtension3.SMART_INSERT, false);
        this.setInsertMode(ITextEditorExtension3.INSERT);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        super.dispose();
    }

    public void doSaveAs() {
        if (this.askIfNonWorkbenchEncodingIsOk()) {
            super.doSaveAs();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.askIfNonWorkbenchEncodingIsOk()) {
            super.doSave(monitor);
        } else {
            monitor.setCanceled(true);
        }
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    private boolean askIfNonWorkbenchEncodingIsOk() {
        if (this.fEncodingSupport == null) {
            return true;
        }
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IStorageDocumentProvider) {
            IEditorInput input = this.getEditorInput();
            IStorageDocumentProvider storageProvider = (IStorageDocumentProvider)provider;
            String encoding = storageProvider.getEncoding(input);
            String defaultEncoding = storageProvider.getDefaultEncoding();
            if (encoding != null && !encoding.equals(defaultEncoding)) {
                Shell shell = this.getSite().getShell();
                String title = TextEditorMessages.getString("Editor.warning.save.nonWorkbenchEncoding.title");
                String msg = input != null ? MessageFormat.format(TextEditorMessages.getString("Editor.warning.save.nonWorkbenchEncoding.message1"), input.getName(), encoding) : MessageFormat.format(TextEditorMessages.getString("Editor.warning.save.nonWorkbenchEncoding.message2"), encoding);
                return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (provider.isDeleted((Object)input) && original != null) {
            String message = MessageFormat.format(TextEditorMessages.getString("Editor.warning.save.delete"), original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        boolean success = false;
        try {
            block20: {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    String title = TextEditorMessages.getString("Editor.error.save.title");
                    String msg = MessageFormat.format(TextEditorMessages.getString("Editor.error.save.message"), x.getMessage());
                    IStatus status = x.getStatus();
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block20;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
            throw throwable;
        }
        provider.changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createActions() {
        super.createActions();
        ConvertLineDelimitersAction action = new ConvertLineDelimitersAction(TextEditorMessages.getResourceBundle(), "Editor.ConvertToWindows.", (ITextEditor)this, "\r\n");
        action.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToWindows_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toWindows");
        this.setAction("ConvertLineDelimitersToWindows", (IAction)action);
        action = new ConvertLineDelimitersAction(TextEditorMessages.getResourceBundle(), "Editor.ConvertToUNIX.", (ITextEditor)this, "\n");
        action.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToUNIX_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toUNIX");
        this.setAction("ConvertLineDelimitersToUNIX", (IAction)action);
        action = new ConvertLineDelimitersAction(TextEditorMessages.getResourceBundle(), "Editor.ConvertToMac.", (ITextEditor)this, "\r");
        action.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToMAC_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toMac");
        this.setAction("ConvertLineDelimitersToMAC", (IAction)action);
        this.markAsStateDependentAction("ConvertLineDelimitersToWindows", true);
        this.markAsStateDependentAction("ConvertLineDelimitersToUNIX", true);
        this.markAsStateDependentAction("ConvertLineDelimitersToMAC", true);
        this.installEncodingSupport();
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.editors.text.IEncodingSupport;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.fEncodingSupport;
        }
        return super.getAdapter(adapter);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }
}

