/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.ITagHandler;
import org.eclipse.jface.text.source.ITagHandlerFactory;

public class TagHandlerFactory
implements ITagHandlerFactory {
    private Map fHandlers;

    public void addTagHandler(String tag, ITagHandler handler) {
        Assert.isNotNull((Object)tag);
        Assert.isNotNull((Object)handler);
        this.fHandlers.put(tag, handler);
    }

    public ITagHandler registerHandler(String tag) {
        Assert.isNotNull((Object)tag);
        return (ITagHandler)this.fHandlers.remove(tag);
    }

    public ITagHandler getHandler(String tag) {
        Assert.isNotNull((Object)tag);
        return (ITagHandler)this.fHandlers.get(tag);
    }

    public ITagHandler findHandler(String text) {
        Assert.isNotNull((Object)text);
        Iterator iter = this.fHandlers.values().iterator();
        while (iter.hasNext()) {
            ITagHandler handler = (ITagHandler)iter.next();
            if (!handler.canHandleText(text)) continue;
            return handler;
        }
        return null;
    }
}

