/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ProjectionAnnotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class OutlinerRulerColumn
extends AnnotationRulerColumn {
    public OutlinerRulerColumn(IAnnotationModel model, int width) {
        super(model, width);
    }

    protected void mouseDoubleClicked(int line) {
        ProjectionAnnotation annotation = this.findAnnotation(line);
        if (annotation != null) {
            annotation.run(this.getCachedTextViewer());
        }
    }

    private ProjectionAnnotation findAnnotation(int line) {
        IAnnotationModel model = this.getModel();
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                ProjectionAnnotation annotation;
                Position p;
                Object next = e.next();
                if (!(next instanceof ProjectionAnnotation) || !this.contains(p = model.getPosition(annotation = (ProjectionAnnotation)next), line)) continue;
                return annotation;
            }
        }
        return null;
    }

    private boolean contains(Position p, int line) {
        IDocument document = this.getCachedTextViewer().getDocument();
        try {
            int startLine = document.getLineOfOffset(p.getOffset());
            if (line < startLine) {
                return false;
            }
            if (line == startLine) {
                return true;
            }
            int endLine = document.getLineOfOffset(p.getOffset() + Math.max(p.getLength() - 1, 0));
            return startLine < line && line <= endLine;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        Control control = super.createControl(parentRuler, parentControl);
        Display display = parentControl.getDisplay();
        Color background = display.getSystemColor(25);
        control.setBackground(background);
        return control;
    }
}

