/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;

public class LineChangeHover
implements IAnnotationHover,
IAnnotationHoverExtension {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber, int first, int number) {
        int last = first + number - 1;
        String content = this.computeContent(sourceViewer, lineNumber, first, last);
        return this.formatSource(content);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return this.getHoverInfo(sourceViewer, lineNumber, 0, Integer.MAX_VALUE);
    }

    public ITextSelection getLineRange(ISourceViewer viewer, int line, int first, int number) {
        int last = first + number - 1;
        Point lineRange = this.computeLineRange(viewer, line, first, last);
        if (viewer != null && lineRange != null && lineRange.x != -1 && lineRange.y != -1) {
            try {
                IDocument document = viewer.getDocument();
                if (document != null) {
                    int offset = document.getLineOffset(lineRange.x);
                    IRegion endLine = document.getLineInformation(Math.max(lineRange.x, lineRange.y));
                    int endOffset = endLine.getOffset() + endLine.getLength();
                    int length = endOffset - offset + 1;
                    return new TextSelection(document, offset, length);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return new TextSelection(0, 0);
    }

    protected String formatSource(String content) {
        if (content != null) {
            StringBuffer sb = new StringBuffer(content);
            String tabReplacement = this.getTabReplacement();
            int pos = 0;
            while (pos < sb.length()) {
                if (sb.charAt(pos) == '\t') {
                    sb.replace(pos, pos + 1, tabReplacement);
                }
                ++pos;
            }
            return sb.toString();
        }
        return content;
    }

    protected String getTabReplacement() {
        return "    ";
    }

    private String computeContent(ISourceViewer viewer, int line, int first, int last) {
        Point contentRange = this.computeContentRange(viewer, line, first, last);
        if (contentRange == null) {
            return null;
        }
        ILineDiffer differ = this.getDiffer(viewer);
        if (differ == null) {
            return null;
        }
        if (line > contentRange.y + 1 || line < contentRange.x - 1) {
            return null;
        }
        LinkedList<ILineDiffInfo> lines = new LinkedList<ILineDiffInfo>();
        int l = contentRange.x;
        while (l <= contentRange.y) {
            lines.add(differ.getLineInfo(l));
            ++l;
        }
        int max = viewer.getBottomIndex();
        return this.decorateText(lines, max - contentRange.x + 1);
    }

    /*
     * Unable to fully structure code
     */
    protected String decorateText(List diffInfos, int maxLines) {
        text = new String();
        added = 0;
        it = diffInfos.iterator();
        while (it.hasNext()) {
            info = (ILineDiffInfo)it.next();
            original = info.getOriginalText();
            type = info.getChangeType();
            i = 0;
            if (type == 1) {
                ++added;
            } else if (type == 2) {
                text = String.valueOf(text) + "> " + (original.length > 0 ? original[i++] : "");
                --maxLines;
            } else if (type == 0) {
                ++maxLines;
            }
            if (maxLines != 0) ** GOTO lbl25
            return this.trimTrailing(text);
lbl-1000:
            // 1 sources

            {
                text = String.valueOf(text) + "- " + original[i];
                --added;
                if (--maxLines == 0) {
                    return this.trimTrailing(text);
                }
                ++i;
lbl25:
                // 2 sources

                ** while (i < original.length)
            }
lbl26:
            // 1 sources

        }
        if ((text = text.trim()).length() == 0 && added-- > 0 && maxLines-- > 0) {
            text = String.valueOf(text) + "+ ";
        }
        while (added-- > 0 && maxLines-- > 0) {
            text = String.valueOf(text) + "\n+ ";
        }
        return text;
    }

    private String trimTrailing(String text) {
        int pos = text.length() - 1;
        while (pos >= 0 && Character.isWhitespace(text.charAt(pos))) {
            --pos;
        }
        return text.substring(0, pos + 1);
    }

    private ILineDiffer getDiffer(ISourceViewer viewer) {
        IAnnotationModel diffModel;
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        if (model instanceof IAnnotationModelExtension && (diffModel = ((IAnnotationModelExtension)((Object)model)).getAnnotationModel("diff")) != null) {
            model = diffModel;
        }
        if (model instanceof ILineDiffer) {
            return (ILineDiffer)((Object)model);
        }
        return null;
    }

    private Point computeContentRange(ISourceViewer viewer, int line, int first, int last) {
        ILineDiffer differ = this.getDiffer(viewer);
        if (differ == null) {
            return null;
        }
        Point lineRange = this.computeLineRange(viewer, line, first, last);
        if (lineRange == null) {
            return null;
        }
        int l = lineRange.x - 1;
        ILineDiffInfo info = differ.getLineInfo(l);
        if (l >= first - 1 && info != null && info.getChangeType() == 0 && info.getRemovedLinesBelow() > 0) {
            return new Point(l, lineRange.y);
        }
        return lineRange;
    }

    protected Point computeLineRange(ISourceViewer viewer, int line, int min, int max) {
        ILineDiffer differ = this.getDiffer(viewer);
        if (differ == null) {
            return null;
        }
        int l = line;
        ILineDiffInfo info = differ.getLineInfo(l);
        if (l >= min && info != null && info.getChangeType() == 0 && info.getRemovedLinesAbove() > 0) {
            info = differ.getLineInfo(--l);
        }
        while (l >= min && info != null && (info.getChangeType() == 2 || info.getChangeType() == 1)) {
            info = differ.getLineInfo(--l);
        }
        int first = l + 1;
        l = line;
        info = differ.getLineInfo(l);
        if (l <= max && info != null && info.getChangeType() == 0 && info.getRemovedLinesBelow() > 0) {
            info = differ.getLineInfo(++l);
        }
        while (l <= max && info != null && (info.getChangeType() == 2 || info.getChangeType() == 1)) {
            info = differ.getLineInfo(++l);
        }
        int last = l - 1;
        return new Point(first, last);
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }
}

