/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AnnotationRulerColumn
implements IVerticalRulerColumn {
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private IAnnotationModel fModel;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private boolean fAllowSetModel = true;
    private Set fConfiguredAnnotationTypes = new HashSet();
    private Set fAllowedAnnotationTypes = new HashSet();
    private IAnnotationAccess fAnnotationAccess;

    public AnnotationRulerColumn(IAnnotationModel model, int width, IAnnotationAccess annotationAccess) {
        this.fWidth = width;
        this.fAllowSetModel = false;
        this.fModel = model;
        this.fModel.addAnnotationModelListener(this.fInternalListener);
        this.fAnnotationAccess = annotationAccess;
    }

    public AnnotationRulerColumn(int width, IAnnotationAccess annotationAccess) {
        this.fWidth = width;
        this.fAnnotationAccess = annotationAccess;
    }

    public AnnotationRulerColumn(IAnnotationModel model, int width) {
        this.fWidth = width;
        this.fAllowSetModel = false;
        this.fModel = model;
        this.fModel.addAnnotationModelListener(this.fInternalListener);
    }

    public AnnotationRulerColumn(int width) {
        this.fWidth = width;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (AnnotationRulerColumn.this.fCachedTextViewer != null) {
                    AnnotationRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AnnotationRulerColumn.this.handleDispose();
                AnnotationRulerColumn.this.fCachedTextViewer = null;
                AnnotationRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fCanvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent event) {
            }

            public void mouseDown(MouseEvent event) {
                AnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            }

            public void mouseDoubleClick(MouseEvent event) {
                AnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
                AnnotationRulerColumn.this.mouseDoubleClicked(AnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity());
            }
        });
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
        }
        return this.fCanvas;
    }

    protected void mouseDoubleClicked(int rulerLine) {
    }

    private void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fAnnotationAccess = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        gc.setFont(this.fCachedTextWidget.getFont());
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.fCachedTextViewer instanceof ITextViewerExtension3) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected int getInclusiveTopIndexStartOffset() {
        if (this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
            int top = this.fCachedTextViewer.getTopIndex();
            if (this.fCachedTextWidget.getTopPixel() % this.fCachedTextWidget.getLineHeight() != 0) {
                --top;
            }
            try {
                IDocument document = this.fCachedTextViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    protected void doPaint(GC gc) {
        int bottomRight;
        IRegion coverage;
        Object extension;
        if (this.fModel == null || this.fCachedTextViewer == null) {
            return;
        }
        IAnnotationAccessExtension annotationAccessExtension = null;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            annotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
        }
        int topLeft = this.getInclusiveTopIndexStartOffset();
        if (this.fCachedTextViewer instanceof ITextViewerExtension3) {
            extension = (ITextViewerExtension3)((Object)this.fCachedTextViewer);
            coverage = extension.getModelCoverage();
            bottomRight = coverage.getOffset() + coverage.getLength();
        } else if (this.fCachedTextViewer instanceof TextViewer) {
            extension = (TextViewer)this.fCachedTextViewer;
            coverage = ((TextViewer)extension).getModelCoverage();
            bottomRight = coverage.getOffset() + coverage.getLength();
        } else {
            bottomRight = this.fCachedTextViewer.getBottomIndexEndOffset() + 1;
        }
        int viewPort = bottomRight - topLeft;
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        Point dimension = this.fCanvas.getSize();
        int shift = this.fCachedTextViewer.getTopInset();
        IDocument doc = this.fCachedTextViewer.getDocument();
        int topLine = -1;
        int bottomLine = -1;
        try {
            IRegion region = this.fCachedTextViewer.getVisibleRegion();
            topLine = doc.getLineOfOffset(region.getOffset());
            bottomLine = doc.getLineOfOffset(region.getOffset() + region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int maxLayer = 1;
        int layer = 0;
        while (layer < maxLayer) {
            Iterator iter = this.fModel.getAnnotationIterator();
            while (iter.hasNext()) {
                int viewPortSize;
                Position position;
                Annotation annotation = (Annotation)iter.next();
                if (this.skip(annotation)) continue;
                int lay = 0;
                if (annotationAccessExtension != null) {
                    lay = annotationAccessExtension.getLayer(annotation);
                }
                maxLayer = Math.max(maxLayer, lay + 1);
                if (lay != layer || (position = this.fModel.getPosition(annotation)) == null) continue;
                int n = viewPortSize = position.getLength() == 0 ? viewPort + 1 : viewPort;
                if (!position.overlapsWith(topLeft, viewPortSize)) continue;
                try {
                    int offset = position.getOffset();
                    int length = position.getLength();
                    int startLine = doc.getLineOfOffset(offset);
                    if (startLine < topLine) {
                        startLine = topLine;
                    }
                    int endLine = startLine;
                    if (length > 0) {
                        endLine = doc.getLineOfOffset(offset + length - 1);
                    }
                    if (endLine > bottomLine) {
                        endLine = bottomLine;
                    }
                    r.x = 0;
                    r.y = (startLine -= topLine) * lineheight - this.fScrollPos + shift;
                    r.width = dimension.x;
                    int lines = (endLine -= topLine) - startLine;
                    if (lines < 0) {
                        lines = -lines;
                    }
                    r.height = (lines + 1) * lineheight;
                    if (r.y >= dimension.y || annotationAccessExtension == null) continue;
                    annotationAccessExtension.paint(annotation, gc, this.fCanvas, r);
                }
                catch (BadLocationException badLocationException) {}
            }
            ++layer;
        }
    }

    protected void doPaint1(GC gc) {
        if (this.fModel == null || this.fCachedTextViewer == null) {
            return;
        }
        IAnnotationAccessExtension annotationAccessExtension = null;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            annotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
        }
        ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fCachedTextViewer);
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        Point dimension = this.fCanvas.getSize();
        int shift = this.fCachedTextViewer.getTopInset();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int maxLayer = 1;
        int layer = 0;
        while (layer < maxLayer) {
            Iterator iter = this.fModel.getAnnotationIterator();
            while (iter.hasNext()) {
                int endLine;
                int startLine;
                IRegion widgetRegion;
                Position position;
                Annotation annotation = (Annotation)iter.next();
                if (this.fAnnotationAccess != null && this.skip(annotation)) continue;
                int lay = 0;
                if (annotationAccessExtension != null) {
                    lay = annotationAccessExtension.getLayer(annotation);
                }
                maxLayer = Math.max(maxLayer, lay + 1);
                if (lay != layer || (position = this.fModel.getPosition(annotation)) == null || (widgetRegion = extension.modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength()))) == null || (startLine = extension.widgetLineOfWidgetOffset(widgetRegion.getOffset())) == -1 || (endLine = extension.widgetLineOfWidgetOffset(widgetRegion.getOffset() + Math.max(widgetRegion.getLength() - 1, 0))) == -1) continue;
                r.x = 0;
                r.y = startLine * lineheight - this.fScrollPos + shift;
                r.width = dimension.x;
                int lines = endLine - startLine;
                if (lines < 0) {
                    lines = -lines;
                }
                r.height = (lines + 1) * lineheight;
                if (r.y >= dimension.y || annotationAccessExtension == null) continue;
                annotationAccessExtension.paint(annotation, gc, this.fCanvas, r);
            }
            ++layer;
        }
    }

    private void postRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    AnnotationRulerColumn.this.redraw();
                }
            });
        }
    }

    public void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
        if (this.fAllowSetModel && model != this.fModel) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener(this.fInternalListener);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener(this.fInternalListener);
            }
            this.postRedraw();
        }
    }

    public void setFont(Font font) {
    }

    protected ITextViewer getCachedTextViewer() {
        return this.fCachedTextViewer;
    }

    protected IAnnotationModel getModel() {
        return this.fModel;
    }

    public void addAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.add(annotationType);
    }

    public void removeAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.remove(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    private boolean skip(Annotation annotation) {
        Object annotationType = this.fAnnotationAccess.getType(annotation);
        if (this.fAllowedAnnotationTypes.contains(annotationType)) {
            return false;
        }
        boolean skip = this.skip(annotationType);
        if (!skip) {
            this.fAllowedAnnotationTypes.add(annotationType);
        }
        return skip;
    }

    private boolean skip(Object annotationType) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            Iterator e = this.fConfiguredAnnotationTypes.iterator();
            while (e.hasNext()) {
                if (!extension.isSubtype(annotationType, e.next())) continue;
                return false;
            }
            return true;
        }
        return !this.fConfiguredAnnotationTypes.contains(annotationType);
    }

    class InternalListener
    implements IViewportListener,
    IAnnotationModelListener,
    ITextListener {
        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (verticalPosition != AnnotationRulerColumn.this.fScrollPos) {
                AnnotationRulerColumn.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel model) {
            AnnotationRulerColumn.this.postRedraw();
        }

        public void textChanged(TextEvent e) {
            if (e.getViewerRedrawState()) {
                AnnotationRulerColumn.this.postRedraw();
            }
        }
    }
}

