/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class AnnotationPainter
implements IPainter,
PaintListener,
IAnnotationModelListener,
ITextPresentationListener {
    private boolean fIsActive = false;
    private boolean fIsPainting = false;
    private boolean fIsSettingModel = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private IAnnotationModel fModel;
    private IAnnotationAccess fAnnotationAccess;
    private List fDecorations = new ArrayList();
    private List fHighlightedDecorations = new ArrayList();
    private Map fColorTable = new HashMap();
    private Set fConfiguredAnnotationTypes = new HashSet();
    private Set fAllowedAnnotationTypes = new HashSet();
    private Set fConfiguredHighlightAnnotationTypes = new HashSet();
    private Set fAllowedHighlightAnnotationTypes = new HashSet();
    private Position fHighlightAnnotationRange = new Position(Integer.MAX_VALUE);
    private ITextInputListener fTextInputListener;
    private boolean fInputDocumentAboutToBeChanged;

    public AnnotationPainter(ISourceViewer sourceViewer, IAnnotationAccess access) {
        this.fSourceViewer = sourceViewer;
        this.fAnnotationAccess = access;
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    private boolean hasDecorations() {
        return !this.fDecorations.isEmpty();
    }

    private void enablePainting() {
        if (!this.fIsPainting && this.hasDecorations()) {
            this.fIsPainting = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    private void disablePainting(boolean redraw) {
        if (this.fIsPainting) {
            this.fIsPainting = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw && this.hasDecorations()) {
                this.handleDrawRequest(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setModel(IAnnotationModel model) {
        if (this.fModel == model) return;
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener(this);
        }
        this.fModel = model;
        if (this.fModel == null) return;
        AnnotationPainter annotationPainter = this;
        synchronized (annotationPainter) {
            try {
                this.fIsSettingModel = true;
                this.fModel.addAnnotationModelListener(this);
                Object var3_5 = null;
                this.fIsSettingModel = false;
                return;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fIsSettingModel = false;
                throw throwable;
            }
        }
    }

    private synchronized void catchupWithModel() {
        if (this.fDecorations != null) {
            this.fDecorations.clear();
            this.fHighlightedDecorations.clear();
            int highlightAnnotationRangeStart = Integer.MAX_VALUE;
            int highlightAnnotationRangeEnd = -1;
            if (this.fModel != null) {
                Iterator e = this.fModel.getAnnotationIterator();
                while (e.hasNext()) {
                    Position position;
                    Annotation annotation = (Annotation)e.next();
                    if (annotation.isMarkedDeleted()) continue;
                    Color color = null;
                    Object annotationType = this.fAnnotationAccess.getType(annotation);
                    boolean isHighlighting = this.shouldBeHighlighted(annotationType);
                    boolean isDrawingSquiggles = this.shouldBeDrawn(annotationType);
                    if (isDrawingSquiggles || isHighlighting) {
                        color = this.findColor(annotationType);
                    }
                    if (color == null || (position = this.fModel.getPosition(annotation)) == null || position.isDeleted()) continue;
                    Decoration pp = new Decoration();
                    pp.fPosition = position;
                    pp.fColor = color;
                    if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
                        IAnnotationAccessExtension extension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
                        pp.fLayer = extension.getLayer(annotation);
                    } else {
                        pp.fLayer = 0;
                    }
                    if (isDrawingSquiggles) {
                        this.fDecorations.add(pp);
                    }
                    if (!isHighlighting) continue;
                    this.fHighlightedDecorations.add(pp);
                    highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, position.offset);
                    highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, position.offset + position.length);
                }
                if (highlightAnnotationRangeStart != Integer.MAX_VALUE) {
                    int end = Math.max(this.fHighlightAnnotationRange.offset + this.fHighlightAnnotationRange.length, highlightAnnotationRangeEnd);
                    end = Math.min(end, this.fSourceViewer.getDocument().getLength());
                    this.fHighlightAnnotationRange.offset = Math.min(this.fHighlightAnnotationRange.offset, highlightAnnotationRangeStart);
                    this.fHighlightAnnotationRange.offset = Math.min(this.fHighlightAnnotationRange.offset, this.fSourceViewer.getDocument().getLength());
                    this.fHighlightAnnotationRange.length = end - this.fHighlightAnnotationRange.offset;
                }
            }
        }
    }

    private boolean shouldBeDrawn(Object annotationType) {
        return this.contains(annotationType, this.fAllowedAnnotationTypes, this.fConfiguredAnnotationTypes);
    }

    private boolean shouldBeHighlighted(Object annotationType) {
        return this.contains(annotationType, this.fAllowedHighlightAnnotationTypes, this.fConfiguredHighlightAnnotationTypes);
    }

    private boolean contains(Object annotationType, Set allowed, Set configured) {
        if (allowed.contains(annotationType)) {
            return true;
        }
        boolean covered = this.isCovered(annotationType, configured);
        if (covered) {
            allowed.add(annotationType);
        }
        return covered;
    }

    private boolean isCovered(Object annotationType, Set configured) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            Iterator e = configured.iterator();
            while (e.hasNext()) {
                if (!extension.isSubtype(annotationType, e.next())) continue;
                return true;
            }
            return false;
        }
        return configured.contains(annotationType);
    }

    private Color findColor(Object annotationType) {
        IAnnotationAccessExtension extension;
        Object[] superTypes;
        Color color = (Color)this.fColorTable.get(annotationType);
        if (color != null) {
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (superTypes = (extension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess)).getSupertypes(annotationType)) != null) {
            int i = superTypes.length - 1;
            while (i > -1) {
                color = (Color)this.fColorTable.get(superTypes[i]);
                if (color != null) {
                    return color;
                }
                --i;
            }
        }
        return null;
    }

    private void updatePainting() {
        this.disablePainting(true);
        this.catchupWithModel();
        if (!this.fInputDocumentAboutToBeChanged) {
            this.invalidateTextPresentation();
        }
        this.enablePainting();
    }

    private void invalidateTextPresentation() {
        if (this.fSourceViewer instanceof ITextViewerExtension2) {
            Object r = this.fHighlightAnnotationRange != null && this.fHighlightAnnotationRange.getOffset() != Integer.MAX_VALUE ? new Region(this.fHighlightAnnotationRange.getOffset(), this.fHighlightAnnotationRange.getLength()) : this.fSourceViewer.getVisibleRegion();
            ((ITextViewerExtension2)((Object)this.fSourceViewer)).invalidateTextPresentation(r.getOffset(), r.getLength());
        } else {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    public synchronized void applyTextPresentation(TextPresentation tp) {
        IRegion region = tp.getExtent();
        int layer = 0;
        int maxLayer = 1;
        while (layer < maxLayer) {
            Iterator iter = this.fHighlightedDecorations.iterator();
            while (iter.hasNext()) {
                Decoration pp = (Decoration)iter.next();
                maxLayer = Math.max(maxLayer, pp.fLayer + 1);
                if (pp.fLayer != layer) continue;
                Position p = pp.fPosition;
                if (!this.fSourceViewer.overlapsWithVisibleRegion(p.offset, p.length) || p.getOffset() + p.getLength() < region.getOffset() || region.getOffset() + region.getLength() <= p.getOffset()) continue;
                tp.mergeStyleRange(new StyleRange(p.getOffset(), p.getLength(), null, pp.fColor));
            }
            ++layer;
        }
    }

    public synchronized void modelChanged(IAnnotationModel model) {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            if (this.fIsSettingModel) {
                this.updatePainting();
            } else {
                Display d = this.fTextWidget.getDisplay();
                if (d != null) {
                    d.asyncExec(new Runnable(){

                        public void run() {
                            if (AnnotationPainter.this.fTextWidget != null && !AnnotationPainter.this.fTextWidget.isDisposed()) {
                                AnnotationPainter.this.updatePainting();
                            }
                        }
                    });
                }
            }
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fColorTable.put(annotationType, color);
        } else {
            this.fColorTable.remove(annotationType);
        }
    }

    public void addAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.add(annotationType);
    }

    public void addHighlightAnnotationType(Object annotationType) {
        this.fConfiguredHighlightAnnotationTypes.add(annotationType);
        if (this.fTextInputListener == null) {
            this.fTextInputListener = new ITextInputListener(){

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    AnnotationPainter.this.fInputDocumentAboutToBeChanged = true;
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    AnnotationPainter.this.fInputDocumentAboutToBeChanged = false;
                }
            };
            this.fSourceViewer.addTextInputListener(this.fTextInputListener);
        }
    }

    public void removeAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.remove(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void removeHighlightAnnotationType(Object annotationType) {
        this.fConfiguredHighlightAnnotationTypes.remove(annotationType);
        this.fAllowedHighlightAnnotationTypes.clear();
        if (this.fConfiguredHighlightAnnotationTypes.isEmpty() && this.fTextInputListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextInputListener);
            this.fTextInputListener = null;
            this.fInputDocumentAboutToBeChanged = false;
        }
    }

    public void removeAllAnnotationTypes() {
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fConfiguredHighlightAnnotationTypes.clear();
        this.fAllowedHighlightAnnotationTypes.clear();
        if (this.fTextInputListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextInputListener);
            this.fTextInputListener = null;
        }
    }

    public boolean isPaintingAnnotations() {
        return !this.fConfiguredAnnotationTypes.isEmpty() || !this.fConfiguredHighlightAnnotationTypes.isEmpty();
    }

    public void dispose() {
        if (this.fColorTable != null) {
            this.fColorTable.clear();
        }
        this.fColorTable = null;
        if (this.fConfiguredAnnotationTypes != null) {
            this.fConfiguredAnnotationTypes.clear();
        }
        this.fConfiguredAnnotationTypes = null;
        if (this.fAllowedAnnotationTypes != null) {
            this.fAllowedAnnotationTypes.clear();
        }
        this.fAllowedAnnotationTypes = null;
        if (this.fConfiguredHighlightAnnotationTypes != null) {
            this.fConfiguredHighlightAnnotationTypes.clear();
        }
        this.fConfiguredHighlightAnnotationTypes = null;
        if (this.fAllowedHighlightAnnotationTypes != null) {
            this.fAllowedHighlightAnnotationTypes.clear();
        }
        this.fAllowedHighlightAnnotationTypes = null;
        this.fTextWidget = null;
        this.fSourceViewer = null;
        this.fAnnotationAccess = null;
        this.fModel = null;
        this.fDecorations = null;
        this.fHighlightedDecorations = null;
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int top = this.fSourceViewer.getTopIndex();
            if (this.fTextWidget.getTopPixel() % this.fTextWidget.getLineHeight() != 0) {
                --top;
            }
            try {
                IDocument document = this.fSourceViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    private void handleDrawRequest(GC gc) {
        if (this.fTextWidget == null) {
            return;
        }
        int vOffset = this.getInclusiveTopIndexStartOffset();
        int vLength = this.fSourceViewer.getBottomIndexEndOffset() + 1;
        int layer = 0;
        int maxLayer = 1;
        while (layer < maxLayer) {
            Iterator e = this.fDecorations.iterator();
            while (e.hasNext()) {
                Position p;
                Decoration pp = (Decoration)e.next();
                maxLayer = Math.max(maxLayer, pp.fLayer + 1);
                if (pp.fLayer != layer || !(p = pp.fPosition).overlapsWith(vOffset, vLength)) continue;
                IDocument document = this.fSourceViewer.getDocument();
                try {
                    int startLine = document.getLineOfOffset(p.getOffset());
                    int lastInclusive = Math.max(p.getOffset(), p.getOffset() + p.getLength() - 1);
                    int endLine = document.getLineOfOffset(lastInclusive);
                    int i = startLine;
                    while (i <= endLine) {
                        IRegion widgetRange;
                        IRegion line = document.getLineInformation(i);
                        int paintStart = Math.max(line.getOffset(), p.getOffset());
                        int paintEnd = Math.min(line.getOffset() + line.getLength(), p.getOffset() + p.getLength());
                        if (paintEnd > paintStart && (widgetRange = this.getWidgetRange(new Position(paintStart, paintEnd - paintStart))) != null) {
                            this.draw(gc, widgetRange.getOffset(), widgetRange.getLength(), pp.fColor);
                        }
                        ++i;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            ++layer;
        }
    }

    private IRegion getWidgetRange(Position p) {
        int length;
        if (p == null || p.offset == Integer.MAX_VALUE) {
            return null;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fSourceViewer);
            return extension.modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength()));
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int offset = region.getOffset();
        if (p.overlapsWith(offset, length = region.getLength())) {
            int p1 = Math.max(offset, p.getOffset());
            int p2 = Math.min(offset + length, p.getOffset() + p.getLength());
            return new Region(p1 - offset, p2 - p1);
        }
        return null;
    }

    private int[] computePolyline(Point left, Point right, int height) {
        int peeks = (right.x - left.x) / 4;
        int leftX = left.x;
        int length = (2 * peeks + 1) * 2;
        if (length < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int bottom = left.y + height - 1;
        int top = bottom - 2;
        int i = 0;
        while (i < peeks) {
            int index = 4 * i;
            coordinates[index] = leftX + 4 * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left.x + 4 * peeks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    private void draw(GC gc, int offset, int length, Color color) {
        if (gc != null) {
            Point left = this.fTextWidget.getLocationAtOffset(offset);
            Point right = this.fTextWidget.getLocationAtOffset(offset + length);
            gc.setForeground(color);
            int[] polyline = this.computePolyline(left, right, gc.getFontMetrics().getHeight());
            gc.drawPolyline(polyline);
        } else {
            this.fTextWidget.redrawRange(offset, length, true);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.disablePainting(redraw);
            this.setModel(null);
            this.catchupWithModel();
        }
    }

    public void paint(int reason) {
        if (this.fSourceViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            IAnnotationModel model = this.fSourceViewer.getAnnotationModel();
            if (model != null) {
                this.fIsActive = true;
                this.setModel(this.fSourceViewer.getAnnotationModel());
            }
        } else if (16 == reason || 8 == reason) {
            this.updatePainting();
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    private static class Decoration {
        private Position fPosition;
        private Color fColor;
        private int fLayer;

        Decoration() {
        }
    }
}

