/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;

public class AnnotationModel
implements IAnnotationModel,
IAnnotationModelExtension {
    protected Map fAnnotations;
    protected ArrayList fAnnotationModelListeners;
    protected IDocument fDocument;
    private int fOpenConnections = 0;
    private IDocumentListener fDocumentListener;
    private boolean fDocumentChanged = true;
    private Map fAttachments = new HashMap();
    private IAnnotationModelListener fModelListener = new InternalModelListener();
    private AnnotationModelEvent fModelEvent = new AnnotationModelEvent(this);

    public AnnotationModel() {
        this.fAnnotations = Collections.synchronizedMap(new HashMap(10));
        this.fAnnotationModelListeners = new ArrayList(2);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                AnnotationModel.this.fDocumentChanged = true;
            }
        };
    }

    public void addAnnotation(Annotation annotation, Position position) {
        try {
            this.addAnnotation(annotation, position, true);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void replaceAnnotations(Annotation[] annotationsToRemove, Map annotationsToAdd) {
        try {
            this.replaceAnnotations(annotationsToRemove, annotationsToAdd, true);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void replaceAnnotations(Annotation[] annotationsToRemove, Map annotationsToAdd, boolean fireModelChanged) throws BadLocationException {
        if (annotationsToRemove != null) {
            int i = 0;
            int length = annotationsToRemove.length;
            while (i < length) {
                this.removeAnnotation(annotationsToRemove[i], false);
                ++i;
            }
        }
        if (annotationsToAdd != null) {
            Iterator iter = annotationsToAdd.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry mapEntry = iter.next();
                Annotation annotation = (Annotation)mapEntry.getKey();
                Position position = (Position)mapEntry.getValue();
                this.addAnnotation(annotation, position, false);
            }
        }
        if (fireModelChanged) {
            this.fireModelChanged();
        }
    }

    protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
        if (!this.fAnnotations.containsKey(annotation)) {
            this.addPosition(this.fDocument, position);
            this.fAnnotations.put(annotation, position);
            this.fModelEvent.annotationAdded(annotation);
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (!this.fAnnotationModelListeners.contains(listener)) {
            this.fAnnotationModelListeners.add(listener);
            listener.modelChanged(this);
        }
    }

    protected void addPosition(IDocument document, Position position) throws BadLocationException {
        if (document != null) {
            document.addPosition(position);
        }
    }

    public void connect(IDocument document) {
        Assert.isTrue((this.fDocument == null || this.fDocument == document ? 1 : 0) != 0);
        if (this.fDocument == null) {
            this.fDocument = document;
            Iterator e = this.fAnnotations.values().iterator();
            while (e.hasNext()) {
                try {
                    this.addPosition(this.fDocument, (Position)e.next());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        ++this.fOpenConnections;
        if (this.fOpenConnections == 1) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
            this.connected();
        }
        Iterator it = this.fAttachments.keySet().iterator();
        while (it.hasNext()) {
            IAnnotationModel model = (IAnnotationModel)this.fAttachments.get(it.next());
            model.connect(document);
        }
    }

    protected void connected() {
    }

    protected void disconnected() {
    }

    public void disconnect(IDocument document) {
        Assert.isTrue((this.fDocument == document ? 1 : 0) != 0);
        Iterator it = this.fAttachments.keySet().iterator();
        while (it.hasNext()) {
            IAnnotationModel model = (IAnnotationModel)this.fAttachments.get(it.next());
            model.disconnect(document);
        }
        --this.fOpenConnections;
        if (this.fOpenConnections == 0) {
            this.disconnected();
            this.fDocument.removeDocumentListener(this.fDocumentListener);
            if (this.fDocument != null) {
                Iterator e = this.fAnnotations.values().iterator();
                while (e.hasNext()) {
                    Position p = (Position)e.next();
                    this.fDocument.removePosition(p);
                }
                this.fDocument = null;
            }
        }
    }

    protected void fireModelChanged() {
        AnnotationModelEvent event = this.fModelEvent;
        this.fModelEvent = this.createAnnotationModelEvent();
        this.fModelEvent.markWorldChange(false);
        this.fireModelChanged(event);
    }

    protected AnnotationModelEvent createAnnotationModelEvent() {
        return new AnnotationModelEvent(this);
    }

    protected void fireModelChanged(AnnotationModelEvent event) {
        if (event.isEmpty()) {
            return;
        }
        ArrayList v = new ArrayList(this.fAnnotationModelListeners);
        Iterator e = v.iterator();
        while (e.hasNext()) {
            IAnnotationModelListener l = (IAnnotationModelListener)e.next();
            if (l instanceof IAnnotationModelListenerExtension) {
                ((IAnnotationModelListenerExtension)((Object)l)).modelChanged(event);
                continue;
            }
            l.modelChanged(this);
        }
    }

    protected void removeAnnotations(List annotations, boolean fireModelChanged, boolean modelInitiated) {
        if (annotations.size() > 0) {
            Iterator e = annotations.iterator();
            while (e.hasNext()) {
                this.removeAnnotation((Annotation)e.next(), false);
            }
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    protected void cleanup(boolean fireModelChanged) {
        if (this.fDocumentChanged) {
            this.fDocumentChanged = false;
            ArrayList<Annotation> deleted = new ArrayList<Annotation>();
            Iterator e = new ArrayList(this.fAnnotations.keySet()).iterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = (Position)this.fAnnotations.get(a);
                if (p != null && !p.isDeleted()) continue;
                deleted.add(a);
            }
            this.removeAnnotations(deleted, fireModelChanged, false);
        }
    }

    public Iterator getAnnotationIterator() {
        return this.getAnnotationIterator(true, true);
    }

    private Iterator getAnnotationIterator(boolean cleanup, boolean recurse) {
        if (!recurse) {
            return this.getAnnotationIterator(cleanup);
        }
        ArrayList<Iterator> iterators = new ArrayList<Iterator>(this.fAttachments.size() + 1);
        iterators.add(this.getAnnotationIterator(cleanup));
        Iterator it = this.fAttachments.keySet().iterator();
        while (it.hasNext()) {
            iterators.add(((IAnnotationModel)this.fAttachments.get(it.next())).getAnnotationIterator());
        }
        final Iterator iter = iterators.iterator();
        return new Iterator(){
            private Iterator fCurrent;
            {
                this.fCurrent = (Iterator)iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                if (this.fCurrent.hasNext()) {
                    return true;
                }
                if (iter.hasNext()) {
                    this.fCurrent = (Iterator)iter.next();
                    return this.hasNext();
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.fCurrent.next();
            }
        };
    }

    protected Iterator getAnnotationIterator(boolean cleanup) {
        if (cleanup) {
            this.cleanup(false);
        }
        Map map = this.fAnnotations;
        synchronized (map) {
            return new ArrayList(this.fAnnotations.keySet()).iterator();
        }
    }

    public Position getPosition(Annotation annotation) {
        Position position = (Position)this.fAnnotations.get(annotation);
        if (position != null) {
            return position;
        }
        Iterator it = this.fAttachments.values().iterator();
        while (position == null && it.hasNext()) {
            position = ((IAnnotationModel)it.next()).getPosition(annotation);
        }
        return position;
    }

    public void removeAllAnnotations() {
        this.removeAllAnnotations(true);
    }

    protected void removeAllAnnotations(boolean fireModelChanged) {
        if (this.fDocument != null) {
            Iterator e = this.fAnnotations.keySet().iterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = (Position)this.fAnnotations.get(a);
                this.fDocument.removePosition(p);
                this.fModelEvent.annotationRemoved(a);
            }
        }
        this.fAnnotations.clear();
        if (fireModelChanged) {
            this.fireModelChanged();
        }
    }

    public void removeAnnotation(Annotation annotation) {
        this.removeAnnotation(annotation, true);
    }

    protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
        if (this.fAnnotations.containsKey(annotation)) {
            if (this.fDocument != null) {
                Position p = (Position)this.fAnnotations.get(annotation);
                this.fDocument.removePosition(p);
            }
            this.fAnnotations.remove(annotation);
            this.fModelEvent.annotationRemoved(annotation);
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    public void modifyAnnotation(Annotation annotation, Position position) {
        this.modifyAnnotation(annotation, position, true);
    }

    protected void modifyAnnotation(Annotation annotation, Position position, boolean fireModelChanged) {
        if (position == null) {
            this.removeAnnotation(annotation, fireModelChanged);
        } else {
            Position p = (Position)this.fAnnotations.get(annotation);
            if (p != null) {
                if (position.getOffset() != p.getOffset() && position.getLength() != p.getLength()) {
                    p.setOffset(position.getOffset());
                    p.setLength(position.getLength());
                }
                this.fModelEvent.annotationChanged(annotation);
                if (fireModelChanged) {
                    this.fireModelChanged();
                }
            } else {
                try {
                    this.addAnnotation(annotation, position, fireModelChanged);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.fAnnotationModelListeners.remove(listener);
    }

    public void addAnnotationModel(Object key, IAnnotationModel attachment) {
        Assert.isNotNull((Object)attachment);
        if (!this.fAttachments.containsValue(attachment)) {
            this.fAttachments.put(key, attachment);
            int i = 0;
            while (i < this.fOpenConnections) {
                attachment.connect(this.fDocument);
                ++i;
            }
            attachment.addAnnotationModelListener(this.fModelListener);
        }
    }

    public IAnnotationModel getAnnotationModel(Object key) {
        return (IAnnotationModel)this.fAttachments.get(key);
    }

    public IAnnotationModel removeAnnotationModel(Object key) {
        IAnnotationModel ret = (IAnnotationModel)this.fAttachments.remove(key);
        if (ret != null) {
            int i = 0;
            while (i < this.fOpenConnections) {
                ret.disconnect(this.fDocument);
                ++i;
            }
            ret.removeAnnotationModelListener(this.fModelListener);
        }
        return ret;
    }

    private class InternalModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        InternalModelListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            AnnotationModel.this.fireModelChanged(new AnnotationModelEvent(model, true));
        }

        public void modelChanged(AnnotationModelEvent event) {
            AnnotationModel.this.fireModelChanged(event);
        }
    }
}

