/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class AnnotationBarHoverManager
extends AbstractHoverInformationControlManager {
    private ISourceViewer fSourceViewer;
    private IVerticalRulerInfo fVerticalRulerInfo;
    private IAnnotationHover fAnnotationHover;

    public AnnotationBarHoverManager(ISourceViewer sourceViewer, IVerticalRuler ruler, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        this(ruler, sourceViewer, annotationHover, creator);
    }

    public AnnotationBarHoverManager(IVerticalRulerInfo rulerInfo, ISourceViewer sourceViewer, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        super(creator);
        Assert.isNotNull((Object)sourceViewer);
        Assert.isNotNull((Object)annotationHover);
        this.fSourceViewer = sourceViewer;
        this.fVerticalRulerInfo = rulerInfo;
        this.fAnnotationHover = annotationHover;
        this.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
        this.setMargins(5, 0);
    }

    protected void computeInformation() {
        MouseEvent event = this.getHoverEvent();
        IAnnotationHover hover = this.getHover(event);
        int line = this.getHoverLine(event);
        if (hover instanceof IAnnotationHoverExtension) {
            IAnnotationHoverExtension extension = (IAnnotationHoverExtension)((Object)hover);
            this.setCustomInformationControlCreator(extension.getInformationControlCreator());
            this.setInformation(extension.getHoverInfo(this.fSourceViewer, line, this.fSourceViewer.getTopIndex(), this.fSourceViewer.getBottomIndex()), this.computeArea(line));
        } else {
            this.setCustomInformationControlCreator(null);
            this.setInformation(hover.getHoverInfo(this.fSourceViewer, line), this.computeArea(line));
        }
    }

    private IAnnotationHover getHover(MouseEvent event) {
        if (event == null || event.getSource() == null) {
            return this.fAnnotationHover;
        }
        if (this.fVerticalRulerInfo instanceof CompositeRuler) {
            CompositeRuler comp = (CompositeRuler)this.fVerticalRulerInfo;
            Iterator it = comp.getDecoratorIterator();
            while (it.hasNext()) {
                IAnnotationHover hover;
                Object o = it.next();
                if (!(o instanceof IVerticalRulerInfoExtension) || !(o instanceof IVerticalRulerInfo) || ((IVerticalRulerInfo)o).getControl() != event.getSource() || (hover = ((IVerticalRulerInfoExtension)o).getHover()) == null) continue;
                return hover;
            }
        }
        return this.fAnnotationHover;
    }

    private int getHoverLine(MouseEvent event) {
        return event == null ? -1 : this.fVerticalRulerInfo.toDocumentLineNumber(event.y);
    }

    private int getWidgetLineNumber(int line) throws BadLocationException {
        if (this.fSourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fSourceViewer);
            return extension.modelLine2WidgetLine(line);
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int firstLine = this.fSourceViewer.getDocument().getLineOfOffset(region.getOffset());
        return line - firstLine;
    }

    private Rectangle computeArea(int line) {
        try {
            StyledText text = this.fSourceViewer.getTextWidget();
            int lineHeight = text.getLineHeight();
            int y = this.getWidgetLineNumber(line) * lineHeight - text.getTopPixel();
            Point size = this.fVerticalRulerInfo.getControl().getSize();
            return new Rectangle(0, y, size.x, lineHeight);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected IAnnotationHover getAnnotationHover() {
        return this.fAnnotationHover;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fVerticalRulerInfo;
    }

    protected Point computeSizeConstraints(Control subjectControl, IInformationControl informationControl) {
        StyledText styledText = this.fSourceViewer.getTextWidget();
        if (styledText == null) {
            return super.computeSizeConstraints(subjectControl, informationControl);
        }
        Rectangle r = styledText.getClientArea();
        if (r == null) {
            return super.computeSizeConstraints(subjectControl, informationControl);
        }
        return new Point(r.width, r.height);
    }

    protected Point computeInformationControlLocation(Rectangle subjectArea, Point controlSize) {
        ITextSelection lineRange;
        MouseEvent event = this.getHoverEvent();
        IAnnotationHover hover = this.getHover(event);
        if (hover instanceof IAnnotationHoverExtension && (lineRange = ((IAnnotationHoverExtension)((Object)hover)).getLineRange(this.fSourceViewer, this.getHoverLine(event), this.fSourceViewer.getTopIndex(), this.fSourceViewer.getBottomIndex())) != null && !lineRange.isEmpty()) {
            return this.computeViewerRange(lineRange);
        }
        return super.computeInformationControlLocation(subjectArea, controlSize);
    }

    private Point computeViewerRange(ITextSelection lineRange) {
        int topLine = this.fSourceViewer.getTopIndex();
        int lineDelta = lineRange.getStartLine() - topLine;
        StyledText textWidget = this.fSourceViewer.getTextWidget();
        int lineHeight = textWidget.getLineHeight();
        int partial = (lineHeight - textWidget.getTopPixel() % lineHeight) % lineHeight;
        int y = lineDelta * lineHeight + partial;
        int x = 1;
        return textWidget.toDisplay(x, y);
    }
}

