/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class Annotation {
    public static final String TYPE_UNKNOWN = "org.eclipse.text.annotation.unknown";
    private int fLayer;
    private String fType;
    private boolean fIsPersistent = false;
    private boolean fMarkedAsDeleted = false;
    private String fText;

    protected static void drawImage(Image image, GC gc, Canvas canvas, Rectangle r, int halign, int valign) {
        if (image != null) {
            Rectangle bounds = image.getBounds();
            int x = 0;
            switch (halign) {
                case 16384: {
                    break;
                }
                case 0x1000000: {
                    x = (r.width - bounds.width) / 2;
                    break;
                }
                case 131072: {
                    x = r.width - bounds.width;
                }
            }
            int y = 0;
            switch (valign) {
                case 128: {
                    FontMetrics fontMetrics = gc.getFontMetrics();
                    y = (fontMetrics.getHeight() - bounds.height) / 2;
                    break;
                }
                case 0x1000000: {
                    y = (r.height - bounds.height) / 2;
                    break;
                }
                case 1024: {
                    FontMetrics fontMetrics = gc.getFontMetrics();
                    y = r.height - (fontMetrics.getHeight() + bounds.height) / 2;
                }
            }
            gc.drawImage(image, r.x + x, r.y + y);
        }
    }

    protected static void drawImage(Image image, GC gc, Canvas canvas, Rectangle r, int align) {
        Annotation.drawImage(image, gc, canvas, r, align, 0x1000000);
    }

    protected Annotation() {
        this(null, false, null);
    }

    public Annotation(String type, boolean isPersistent, String text) {
        this.fType = type;
        this.fIsPersistent = isPersistent;
        this.fText = text;
    }

    public Annotation(boolean isPersistent) {
        this(null, isPersistent, null);
    }

    public boolean isPersistent() {
        return this.fIsPersistent;
    }

    public void setType(String type) {
        this.fType = type;
    }

    public String getType() {
        return this.fType == null ? TYPE_UNKNOWN : this.fType;
    }

    public void markDeleted(boolean deleted) {
        this.fMarkedAsDeleted = deleted;
    }

    public boolean isMarkedDeleted() {
        return this.fMarkedAsDeleted;
    }

    public void setText(String text) {
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    protected void setLayer(int layer) {
        this.fLayer = layer;
    }

    public int getLayer() {
        return this.fLayer;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
    }
}

