/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PatternRule
implements IPredicateRule {
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected char[] fStartSequence;
    protected char[] fEndSequence;
    protected int fColumn = -1;
    protected char fEscapeCharacter;
    protected boolean fBreaksOnEOL;
    protected boolean fBreaksOnEOF;

    public PatternRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL) {
        Assert.isTrue((startSequence != null && startSequence.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((endSequence != null || breaksOnEOL ? 1 : 0) != 0);
        Assert.isNotNull((Object)token);
        this.fStartSequence = startSequence.toCharArray();
        this.fEndSequence = endSequence == null ? new char[]{} : endSequence.toCharArray();
        this.fToken = token;
        this.fEscapeCharacter = escapeCharacter;
        this.fBreaksOnEOL = breaksOnEOL;
    }

    public PatternRule(String startSequence, String endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL);
        this.fBreaksOnEOF = breaksOnEOF;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        return this.doEvaluate(scanner, false);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : (c = scanner.read()) == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true)) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], true)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (c == this.fStartSequence[0]) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }
}

