/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;

public abstract class ContextBasedFormattingStrategy
implements IFormattingStrategy,
IFormattingStrategyExtension {
    private Map fCurrentPreference = null;
    private final LinkedList fPreferences = new LinkedList();
    private final ISourceViewer fViewer;

    public ContextBasedFormattingStrategy(ISourceViewer viewer) {
        this.fViewer = viewer;
    }

    public void format() {
        Assert.isLegal((this.fPreferences.size() > 0 ? 1 : 0) != 0);
        this.fCurrentPreference = (Map)this.fPreferences.removeFirst();
    }

    public String format(String content, boolean isLineStart, String indent, int[] positions) {
        return null;
    }

    public void formatterStarts(IFormattingContext context) {
        FormattingContext current = (FormattingContext)context;
        this.fPreferences.addLast(current.getProperty("formatting.context.preferences"));
    }

    public void formatterStarts(String initialIndentation) {
    }

    public void formatterStops() {
        this.fPreferences.clear();
        this.fCurrentPreference = null;
    }

    public final Map getPreferences() {
        return this.fCurrentPreference;
    }

    public final ISourceViewer getViewer() {
        return this.fViewer;
    }
}

