/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IContentFormatterExtension2;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingStrategyExtension;

public class ContentFormatter2
implements IContentFormatter,
IContentFormatterExtension,
IContentFormatterExtension2 {
    private static final String PARTITIONING = "__formatter_partitioning";
    private Map fStrategies;
    private IFormattingStrategy fMasterStrategy;
    private boolean fIsPartitionAware = true;
    private String[] fPartitionManagingCategories;
    private List fOverlappingPositionReferences;
    private String fPartitioning = "__dftl_partitioning";
    private IDocument fDocument;
    private String[] fExternalPartitonManagingCategories;
    private boolean fNeedsComputation = true;
    private IFormattingContext fFormattingContext = null;
    private final LinkedList fPositions = new LinkedList();

    public void setPartitionManagingPositionCategories(String[] categories) {
        this.fExternalPartitonManagingCategories = categories;
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void enablePartitionAwareFormatting(boolean enable) {
        this.fIsPartitionAware = enable;
    }

    public IFormattingStrategy getFormattingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            return null;
        }
        return (IFormattingStrategy)this.fStrategies.get(contentType);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void format(IDocument document, IRegion region) {
        this.fNeedsComputation = true;
        this.fFormattingContext = null;
        IDocument last = this.fDocument;
        this.fDocument = document;
        boolean aware = this.fIsPartitionAware;
        try {
            int offset = region.getOffset();
            int length = region.getLength();
            if (this.fIsPartitionAware) {
                this.formatPartitions(offset, length);
            } else {
                this.formatRegion(offset, length, "__dftl_partition_content_type");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fNeedsComputation = true;
            this.fFormattingContext = null;
            this.fDocument = last;
            this.fIsPartitionAware = aware;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.fNeedsComputation = true;
            this.fFormattingContext = null;
            this.fDocument = last;
            this.fIsPartitionAware = aware;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void format(IDocument document, IFormattingContext context) {
        this.fNeedsComputation = true;
        IDocument last = this.fDocument;
        this.fDocument = document;
        LinkedList previous = new LinkedList(this.fPositions);
        this.fPositions.clear();
        IFormattingContext predecessor = this.fFormattingContext;
        this.fFormattingContext = context;
        boolean aware = this.fIsPartitionAware;
        try {
            block16: {
                try {
                    Boolean all = (Boolean)context.getProperty("formatting.context.document");
                    if (all == null || !all.booleanValue()) {
                        TypedPosition partition = (TypedPosition)context.getProperty("formatting.context.partition");
                        IRegion region = (IRegion)context.getProperty("formatting.context.region");
                        if (partition != null) {
                            this.formatRegion(partition.getOffset(), partition.getLength(), partition.getType());
                            break block16;
                        }
                        if (region == null) break block16;
                        int offset = region.getOffset();
                        int length = region.getLength();
                        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)this.fPartitioning, (int)offset, (int)length);
                        ITypedRegion start = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)regions[0].getOffset());
                        String type = start.getType();
                        if (regions.length > 1) {
                            if (!type.equals("__dftl_partition_content_type")) {
                                int delta = offset - start.getOffset();
                                offset -= delta;
                                length += delta;
                            }
                            int rest = this.fDocument.getLength() - length;
                            try {
                                this.formatMaster(offset, length);
                                Object var16_21 = null;
                                this.formatPartitions(offset, this.fDocument.getLength() - rest);
                                break block16;
                            }
                            catch (Throwable throwable) {
                                Object var16_20 = null;
                                this.formatPartitions(offset, this.fDocument.getLength() - rest);
                                throw throwable;
                            }
                        }
                        if (regions.length == 1) {
                            this.formatRegion(offset, length, type);
                        }
                        break block16;
                    }
                    try {
                        this.formatMaster(0, this.fDocument.getLength());
                        Object var8_10 = null;
                        this.formatPartitions(0, this.fDocument.getLength());
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.formatPartitions(0, this.fDocument.getLength());
                        throw throwable;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            Object var18_24 = null;
            this.fNeedsComputation = true;
            this.fFormattingContext = predecessor;
            this.fDocument = last;
            this.fIsPartitionAware = aware;
            this.fPositions.clear();
            this.fPositions.addAll(previous);
            return;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            this.fNeedsComputation = true;
            this.fFormattingContext = predecessor;
            this.fDocument = last;
            this.fIsPartitionAware = aware;
            this.fPositions.clear();
            this.fPositions.addAll(previous);
            throw throwable;
        }
    }

    public void setFormattingStrategy(IFormattingStrategy strategy, String type) {
        Assert.isNotNull((Object)type);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap();
        }
        if (strategy == null) {
            this.fStrategies.remove(type);
        } else {
            this.fStrategies.put(type, strategy);
        }
    }

    public void setFormattingStrategy(IFormattingStrategy strategy) {
        this.fMasterStrategy = strategy;
    }

    private IRegion alignBlockSelect(int offset, int length) {
        try {
            int aligned = this.fDocument.getLineOffset(this.fDocument.getLineOfOffset(offset));
            return new Region(aligned, length + offset - aligned);
        }
        catch (BadLocationException badLocationException) {
            return new Region(offset, length);
        }
    }

    private void formatPartitions(int offset, int length) {
        try {
            TypedPosition[] ranges = this.getPartitioning(offset, length);
            if (ranges != null) {
                this.start(ranges, this.getIndentation(offset));
                this.format(ranges);
                this.stop(ranges);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void formatRegion(int offset, int length, String type) {
        Object range = null;
        range = type.equals("__dftl_partition_content_type") ? this.alignBlockSelect(offset, length) : new Region(offset, length);
        IFormattingStrategy strategy = this.getFormattingStrategy(type);
        if (strategy != null) {
            TypedPosition region = new TypedPosition(range.getOffset(), range.getLength(), type);
            this.formatterStarts(strategy, region, this.getIndentation(region.getOffset()));
            this.format(strategy, region);
            strategy.formatterStops();
        }
    }

    private void formatMaster(int offset, int length) {
        if (this.fMasterStrategy != null) {
            IRegion aligned = this.alignBlockSelect(offset, length);
            TypedPosition region = new TypedPosition(aligned.getOffset(), aligned.getLength(), "__dftl_partition_content_type");
            this.formatterStarts(this.fMasterStrategy, region, this.getIndentation(region.getOffset()));
            this.format(this.fMasterStrategy, region);
            this.fMasterStrategy.formatterStops();
        }
    }

    private void formatterStarts(IFormattingStrategy strategy, TypedPosition region, String indentation) {
        if (this.fFormattingContext != null && strategy instanceof IFormattingStrategyExtension) {
            IFormattingStrategyExtension extension = (IFormattingStrategyExtension)((Object)strategy);
            int[] positions = this.getAffectedPositions(region.getOffset(), region.getLength());
            this.fPositions.addLast(positions);
            this.fFormattingContext.setProperty("formatting.context.indentation", indentation);
            this.fFormattingContext.setProperty("formatting.context.partition", region);
            this.fFormattingContext.setProperty("formatting.context.positions", positions);
            extension.formatterStarts(this.fFormattingContext);
        } else {
            strategy.formatterStarts(indentation);
        }
    }

    private TypedPosition[] getPartitioning(int offset, int length) throws BadLocationException {
        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)this.fPartitioning, (int)offset, (int)length);
        TypedPosition[] positions = new TypedPosition[regions.length];
        int i = 0;
        while (i < regions.length) {
            positions[i] = new TypedPosition(regions[i]);
            ++i;
        }
        return positions;
    }

    private void start(TypedPosition[] partitions, String indentation) {
        String type = null;
        TypedPosition region = null;
        int i = partitions.length - 1;
        while (i >= 0) {
            IFormattingStrategy strategy;
            region = partitions[i];
            type = region.getType();
            if (!type.equals("__dftl_partition_content_type") && (strategy = this.getFormattingStrategy(type)) != null && strategy != this.fMasterStrategy) {
                this.formatterStarts(strategy, region, indentation);
            }
            --i;
        }
    }

    private void format(TypedPosition[] partitions) {
        String type = null;
        TypedPosition region = null;
        int i = partitions.length - 1;
        while (i >= 0) {
            IFormattingStrategy strategy;
            region = partitions[i];
            type = region.getType();
            if (!type.equals("__dftl_partition_content_type") && (strategy = this.getFormattingStrategy(type)) != null && strategy != this.fMasterStrategy) {
                if (this.fFormattingContext != null && strategy instanceof IFormattingStrategyExtension) {
                    IFormattingStrategyExtension extension = (IFormattingStrategyExtension)((Object)strategy);
                    extension.format();
                } else {
                    this.format(strategy, region);
                }
            }
            --i;
        }
    }

    private void format(IFormattingStrategy strategy, TypedPosition region) {
        if (this.fFormattingContext != null && strategy instanceof IFormattingStrategyExtension) {
            int[] positions = (int[])this.fFormattingContext.getProperty("formatting.context.positions");
            RemoveAffectedPositions first = new RemoveAffectedPositions();
            this.fDocument.insertPositionUpdater((IPositionUpdater)first, 0);
            UpdateAffectedPositions last = new UpdateAffectedPositions(positions, region.getOffset());
            this.fDocument.addPositionUpdater((IPositionUpdater)last);
            IFormattingStrategyExtension extension = (IFormattingStrategyExtension)((Object)strategy);
            extension.format();
            this.fDocument.removePositionUpdater((IPositionUpdater)first);
            this.fDocument.removePositionUpdater((IPositionUpdater)last);
        } else {
            try {
                int offset = region.getOffset();
                int length = region.getLength();
                String content = this.fDocument.get(offset, length);
                int[] positions = this.getAffectedPositions(offset, length);
                String formatted = strategy.format(content, this.isLineStart(offset), this.getIndentation(offset), positions);
                if (formatted != null && !formatted.equals(content)) {
                    RemoveAffectedPositions first = new RemoveAffectedPositions();
                    this.fDocument.insertPositionUpdater((IPositionUpdater)first, 0);
                    UpdateAffectedPositions last = new UpdateAffectedPositions(positions, offset);
                    this.fDocument.addPositionUpdater((IPositionUpdater)last);
                    this.fDocument.replace(offset, length, formatted);
                    this.fDocument.removePositionUpdater((IPositionUpdater)first);
                    this.fDocument.removePositionUpdater((IPositionUpdater)last);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void stop(TypedPosition[] partitions) {
        String type = null;
        int i = partitions.length - 1;
        while (i >= 0) {
            IFormattingStrategy strategy;
            type = partitions[i].getType();
            if (!type.equals("__dftl_partition_content_type") && (strategy = this.getFormattingStrategy(type)) != null && strategy != this.fMasterStrategy) {
                strategy.formatterStops();
            }
            --i;
        }
    }

    private String[] getPartitionManagingCategories() {
        if (this.fNeedsComputation) {
            this.fNeedsComputation = false;
            this.fPartitionManagingCategories = TextUtilities.computePartitionManagingCategories((IDocument)this.fDocument);
            if (this.fPartitionManagingCategories == null) {
                this.fPartitionManagingCategories = this.fExternalPartitonManagingCategories;
            }
        }
        return this.fPartitionManagingCategories;
    }

    private boolean ignoreCategory(String category) {
        if (PARTITIONING.equals(category)) {
            return true;
        }
        String[] categories = this.getPartitionManagingCategories();
        if (categories != null) {
            int i = 0;
            while (i < categories.length) {
                if (categories[i].equals(category)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void determinePositionsToUpdate(int offset, int length) {
        String[] categories = this.fDocument.getPositionCategories();
        if (categories != null) {
            int i = 0;
            while (i < categories.length) {
                if (!this.ignoreCategory(categories[i])) {
                    try {
                        Position[] positions = this.fDocument.getPositions(categories[i]);
                        int j = 0;
                        while (j < positions.length) {
                            Position p = positions[j];
                            if (p.overlapsWith(offset, length)) {
                                if (offset < p.getOffset()) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(p, true, categories[i]));
                                }
                                if (p.getOffset() + p.getLength() < offset + length) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(p, false, categories[i]));
                                }
                            }
                            ++j;
                        }
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
                ++i;
            }
        }
    }

    private int[] getAffectedPositions(int offset, int length) {
        this.fOverlappingPositionReferences = new ArrayList();
        this.determinePositionsToUpdate(offset, length);
        Collections.sort(this.fOverlappingPositionReferences);
        int[] positions = new int[this.fOverlappingPositionReferences.size()];
        int i = 0;
        while (i < positions.length) {
            PositionReference r = (PositionReference)this.fOverlappingPositionReferences.get(i);
            positions[i] = r.getCharacterPosition() - offset;
            ++i;
        }
        return positions;
    }

    private void removeAffectedPositions(IDocument document) {
        if (this.fOverlappingPositionReferences != null) {
            int size = this.fOverlappingPositionReferences.size();
            int i = 0;
            while (i < size) {
                PositionReference r = (PositionReference)this.fOverlappingPositionReferences.get(i);
                try {
                    document.removePosition(r.getCategory(), r.getPosition());
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                ++i;
            }
        }
    }

    protected void updateAffectedPositions(IDocument document, int[] positions, int offset) {
        if (document != this.fDocument) {
            return;
        }
        if (this.fOverlappingPositionReferences == null || this.fOverlappingPositionReferences.size() == 0 || positions.length == 0) {
            return;
        }
        int i = 0;
        while (i < positions.length) {
            PositionReference r = (PositionReference)this.fOverlappingPositionReferences.get(i);
            if (r.refersToOffset()) {
                int posOffset = offset + positions[i];
                if (posOffset >= 0) {
                    r.setOffset(posOffset);
                }
            } else {
                int length = offset + positions[i] - r.getOffset();
                if (length >= 0) {
                    r.setLength(length);
                }
            }
            Position p = r.getPosition();
            String category = r.getCategory();
            if (!document.containsPosition(category, p.offset, p.length)) {
                try {
                    if (this.positionAboutToBeAdded(document, category, p)) {
                        document.addPosition(r.getCategory(), p);
                    }
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {}
            }
            ++i;
        }
        this.fOverlappingPositionReferences = null;
    }

    protected boolean positionAboutToBeAdded(IDocument document, String category, Position position) {
        if ("__childdocuments".equals(category)) {
            try {
                int lineOffset = document.getLineInformationOfOffset(position.offset).getOffset();
                position.setLength(position.length + position.offset - lineOffset);
                position.setOffset(lineOffset);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return true;
    }

    private String getIndentation(int offset) {
        try {
            int start = this.fDocument.getLineOfOffset(offset);
            int end = start = this.fDocument.getLineOffset(start);
            char c = this.fDocument.getChar(end);
            while ('\t' == c || ' ' == c) {
                c = this.fDocument.getChar(++end);
            }
            return this.fDocument.get(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private boolean isLineStart(int offset) throws BadLocationException {
        int start = this.fDocument.getLineOfOffset(offset);
        return (start = this.fDocument.getLineOffset(start)) == offset;
    }

    static class PositionReference
    implements Comparable {
        protected Position fPosition;
        protected boolean fRefersToOffset;
        protected String fCategory;

        protected PositionReference(Position position, boolean refersToOffset, String category) {
            this.fPosition = position;
            this.fRefersToOffset = refersToOffset;
            this.fCategory = category;
        }

        protected int getOffset() {
            return this.fPosition.getOffset();
        }

        protected void setOffset(int offset) {
            this.fPosition.setOffset(offset);
        }

        protected int getLength() {
            return this.fPosition.getLength();
        }

        protected void setLength(int length) {
            this.fPosition.setLength(length);
        }

        protected boolean refersToOffset() {
            return this.fRefersToOffset;
        }

        protected String getCategory() {
            return this.fCategory;
        }

        protected Position getPosition() {
            return this.fPosition;
        }

        protected int getCharacterPosition() {
            if (this.fRefersToOffset) {
                return this.getOffset();
            }
            return this.getOffset() + this.getLength();
        }

        public int compareTo(Object obj) {
            if (obj instanceof PositionReference) {
                PositionReference r = (PositionReference)obj;
                return this.getCharacterPosition() - r.getCharacterPosition();
            }
            throw new ClassCastException();
        }
    }

    class NonDeletingPositionUpdater
    extends DefaultPositionUpdater {
        protected NonDeletingPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }
    }

    class RemoveAffectedPositions
    implements IPositionUpdater {
        RemoveAffectedPositions() {
        }

        public void update(DocumentEvent event) {
            ContentFormatter2.this.removeAffectedPositions(event.getDocument());
        }
    }

    class UpdateAffectedPositions
    implements IPositionUpdater {
        private int[] fPositions;
        private int fOffset;

        public UpdateAffectedPositions(int[] positions, int offset) {
            this.fPositions = positions;
            this.fOffset = offset;
        }

        public void update(DocumentEvent event) {
            ContentFormatter2.this.updateAffectedPositions(event.getDocument(), this.fPositions, this.fOffset);
        }
    }
}

