/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessorExtension;
import org.eclipse.jface.text.contentassist.IContentAssistSubject;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.contentassist.IContextInformationValidatorExtension;

public final class ContextInformationValidator
implements IContextInformationValidator,
IContextInformationValidatorExtension {
    private IContentAssistProcessor fProcessor;
    private IContextInformation fContextInformation;
    private ITextViewer fViewer;
    private IContentAssistSubject fContentAssistSubject;

    public ContextInformationValidator(IContentAssistProcessor processor) {
        this.fProcessor = processor;
    }

    public void install(IContextInformation contextInformation, ITextViewer viewer, int position) {
        this.fContextInformation = contextInformation;
        this.fViewer = viewer;
    }

    public void install(IContextInformation contextInformation, IContentAssistSubject contentAssistSubject, int position) {
        this.fContextInformation = contextInformation;
        this.fContentAssistSubject = contentAssistSubject;
    }

    public boolean isContextInformationValid(int position) {
        IContextInformation[] infos = null;
        if (this.fContentAssistSubject != null) {
            if (this.fProcessor instanceof IContentAssistProcessorExtension) {
                infos = ((IContentAssistProcessorExtension)((Object)this.fProcessor)).computeContextInformation(this.fContentAssistSubject, position);
            }
        } else {
            infos = this.fProcessor.computeContextInformation(this.fViewer, position);
        }
        if (infos != null && infos.length > 0) {
            int i = 0;
            while (i < infos.length) {
                if (this.fContextInformation.equals(infos[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

