/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.CompletionProposalPopup;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformationPopup;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.IContentAssistSubject;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationPresenterExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.contentassist.IContextInformationValidatorExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class ContentAssistSubjectAdapter
implements IContentAssistSubject {
    private ITextViewer fViewer;
    private IContentAssistSubject fContentAssistSubject;

    public ContentAssistSubjectAdapter(IContentAssistSubject contentAssistSubject) {
        Assert.isNotNull((Object)contentAssistSubject);
        this.fContentAssistSubject = contentAssistSubject;
    }

    public ContentAssistSubjectAdapter(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }

    public int getLineHeight() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getLineHeight();
        }
        return this.fViewer.getTextWidget().getLineHeight();
    }

    public Control getControl() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getControl();
        }
        return this.fViewer.getTextWidget();
    }

    public Point getLocationAtOffset(int offset) {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getLocationAtOffset(offset);
        }
        return this.fViewer.getTextWidget().getLocationAtOffset(offset);
    }

    public Point getWidgetSelectionRange() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getWidgetSelectionRange();
        }
        return this.fViewer.getTextWidget().getSelectionRange();
    }

    public Point getSelectedRange() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getSelectedRange();
        }
        return this.fViewer.getSelectedRange();
    }

    public int getCaretOffset() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getCaretOffset();
        }
        return this.fViewer.getTextWidget().getCaretOffset();
    }

    public String getLineDelimiter() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getLineDelimiter();
        }
        return this.fViewer.getTextWidget().getLineDelimiter();
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.addKeyListener(keyListener);
        } else {
            this.fViewer.getTextWidget().addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.removeKeyListener(keyListener);
        } else {
            this.fViewer.getTextWidget().removeKeyListener(keyListener);
        }
    }

    public IDocument getDocument() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.getDocument();
        }
        return this.fViewer.getDocument();
    }

    public boolean prependVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.prependVerifyKeyListener(verifyKeyListener);
        }
        if (this.fViewer instanceof ITextViewerExtension) {
            ITextViewerExtension e = (ITextViewerExtension)((Object)this.fViewer);
            e.prependVerifyKeyListener(verifyKeyListener);
            return true;
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        if (Helper.okToUse((Widget)textWidget)) {
            textWidget.addVerifyKeyListener(verifyKeyListener);
            return true;
        }
        return false;
    }

    public boolean appendVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.appendVerifyKeyListener(verifyKeyListener);
        }
        if (this.fViewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)((Object)this.fViewer);
            extension.appendVerifyKeyListener(verifyKeyListener);
            return true;
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        if (Helper.okToUse((Widget)textWidget)) {
            textWidget.addVerifyKeyListener(verifyKeyListener);
            return true;
        }
        return false;
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.removeVerifyKeyListener(verifyKeyListener);
        } else if (this.fViewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)((Object)this.fViewer);
            extension.removeVerifyKeyListener(verifyKeyListener);
        } else {
            StyledText textWidget = this.fViewer.getTextWidget();
            if (Helper.okToUse((Widget)textWidget)) {
                textWidget.removeVerifyKeyListener(verifyKeyListener);
            }
        }
    }

    public void setEventConsumer(IEventConsumer eventConsumer) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.setEventConsumer(eventConsumer);
        } else {
            this.fViewer.setEventConsumer(eventConsumer);
        }
    }

    public void setSelectedRange(int i, int j) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.setSelectedRange(i, j);
        } else {
            this.fViewer.setSelectedRange(i, j);
        }
    }

    public void revealRange(int i, int j) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.revealRange(i, j);
        } else {
            this.fViewer.revealRange(i, j);
        }
    }

    public boolean supportsVerifyKeyListener() {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.supportsVerifyKeyListener();
        }
        return true;
    }

    public char[] getCompletionProposalAutoActivationCharacters(ContentAssistant contentAssistant, int offset) {
        if (this.fContentAssistSubject != null) {
            return contentAssistant.getCompletionProposalAutoActivationCharacters(this.fContentAssistSubject, offset);
        }
        return contentAssistant.getCompletionProposalAutoActivationCharacters(this.fViewer, offset);
    }

    char[] getContextInformationAutoActivationCharacters(ContentAssistant contentAssistant, int offset) {
        if (this.fContentAssistSubject != null) {
            return contentAssistant.getContextInformationAutoActivationCharacters(this.fContentAssistSubject, offset);
        }
        return contentAssistant.getContextInformationAutoActivationCharacters(this.fViewer, offset);
    }

    CompletionProposalPopup createCompletionProposalPopup(ContentAssistant contentAssistant, AdditionalInfoController controller) {
        if (this.fContentAssistSubject != null) {
            return new CompletionProposalPopup(contentAssistant, this.fContentAssistSubject, controller);
        }
        return new CompletionProposalPopup(contentAssistant, this.fViewer, controller);
    }

    ContextInformationPopup createContextInfoPopup(ContentAssistant contentAssistant) {
        if (this.fContentAssistSubject != null) {
            return new ContextInformationPopup(contentAssistant, this.fContentAssistSubject);
        }
        return new ContextInformationPopup(contentAssistant, this.fViewer);
    }

    public IContextInformationValidator getContextInformationValidator(ContentAssistant contentAssistant, int offset) {
        if (this.fContentAssistSubject != null) {
            return contentAssistant.getContextInformationValidator(this.fContentAssistSubject, offset);
        }
        return contentAssistant.getContextInformationValidator(this.fViewer, offset);
    }

    public IContextInformationPresenter getContextInformationPresenter(ContentAssistant contentAssistant, int offset) {
        if (this.fContentAssistSubject != null) {
            return contentAssistant.getContextInformationPresenter(this.fContentAssistSubject, offset);
        }
        return contentAssistant.getContextInformationPresenter(this.fViewer, offset);
    }

    public void installValidator(ContextInformationPopup.ContextFrame frame) {
        if (this.fContentAssistSubject != null) {
            if (frame.fValidator instanceof IContextInformationValidatorExtension) {
                ((IContextInformationValidatorExtension)((Object)frame.fValidator)).install(frame.fInformation, this.fContentAssistSubject, frame.fOffset);
            }
        } else {
            frame.fValidator.install(frame.fInformation, this.fViewer, frame.fOffset);
        }
    }

    public void installContextInformationPresenter(ContextInformationPopup.ContextFrame frame) {
        if (this.fContentAssistSubject != null) {
            if (frame.fPresenter instanceof IContextInformationPresenterExtension) {
                ((IContextInformationPresenterExtension)((Object)frame.fValidator)).install(frame.fInformation, this.fContentAssistSubject, frame.fBeginOffset);
            }
        } else {
            frame.fPresenter.install(frame.fInformation, this.fViewer, frame.fBeginOffset);
        }
    }

    public IContextInformation[] computeContextInformation(ContentAssistant contentAssistant, int position) {
        if (this.fContentAssistSubject != null) {
            return contentAssistant.computeContextInformation(this.fContentAssistSubject, position);
        }
        return contentAssistant.computeContextInformation(this.fViewer, position);
    }

    public boolean addSelectionListener(SelectionListener selectionListener) {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistSubject.addSelectionListener(selectionListener);
        }
        this.fViewer.getTextWidget().addSelectionListener(selectionListener);
        return true;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.fContentAssistSubject != null) {
            this.fContentAssistSubject.removeSelectionListener(selectionListener);
        } else {
            this.fViewer.getTextWidget().removeSelectionListener(selectionListener);
        }
    }
}

