/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.ContentAssistSubjectAdapter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContentAssistListener;
import org.eclipse.jface.text.contentassist.IContentAssistSubject;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.PopupCloser;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class CompletionProposalPopup
implements IContentAssistListener {
    private ITextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private AdditionalInfoController fAdditionalInfoController;
    private PopupCloser fPopupCloser = new PopupCloser();
    private Shell fProposalShell;
    private Table fProposalTable;
    private boolean fInserting = false;
    private KeyListener fKeyListener;
    private List fDocumentEvents = new ArrayList();
    private IDocumentListener fDocumentListener;
    private long fInvocationCounter = 0L;
    private ICompletionProposal[] fFilteredProposals;
    private ICompletionProposal[] fComputedProposals;
    private int fInvocationOffset;
    private int fFilterOffset;
    private String fLineDelimiter;
    private ICompletionProposal fLastProposal;
    private IContentAssistSubject fContentAssistSubject;
    private ContentAssistSubjectAdapter fContentAssistSubjectAdapter;

    public CompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer viewer, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = viewer;
        this.fAdditionalInfoController = infoController;
        this.fContentAssistSubjectAdapter = new ContentAssistSubjectAdapter(this.fViewer);
    }

    public CompletionProposalPopup(ContentAssistant contentAssistant, IContentAssistSubject contentAssistSubject, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubject = contentAssistSubject;
        this.fAdditionalInfoController = infoController;
        this.fContentAssistSubjectAdapter = new ContentAssistSubjectAdapter(this.fContentAssistSubject);
    }

    public String showProposals(final boolean autoActivated) {
        Control control;
        if (this.fKeyListener == null) {
            this.fKeyListener = new MyKeyListener();
        }
        if ((control = this.fContentAssistSubjectAdapter.getControl()) != null && !control.isDisposed()) {
            this.fContentAssistSubjectAdapter.addKeyListener(this.fKeyListener);
        }
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                int count;
                CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectAdapter.getSelectedRange().x;
                CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                int n = count = CompletionProposalPopup.this.fComputedProposals == null ? 0 : CompletionProposalPopup.this.fComputedProposals.length;
                if (count == 0) {
                    if (!autoActivated) {
                        control.getDisplay().beep();
                    }
                } else if (count == 1 && !autoActivated && CompletionProposalPopup.this.fContentAssistant.isAutoInserting()) {
                    CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fComputedProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                } else {
                    if (CompletionProposalPopup.this.fLineDelimiter == null) {
                        CompletionProposalPopup.this.fLineDelimiter = CompletionProposalPopup.this.fContentAssistSubjectAdapter.getLineDelimiter();
                    }
                    CompletionProposalPopup.this.createProposalSelector();
                    CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals);
                    CompletionProposalPopup.this.displayProposals();
                }
            }
        });
        return this.getErrorMessage();
    }

    private ICompletionProposal[] computeProposals(int offset) {
        if (this.fContentAssistSubject != null) {
            return this.fContentAssistant.computeCompletionProposals(this.fContentAssistSubject, offset);
        }
        return this.fContentAssistant.computeCompletionProposals(this.fViewer, offset);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createProposalSelector() {
        Color c;
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return;
        }
        Control control = this.fContentAssistSubjectAdapter.getControl();
        this.fProposalShell = new Shell(control.getShell(), 16400);
        this.fProposalTable = new Table((Composite)this.fProposalShell, 768);
        this.fProposalTable.setLocation(0, 0);
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fProposalShell.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = this.fProposalTable.getItemHeight() * 10;
        data.widthHint = 300;
        this.fProposalTable.setLayoutData((Object)data);
        this.fProposalShell.pack();
        if (this.fAdditionalInfoController != null) {
            this.fProposalShell.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    CompletionProposalPopup.this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
                }
            });
        }
        if (!"carbon".equals(SWT.getPlatform())) {
            this.fProposalShell.setBackground(control.getDisplay().getSystemColor(2));
        }
        if ((c = this.fContentAssistant.getProposalSelectorBackground()) == null) {
            c = control.getDisplay().getSystemColor(29);
        }
        this.fProposalTable.setBackground(c);
        c = this.fContentAssistant.getProposalSelectorForeground();
        if (c == null) {
            c = control.getDisplay().getSystemColor(28);
        }
        this.fProposalTable.setForeground(c);
        this.fProposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompletionProposalPopup.this.selectProposalWithMask(e.stateMask);
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fProposalTable);
        this.fProposalShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompletionProposalPopup.this.unregister();
            }
        });
        this.fProposalTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fProposalShell, 0, this.fContentAssistant.getSelectionOffset());
    }

    private ICompletionProposal getSelectedProposal() {
        int i = this.fProposalTable.getSelectionIndex();
        if (i < 0 || i >= this.fFilteredProposals.length) {
            return null;
        }
        return this.fFilteredProposals[i];
    }

    private void selectProposalWithMask(int stateMask) {
        ICompletionProposal p = this.getSelectedProposal();
        this.hide();
        if (p != null) {
            this.insertProposal(p, '\u0000', stateMask, this.fContentAssistSubjectAdapter.getSelectedRange().x);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertProposal(ICompletionProposal p, char trigger, int stateMask, int offset) {
        this.fInserting = true;
        IRewriteTarget target = null;
        try {
            IContextInformation info;
            Object e;
            IDocument document = this.fContentAssistSubjectAdapter.getDocument();
            if (this.fViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)((Object)this.fViewer);
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (p instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                e = (ICompletionProposalExtension2)((Object)p);
                e.apply(this.fViewer, trigger, stateMask, offset);
            } else if (p instanceof ICompletionProposalExtension) {
                e = (ICompletionProposalExtension)((Object)p);
                e.apply(document, trigger, offset);
            } else {
                p.apply(document);
            }
            Point selection = p.getSelection(document);
            if (selection != null) {
                this.fContentAssistSubjectAdapter.setSelectedRange(selection.x, selection.y);
                this.fContentAssistSubjectAdapter.revealRange(selection.x, selection.y);
            }
            if ((info = p.getContextInformation()) != null) {
                int position;
                if (p instanceof ICompletionProposalExtension) {
                    ICompletionProposalExtension e2 = (ICompletionProposalExtension)((Object)p);
                    position = e2.getContextInformationPosition();
                } else {
                    if (selection == null) {
                        selection = this.fContentAssistSubjectAdapter.getSelectedRange();
                    }
                    position = selection.x + selection.y;
                }
                this.fContentAssistant.showContextInformation(info, position);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (target != null) {
                target.endCompoundChange();
            }
            this.fInserting = false;
            throw throwable;
        }
        {
            Object var11_13 = null;
            if (target != null) {
                target.endCompoundChange();
            }
            this.fInserting = false;
            return;
        }
    }

    public boolean hasFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return this.fProposalShell.isFocusControl() || this.fProposalTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        this.unregister();
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 1);
            this.fPopupCloser.uninstall();
            this.fProposalShell.setVisible(false);
            this.fProposalShell.dispose();
            this.fProposalShell = null;
        }
    }

    private void unregister() {
        if (this.fDocumentListener != null) {
            IDocument document = this.fContentAssistSubjectAdapter.getDocument();
            if (document != null) {
                document.removeDocumentListener(this.fDocumentListener);
            }
            this.fDocumentListener = null;
        }
        this.fDocumentEvents.clear();
        if (this.fKeyListener != null && this.fContentAssistSubjectAdapter.getControl() != null && !this.fContentAssistSubjectAdapter.getControl().isDisposed()) {
            this.fContentAssistSubjectAdapter.removeKeyListener(this.fKeyListener);
        }
        if (this.fLastProposal != null) {
            if (this.fLastProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ICompletionProposalExtension2 extension = (ICompletionProposalExtension2)((Object)this.fLastProposal);
                extension.unselected(this.fViewer);
            }
            this.fLastProposal = null;
        }
        this.fFilteredProposals = null;
        this.fComputedProposals = null;
        this.fContentAssistant.possibleCompletionsClosed();
    }

    public boolean isActive() {
        return this.fProposalShell != null && !this.fProposalShell.isDisposed();
    }

    private void setProposals(ICompletionProposal[] proposals) {
        if (Helper.okToUse((Widget)this.fProposalTable)) {
            ICompletionProposal oldProposal = this.getSelectedProposal();
            if (oldProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ((ICompletionProposalExtension2)((Object)oldProposal)).unselected(this.fViewer);
            }
            this.fFilteredProposals = proposals;
            this.fProposalTable.setRedraw(false);
            this.fProposalTable.removeAll();
            int i = 0;
            while (i < proposals.length) {
                ICompletionProposal p = proposals[i];
                TableItem item = new TableItem(this.fProposalTable, 0);
                if (p.getImage() != null) {
                    item.setImage(p.getImage());
                }
                item.setText(p.getDisplayString());
                item.setData((Object)p);
                ++i;
            }
            Point currentLocation = this.fProposalShell.getLocation();
            Point newLocation = this.getLocation();
            if (newLocation.x < currentLocation.x && newLocation.y == currentLocation.y || newLocation.y < currentLocation.y) {
                this.fProposalShell.setLocation(newLocation);
            }
            this.selectProposal(0, false);
            this.fProposalTable.setRedraw(true);
        }
    }

    private Point getLocation() {
        int caret = this.fContentAssistSubjectAdapter.getCaretOffset();
        Point p = this.fContentAssistSubjectAdapter.getLocationAtOffset(caret);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        p = new Point(p.x, p.y + this.fContentAssistSubjectAdapter.getLineHeight());
        p = this.fContentAssistSubjectAdapter.getControl().toDisplay(p);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        return p;
    }

    private void displayProposals() {
        if (!Helper.okToUse((Widget)this.fProposalShell) || !Helper.okToUse((Widget)this.fProposalTable)) {
            return;
        }
        if (this.fContentAssistant.addContentAssistListener(this, 1)) {
            IDocument document;
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent event) {
                        if (!CompletionProposalPopup.this.fInserting) {
                            CompletionProposalPopup.this.fDocumentEvents.add(event);
                        }
                    }

                    public void documentChanged(DocumentEvent event) {
                        if (!CompletionProposalPopup.this.fInserting) {
                            CompletionProposalPopup.this.filterProposals();
                        }
                    }
                };
            }
            if ((document = this.fContentAssistSubjectAdapter.getDocument()) != null) {
                document.addDocumentListener(this.fDocumentListener);
            }
            this.fProposalShell.setVisible(true);
            if (!this.fContentAssistSubjectAdapter.supportsVerifyKeyListener()) {
                this.fProposalShell.setFocus();
            }
            if (this.fAdditionalInfoController != null) {
                this.fAdditionalInfoController.install((Control)this.fProposalTable);
                this.fAdditionalInfoController.handleTableSelectionChanged();
            }
        }
    }

    public boolean verifyKey(VerifyEvent e) {
        if (!Helper.okToUse((Widget)this.fProposalShell)) {
            return true;
        }
        char key = e.character;
        if (key == '\u0000') {
            int newSelection = this.fProposalTable.getSelectionIndex();
            int visibleRows = this.fProposalTable.getSize().y / this.fProposalTable.getItemHeight() - 1;
            boolean smartToggle = false;
            switch (e.keyCode) {
                case 0x1000003: 
                case 0x1000004: {
                    this.filterProposals();
                    return true;
                }
                case 0x1000001: {
                    if (--newSelection >= 0) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000002: {
                    if (++newSelection <= this.fProposalTable.getItemCount() - 1) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000006: {
                    if ((newSelection += visibleRows) < this.fProposalTable.getItemCount()) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000005: {
                    if ((newSelection -= visibleRows) >= 0) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000007: {
                    newSelection = 0;
                    break;
                }
                case 0x1000008: {
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                default: {
                    if (e.keyCode != SWT.MOD1 && e.keyCode != SWT.MOD2 && e.keyCode != SWT.MOD3 && e.keyCode != SWT.MOD4) {
                        this.hide();
                    }
                    return true;
                }
            }
            this.selectProposal(newSelection, smartToggle);
            e.doit = false;
            return false;
        }
        switch (key) {
            case '\u001b': {
                e.doit = false;
                this.hide();
                break;
            }
            case '\n': 
            case '\r': {
                e.doit = false;
                this.selectProposalWithMask(e.stateMask);
                break;
            }
            case '\t': {
                e.doit = false;
                this.fProposalShell.setFocus();
                return false;
            }
            default: {
                ICompletionProposalExtension t;
                char[] triggers;
                ICompletionProposal p = this.getSelectedProposal();
                if (!(p instanceof ICompletionProposalExtension) || !this.contains(triggers = (t = (ICompletionProposalExtension)((Object)p)).getTriggerCharacters(), key)) break;
                e.doit = false;
                this.hide();
                this.insertProposal(p, key, e.stateMask, this.fContentAssistSubjectAdapter.getSelectedRange().x);
            }
        }
        return true;
    }

    private void selectProposal(int index, boolean smartToggle) {
        ICompletionProposal proposal;
        ICompletionProposal oldProposal = this.getSelectedProposal();
        if (oldProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)((Object)oldProposal)).unselected(this.fViewer);
        }
        if ((proposal = this.fFilteredProposals[index]) instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)((Object)proposal)).selected(this.fViewer, smartToggle);
        }
        this.fLastProposal = proposal;
        this.fProposalTable.setSelection(index);
        this.fProposalTable.showSelection();
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.handleTableSelectionChanged();
        }
    }

    private boolean contains(char[] characters, char c) {
        if (characters == null) {
            return false;
        }
        int i = 0;
        while (i < characters.length) {
            if (c == characters[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void processEvent(VerifyEvent e) {
    }

    private void filterProposals() {
        ++this.fInvocationCounter;
        Control control = this.fContentAssistSubjectAdapter.getControl();
        control.getDisplay().asyncExec(new Runnable(){
            long fCounter;
            {
                this.fCounter = CompletionProposalPopup.this.fInvocationCounter;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                if (this.fCounter != CompletionProposalPopup.this.fInvocationCounter) {
                    return;
                }
                int offset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectAdapter.getSelectedRange().x;
                ICompletionProposal[] proposals = null;
                try {
                    try {
                        if (offset > -1) {
                            DocumentEvent event = TextUtilities.mergeProcessedDocumentEvents((List)CompletionProposalPopup.this.fDocumentEvents);
                            proposals = CompletionProposalPopup.this.computeFilteredProposals(offset, event);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    CompletionProposalPopup.this.fDocumentEvents.clear();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    CompletionProposalPopup.this.fDocumentEvents.clear();
                }
                CompletionProposalPopup.this.fFilterOffset = offset;
                if (proposals != null && proposals.length > 0) {
                    CompletionProposalPopup.this.setProposals(proposals);
                    return;
                }
                CompletionProposalPopup.this.hide();
            }
        });
    }

    private ICompletionProposal[] computeFilteredProposals(int offset, DocumentEvent event) {
        if (offset == this.fInvocationOffset && event == null) {
            return this.fComputedProposals;
        }
        if (offset < this.fInvocationOffset) {
            this.fInvocationOffset = offset;
            this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
            return this.fComputedProposals;
        }
        ICompletionProposal[] proposals = this.fComputedProposals;
        if (offset > this.fFilterOffset) {
            proposals = this.fFilteredProposals;
        }
        if (proposals == null) {
            return null;
        }
        IDocument document = this.fContentAssistSubjectAdapter.getDocument();
        int length = proposals.length;
        ArrayList<Object> filtered = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            Object p;
            if (proposals[i] instanceof ICompletionProposalExtension2) {
                p = (ICompletionProposalExtension2)((Object)proposals[i]);
                if (p.validate(document, offset, event)) {
                    filtered.add(p);
                }
            } else if (proposals[i] instanceof ICompletionProposalExtension) {
                p = (ICompletionProposalExtension)((Object)proposals[i]);
                if (p.isValidFor(document, offset)) {
                    filtered.add(p);
                }
            } else {
                this.fInvocationOffset = offset;
                this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
                return this.fComputedProposals;
            }
            ++i;
        }
        ICompletionProposal[] p = new ICompletionProposal[filtered.size()];
        filtered.toArray(p);
        return p;
    }

    public void setFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fProposalShell.setFocus();
        }
    }

    public String incrementalComplete() {
        if (Helper.okToUse((Widget)this.fProposalShell) && this.fFilteredProposals != null) {
            this.completeCommonPrefix();
        } else {
            final Control control = this.fContentAssistSubjectAdapter.getControl();
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int count;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fFilteredProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                    int n = count = CompletionProposalPopup.this.fFilteredProposals == null ? 0 : CompletionProposalPopup.this.fFilteredProposals.length;
                    if (count == 0) {
                        control.getDisplay().beep();
                    } else if (count == 1 && CompletionProposalPopup.this.fContentAssistant.isAutoInserting()) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fFilteredProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                    } else {
                        if (CompletionProposalPopup.this.fLineDelimiter == null) {
                            CompletionProposalPopup.this.fLineDelimiter = CompletionProposalPopup.this.fContentAssistSubjectAdapter.getLineDelimiter();
                        }
                        if (CompletionProposalPopup.this.completeCommonPrefix()) {
                            CompletionProposalPopup.this.unregister();
                        } else {
                            if (CompletionProposalPopup.this.fKeyListener == null) {
                                CompletionProposalPopup.this.fKeyListener = new MyKeyListener();
                            }
                            if (!control.isDisposed()) {
                                CompletionProposalPopup.this.fContentAssistSubjectAdapter.addKeyListener(CompletionProposalPopup.this.fKeyListener);
                            }
                            CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.fFilteredProposals;
                            CompletionProposalPopup.this.createProposalSelector();
                            CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals);
                            CompletionProposalPopup.this.displayProposals();
                        }
                    }
                }
            });
        }
        return this.getErrorMessage();
    }

    private boolean completeCommonPrefix() {
        if (this.fFilteredProposals.length == 1) {
            this.insertProposal(this.fFilteredProposals[0], '\u0000', 0, this.fInvocationOffset);
            this.hide();
            return true;
        }
        StringBuffer prefix = null;
        boolean isCaseCompatible = true;
        IDocument document = this.fViewer.getDocument();
        int startOffset = -1;
        String currentPrefix = null;
        int currentPrefixLen = -1;
        int i = 0;
        while (i < this.fFilteredProposals.length) {
            ICompletionProposal proposal = this.fFilteredProposals[i];
            CharSequence insertion = this.getReplacementString(proposal);
            if (currentPrefix == null) {
                startOffset = this.getReplacementOffset(proposal);
                currentPrefixLen = this.fFilterOffset - startOffset;
                try {
                    currentPrefix = document.get(startOffset, currentPrefixLen);
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (!this.isCaseSensitive() || insertion.toString().startsWith(currentPrefix)) {
                if (prefix == null) {
                    prefix = new StringBuffer(insertion.toString());
                } else {
                    isCaseCompatible &= this.truncatePrefix(prefix, insertion);
                }
                if (prefix.length() == 0) break;
            }
            ++i;
        }
        if (prefix == null || prefix.toString().equals(currentPrefix)) {
            return false;
        }
        try {
            int replaceLen;
            int replaceOffset;
            String presentPart = prefix.substring(0, currentPrefixLen);
            if (isCaseCompatible && !currentPrefix.equals(presentPart)) {
                currentPrefixLen = 0;
                replaceOffset = startOffset;
                replaceLen = this.fFilterOffset - startOffset;
            } else {
                replaceOffset = this.fFilterOffset;
                replaceLen = 0;
            }
            int remainingLen = prefix.length() - currentPrefixLen;
            String remainingPrefix = prefix.subSequence(currentPrefixLen, currentPrefixLen + remainingLen).toString();
            document.replace(replaceOffset, replaceLen, remainingPrefix);
            this.fViewer.setSelectedRange(replaceOffset + remainingLen, 0);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private int getReplacementOffset(ICompletionProposal proposal) {
        if (proposal instanceof ICompletionProposalExtension3) {
            return ((ICompletionProposalExtension3)((Object)proposal)).getCompletionOffset();
        }
        return this.fInvocationOffset;
    }

    private boolean truncatePrefix(StringBuffer prefix, CharSequence anycase) {
        int min = Math.min(prefix.length(), anycase.length());
        boolean caseCompatible = true;
        int c = 0;
        while (c < min) {
            char compareChar = anycase.charAt(c);
            char prefixChar = prefix.charAt(c);
            if (prefixChar != compareChar) {
                if (this.isCaseSensitive() || Character.toLowerCase(prefixChar) != Character.toLowerCase(compareChar)) {
                    prefix.delete(c, prefix.length());
                    return caseCompatible;
                }
                caseCompatible = false;
            }
            ++c;
        }
        prefix.delete(min, prefix.length());
        return caseCompatible;
    }

    private boolean isCaseSensitive() {
        return !Helper.okToUse((Widget)this.fProposalShell);
    }

    private CharSequence getReplacementString(ICompletionProposal proposal) {
        CharSequence insertion = null;
        if (proposal instanceof ICompletionProposalExtension3) {
            insertion = ((ICompletionProposalExtension3)((Object)proposal)).getCompletionText();
        }
        if (insertion == null) {
            insertion = proposal.getDisplayString();
        }
        return insertion;
    }

    private final class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int index;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (e.character == '\u0000' && e.keyCode == SWT.MOD1 && (index = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(index, true);
            }
        }

        public void keyReleased(KeyEvent e) {
            int index;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (e.character == '\u0000' && e.keyCode == SWT.MOD1 && (index = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(index, false);
            }
        }
    }
}

