/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class CursorLinePainter
implements IPainter,
LineBackgroundListener {
    private final ITextViewer fViewer;
    private Color fHighlightColor;
    private IPaintPositionManager fPositionManager;
    private Position fCurrentLine = new Position(0, 0);
    private Position fLastLine = new Position(0, 0);
    private int fLastLineNumber = -1;
    private boolean fIsActive;

    public CursorLinePainter(ITextViewer textViewer) {
        this.fViewer = textViewer;
    }

    public void setHighlightColor(Color highlightColor) {
        this.fHighlightColor = highlightColor;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        StyledText textWidget = this.fViewer.getTextWidget();
        if (textWidget != null) {
            int caret = textWidget.getCaretOffset();
            int length = event.lineText.length();
            event.lineBackground = event.lineOffset <= caret && caret <= event.lineOffset + length ? this.fHighlightColor : textWidget.getBackground();
        }
    }

    private boolean updateHighlightLine() {
        try {
            IDocument document = this.fViewer.getDocument();
            int lineNumber = document.getLineOfOffset(this.getModelCaret());
            if (lineNumber != this.fLastLineNumber) {
                this.fLastLine.offset = this.fCurrentLine.offset;
                this.fLastLine.length = this.fCurrentLine.length;
                this.fLastLine.isDeleted = this.fCurrentLine.isDeleted;
                this.fCurrentLine.isDeleted = false;
                this.fCurrentLine.offset = document.getLineOffset(lineNumber);
                this.fCurrentLine.length = lineNumber == document.getNumberOfLines() - 1 ? document.getLength() - this.fCurrentLine.offset : document.getLineOffset(lineNumber + 1) - this.fCurrentLine.offset;
                this.fLastLineNumber = lineNumber;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int getModelCaret() {
        int widgetCaret = this.fViewer.getTextWidget().getCaretOffset();
        if (this.fViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fViewer);
            return extension.modelOffset2WidgetOffset(widgetCaret);
        }
        IRegion visible = this.fViewer.getVisibleRegion();
        return widgetCaret + visible.getOffset();
    }

    private void drawHighlightLine(Position position) {
        if (position.isDeleted()) {
            return;
        }
        int widgetOffset = 0;
        if (this.fViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fViewer);
            widgetOffset = extension.modelOffset2WidgetOffset(position.getOffset());
            if (widgetOffset == -1) {
                return;
            }
        } else {
            IRegion visible = this.fViewer.getVisibleRegion();
            widgetOffset = position.getOffset() - visible.getOffset();
            if (widgetOffset < 0 || visible.getLength() < widgetOffset) {
                return;
            }
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        Point upperLeft = textWidget.getLocationAtOffset(widgetOffset);
        int width = textWidget.getClientArea().width + textWidget.getHorizontalPixel();
        int height = textWidget.getLineHeight();
        textWidget.redraw(0, upperLeft.y, width, height, false);
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            if (redraw) {
                this.drawHighlightLine(this.fCurrentLine);
            }
            this.fViewer.getTextWidget().removeLineBackgroundListener((LineBackgroundListener)this);
            if (this.fPositionManager != null) {
                this.fPositionManager.unmanagePosition(this.fCurrentLine);
            }
            this.fLastLineNumber = -1;
        }
    }

    public void dispose() {
    }

    public void paint(int reason) {
        if (this.fViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        Point selection = this.fViewer.getTextWidget().getSelectionRange();
        if (selection.y > 0) {
            this.deactivate(true);
            return;
        }
        if (!this.fIsActive) {
            this.fViewer.getTextWidget().addLineBackgroundListener((LineBackgroundListener)this);
            this.fPositionManager.managePosition(this.fCurrentLine);
            this.fIsActive = true;
        }
        if (this.updateHighlightLine()) {
            this.drawHighlightLine(this.fLastLine);
            this.drawHighlightLine(this.fCurrentLine);
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
        this.fPositionManager = manager;
    }
}

