/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.internal.filebuffers.ContainerGenerator;
import org.eclipse.core.internal.filebuffers.ResourceFileBuffer;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class ResourceTextFileBuffer
extends ResourceFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final QualifiedName ENCODING_KEY = new QualifiedName("org.eclipse.core.filebuffers", "encoding");
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.core.filebuffers", 0, "OK", null);
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 1, "Error", null);
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();

    public ResourceTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
        try {
            this.fFile.setPersistentProperty(ENCODING_KEY, encoding);
        }
        catch (CoreException x) {
            this.handleCoreException(x);
        }
    }

    public IStatus getStatus() {
        if (!this.isDisposed()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    public void revert(IProgressMonitor monitor) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        this.refreshFile(monitor);
        IDocument original = null;
        IStatus status = null;
        try {
            original = this.fManager.createEmptyDocument(this.fFile.getLocation());
            this.setDocumentContent(original, this.fFile.getContents(), this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        this.fStatus = status;
        if (original != null) {
            boolean replaceContents;
            String originalContents = original.get();
            boolean bl = replaceContents = !originalContents.equals(this.fDocument.get());
            if (replaceContents) {
                this.fManager.fireBufferContentAboutToBeReplaced(this);
                this.fDocument.set(original.get());
            }
            if (this.fCanBeSaved) {
                this.fCanBeSaved = false;
                this.addFileBufferContentListeners();
            }
            if (replaceContents) {
                this.fManager.fireBufferContentReplaced(this);
            }
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            this.fEncoding = this.fFile.getPersistentProperty(ENCODING_KEY);
            this.fDocument = this.fManager.createEmptyDocument(this.fFile.getLocation());
            this.setDocumentContent(this.fDocument, this.fFile.getContents(), this.fEncoding);
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.fFile.getLocation());
            this.fStatus = x.getStatus();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        try {
            String encoding = this.getEncoding();
            if (encoding == null) {
                encoding = this.fManager.getDefaultEncoding();
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(this.fDocument.get().getBytes(encoding));
            if (this.fFile.exists()) {
                if (!overwrite) {
                    this.checkSynchronizationState();
                }
                this.fFile.setContents((InputStream)stream, overwrite, true, monitor);
                this.fSynchronizationStamp = this.fFile.getModificationStamp();
                return;
            }
            try {
                monitor.beginTask("Saving", 2000);
                ContainerGenerator generator = new ContainerGenerator(this.fFile.getWorkspace(), this.fFile.getParent().getFullPath());
                generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.fFile.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var6_11 = null;
                monitor.done();
                return;
            }
        }
        catch (IOException x) {
            String message = x.getMessage() != null ? x.getMessage() : "";
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
            throw new CoreException((IStatus)s);
        }
    }

    protected void handleFileContentChanged() {
        if (this.isDisposed()) {
            return;
        }
        IDocument document = this.fManager.createEmptyDocument(this.fFile.getLocation());
        IStatus status = null;
        try {
            this.setDocumentContent(document, this.fFile.getContents(false), this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        String newContent = document.get();
        if (!newContent.equals(this.fDocument.get())) {
            this.fManager.fireBufferContentAboutToBeReplaced(this);
            this.removeFileBufferContentListeners();
            this.fDocument.set(newContent);
            this.fCanBeSaved = false;
            this.fSynchronizationStamp = this.fFile.getModificationStamp();
            this.fStatus = status;
            this.addFileBufferContentListeners();
            this.fManager.fireBufferContentReplaced(this);
        } else {
            this.removeFileBufferContentListeners();
            this.fCanBeSaved = false;
            this.fSynchronizationStamp = this.fFile.getModificationStamp();
            this.fStatus = status;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    /*
     * Exception decompiling
     */
    private void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 182->186)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.fFile.isSynchronized(0)) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, "out of sync", null);
            throw new CoreException((IStatus)status);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            ResourceTextFileBuffer.this.fCanBeSaved = true;
            ResourceTextFileBuffer.this.removeFileBufferContentListeners();
            ResourceTextFileBuffer.this.fManager.fireDirtyStateChanged(ResourceTextFileBuffer.this, ResourceTextFileBuffer.this.fCanBeSaved);
        }
    }
}

