/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public abstract class ResourceFileBuffer
extends AbstractFileBuffer {
    protected IPath fLocation;
    protected IFile fFile;
    protected int fReferenceCount;
    protected boolean fCanBeSaved = false;
    protected boolean fIsStateValidated = false;
    protected IStatus fStatus;
    protected FileSynchronizer fFileSynchronizer;
    protected long fSynchronizationStamp = -1L;
    protected int fSynchronizationContextCount;
    protected TextFileBufferManager fManager;

    public ResourceFileBuffer(TextFileBufferManager manager) {
        this.fManager = manager;
    }

    protected abstract void handleFileContentChanged();

    protected abstract void addFileBufferContentListeners();

    protected abstract void removeFileBufferContentListeners();

    protected abstract void initializeFileBufferContent(IProgressMonitor var1) throws CoreException;

    protected abstract void commitFileBufferContent(IProgressMonitor var1, boolean var2) throws CoreException;

    public void create(IPath location, IProgressMonitor monitor) throws CoreException {
        IFile file = FileBuffers.getWorkspaceFileAtLocation(location);
        if (file == null || !file.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, "File does not exist", null));
        }
        this.fLocation = location;
        this.fFile = file;
        this.fFileSynchronizer = new FileSynchronizer();
        this.refreshFile(monitor);
        this.initializeFileBufferContent(monitor);
        this.fSynchronizationStamp = this.fFile.getModificationStamp();
        this.addFileBufferContentListeners();
    }

    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.fFileSynchronizer.install();
        }
    }

    public void disconnect() throws CoreException {
        --this.fReferenceCount;
        if (this.fReferenceCount == 0) {
            if (this.fFileSynchronizer != null) {
                this.fFileSynchronizer.uninstall();
            }
            this.fFileSynchronizer = null;
        }
    }

    public boolean isDisposed() {
        return this.fFileSynchronizer == null;
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    public void commit(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        if (!this.isDisposed() && this.fCanBeSaved) {
            this.fManager.fireStateChanging(this);
            try {
                this.commitFileBufferContent(monitor, overwrite);
            }
            catch (CoreException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            catch (RuntimeException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            this.fCanBeSaved = false;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    public boolean isDirty() {
        return this.fCanBeSaved;
    }

    public boolean isShared() {
        return this.fReferenceCount > 1;
    }

    public void validateState(IProgressMonitor monitor, Object computationContext) throws CoreException {
        if (!this.isDisposed() && !this.fIsStateValidated) {
            if (this.fFile.isReadOnly()) {
                IWorkspace workspace = this.fFile.getWorkspace();
                this.fStatus = workspace.validateEdit(new IFile[]{this.fFile}, computationContext);
            }
            this.fIsStateValidated = true;
            this.fManager.fireStateValidationChanged(this, this.fIsStateValidated);
        }
    }

    public boolean isStateValidated() {
        return this.fIsStateValidated;
    }

    public void resetStateValidation() {
        if (this.fIsStateValidated) {
            this.fIsStateValidated = false;
            this.fManager.fireStateValidationChanged(this, this.fIsStateValidated);
        }
    }

    protected void handleFileMoved(IPath newLocation) {
        this.fManager.fireUnderlyingFileMoved(this, newLocation);
    }

    protected void handleFileDeleted() {
        this.fManager.fireUnderlyingFileDeleted(this);
    }

    protected void refreshFile(IProgressMonitor monitor) {
        try {
            this.fFile.refreshLocal(2, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException x) {
            this.handleCoreException(x);
        }
    }

    protected void handleCoreException(CoreException exception) {
        ILog log = Platform.getPlugin((String)"org.eclipse.core.filebuffers").getLog();
        log.log(exception.getStatus());
    }

    public boolean isSynchronized() {
        return this.fSynchronizationStamp == this.fFile.getModificationStamp() && this.fFile.isSynchronized(0);
    }

    public long getModifcationStamp() {
        File file = FileBuffers.getSystemFileAtLocation(this.getLocation());
        if (file != null) {
            return file.lastModified();
        }
        return -1L;
    }

    public void requestSynchronizationContext() {
        ++this.fSynchronizationContextCount;
    }

    public void releaseSynchronizationContext() {
        --this.fSynchronizationContextCount;
    }

    private class SafeFileChange
    implements Runnable {
        protected void execute() throws Exception {
        }

        public void preRun() {
            ResourceFileBuffer.this.fManager.fireStateChanging(ResourceFileBuffer.this);
        }

        public void run() {
            if (ResourceFileBuffer.this.isDisposed()) {
                ResourceFileBuffer.this.fManager.fireStateChangeFailed(ResourceFileBuffer.this);
                return;
            }
            try {
                this.execute();
            }
            catch (Exception x) {
                FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, "Exception when synchronizing", (Throwable)x));
                ResourceFileBuffer.this.fManager.fireStateChangeFailed(ResourceFileBuffer.this);
            }
        }
    }

    private class FileSynchronizer
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private boolean fIsInstalled = false;

        public void install() {
            ResourceFileBuffer.this.fFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = true;
        }

        public void uninstall() {
            ResourceFileBuffer.this.fFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = false;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null && this.fIsInstalled) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException x) {
                ResourceFileBuffer.this.handleCoreException(x);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && ResourceFileBuffer.this.fFile.equals((Object)delta.getResource())) {
                SafeFileChange fileChange = null;
                switch (delta.getKind()) {
                    case 4: {
                        if ((0x100 & delta.getFlags()) == 0 || ResourceFileBuffer.this.isDisposed() || ResourceFileBuffer.this.fCanBeSaved || ResourceFileBuffer.this.isSynchronized()) break;
                        fileChange = new SafeFileChange(this, ResourceFileBuffer.this){
                            final /* synthetic */ FileSynchronizer this$1;
                            {
                                this.this$1 = fileSynchronizer;
                            }

                            protected void execute() throws Exception {
                                FileSynchronizer.access$0(this.this$1).handleFileContentChanged();
                            }
                        };
                        break;
                    }
                    case 2: {
                        if ((0x2000 & delta.getFlags()) != 0) {
                            IPath path = delta.getMovedToPath();
                            fileChange = new SafeFileChange(this, ResourceFileBuffer.this, path){
                                final /* synthetic */ FileSynchronizer this$1;
                                private final /* synthetic */ IPath val$path;
                                {
                                    this.this$1 = fileSynchronizer;
                                    this.val$path = iPath;
                                }

                                protected void execute() throws Exception {
                                    FileSynchronizer.access$0(this.this$1).handleFileMoved(this.val$path);
                                }
                            };
                            break;
                        }
                        if (ResourceFileBuffer.this.isDisposed() || ResourceFileBuffer.this.fCanBeSaved) break;
                        fileChange = new SafeFileChange(this, ResourceFileBuffer.this){
                            final /* synthetic */ FileSynchronizer this$1;
                            {
                                this.this$1 = fileSynchronizer;
                            }

                            protected void execute() throws Exception {
                                FileSynchronizer.access$0(this.this$1).handleFileDeleted();
                            }
                        };
                    }
                }
                if (fileChange != null) {
                    fileChange.preRun();
                    ResourceFileBuffer.this.fManager.execute(fileChange, ResourceFileBuffer.this.fSynchronizationContextCount > 0);
                }
            }
            return true;
        }

        static /* synthetic */ ResourceFileBuffer access$0(FileSynchronizer fileSynchronizer) {
            return fileSynchronizer.ResourceFileBuffer.this;
        }
    }
}

