/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public class FileBuffersPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.core.filebuffers";
    private static FileBuffersPlugin fgPlugin;
    private ResourceBundle fResourceBundle;
    private ITextFileBufferManager fTextFileBufferManager;

    public FileBuffersPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgPlugin = this;
        try {
            this.fResourceBundle = ResourceBundle.getBundle("org.eclipse.core.internal.filebuffers.FileBuffersPlugin");
        }
        catch (MissingResourceException missingResourceException) {
            this.fResourceBundle = null;
        }
    }

    public static FileBuffersPlugin getDefault() {
        return fgPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = FileBuffersPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public ITextFileBufferManager getFileBufferManager() {
        if (this.fTextFileBufferManager == null) {
            this.fTextFileBufferManager = new TextFileBufferManager();
        }
        return this.fTextFileBufferManager;
    }
}

