/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ExtensionsRegistry {
    private static final String WILDCARD = "*";
    private Map fFactoryDescriptors = new HashMap();
    private Map fFactories = new HashMap();
    private Map fSetupParticipantDescriptors = new HashMap();
    private Map fSetupParticipants = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExtensionsRegistry() {
        this.initialize("documentCreation", "extensions", this.fFactoryDescriptors);
        this.initialize("documentSetup", "extensions", this.fSetupParticipantDescriptors);
    }

    private void read(String attributeName, IConfigurationElement element, Map map) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                HashSet<IConfigurationElement> s = (HashSet<IConfigurationElement>)map.get(token);
                if (s == null) {
                    s = new HashSet<IConfigurationElement>();
                    map.put(token, s);
                }
                s.add(element);
            }
        }
    }

    private void log(IStatus status) {
        ILog log = Platform.getPlugin((String)"org.eclipse.core.filebuffers").getLog();
        log.log(status);
    }

    private void initialize(String extensionPointName, String childElementName, Map descriptors) {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.core.filebuffers", extensionPointName);
        if (extensionPoint == null) {
            this.log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, MessageFormat.format("Extension point \"{0}\" not found.", extensionPointName), null));
            return;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.read(childElementName, elements[i], descriptors);
            ++i;
        }
    }

    private Object getExtension(IConfigurationElement entry, Map extensions, Class extensionType) {
        Object extension = extensions.get(entry);
        if (extension != null) {
            return extension;
        }
        try {
            extension = entry.createExecutableExtension("class");
        }
        catch (CoreException x) {
            this.log(x.getStatus());
        }
        if (extensionType.isInstance(extension)) {
            extensions.put(entry, extension);
            return extension;
        }
        return null;
    }

    private IConfigurationElement selectConfigurationElement(Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator e = set.iterator();
            return (IConfigurationElement)e.next();
        }
        return null;
    }

    private IDocumentFactory getDocumentFactory(String extension) {
        Set set = (Set)this.fFactoryDescriptors.get(extension);
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.filebuffers.IDocumentFactory;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IDocumentFactory)this.getExtension(entry, this.fFactories, clazz);
        }
        return null;
    }

    private List getDocumentSetupParticipants(String extension) {
        Set set = (Set)this.fSetupParticipantDescriptors.get(extension);
        if (set == null) {
            return null;
        }
        ArrayList<Object> participants = new ArrayList<Object>();
        Iterator e = set.iterator();
        while (e.hasNext()) {
            Object participant;
            IConfigurationElement entry = (IConfigurationElement)e.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.core.filebuffers.IDocumentSetupParticipant;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((participant = this.getExtension(entry, this.fSetupParticipants, clazz)) == null) continue;
            participants.add(participant);
        }
        return participants;
    }

    public IDocumentFactory getDocumentFactory(IPath location) {
        IDocumentFactory factory = this.getDocumentFactory(location.getFileExtension());
        if (factory == null) {
            factory = this.getDocumentFactory(WILDCARD);
        }
        return factory;
    }

    public IDocumentSetupParticipant[] getDocumentSetupParticipants(IPath location) {
        ArrayList participants = new ArrayList();
        List p = this.getDocumentSetupParticipants(location.getFileExtension());
        if (p != null) {
            participants.addAll(p);
        }
        if ((p = this.getDocumentSetupParticipants(WILDCARD)) != null) {
            participants.addAll(p);
        }
        IDocumentSetupParticipant[] result = new IDocumentSetupParticipant[participants.size()];
        participants.toArray(result);
        return result;
    }
}

