/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers;

import java.io.File;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public final class FileBuffers {
    private FileBuffers() {
    }

    public static ITextFileBufferManager getTextFileBufferManager() {
        return FileBuffersPlugin.getDefault().getFileBufferManager();
    }

    public static IFile getWorkspaceFileAtLocation(IPath location) {
        IPath normalized = FileBuffers.normalizeLocation(location);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(normalized);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static IPath normalizeLocation(IPath location) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IPath path = projects[i].getLocation();
            if (path.isPrefixOf(location)) {
                IPath filePath = location.removeFirstSegments(path.segmentCount());
                filePath = projects[i].getFullPath().append(filePath);
                return filePath.makeAbsolute();
            }
            ++i;
        }
        return location.makeAbsolute();
    }

    public static File getSystemFileAtLocation(IPath location) {
        if (location == null) {
            return null;
        }
        IFile file = FileBuffers.getWorkspaceFileAtLocation(location);
        if (file != null) {
            IPath path = file.getLocation();
            return path.toFile();
        }
        return location.toFile();
    }
}

