/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Text
extends Scrollable {
    int tabs;
    int oldStart;
    int oldEnd;
    boolean doubleClick;
    boolean ignoreVerify;
    boolean ignoreCharacter;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    public static final String DELIMITER = "\r\n";
    static final int EditProc;
    static final TCHAR EditClass;

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, EditClass, lpWndClass);
        EditProc = lpWndClass.lpfnWndProc;
    }

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(EditProc, this.handle, msg, wParam, lParam);
    }

    void createHandle() {
        super.createHandle();
        OS.SendMessage(this.handle, 197, 0, 0);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        int length = OS.GetWindowTextLength(this.handle);
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, length, length, null)) == null) {
            return;
        }
        OS.SendMessage(this.handle, 177, length, length);
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, buffer);
        this.ignoreCharacter = false;
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            int[] end = new int[1];
            OS.SendMessage(this.handle, 176, null, end);
            OS.SendMessage(this.handle, 177, end[0], end[0]);
        } else {
            OS.SendMessage(this.handle, 177, -1, 0);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        if (wHint == -1 || hHint == -1) {
            int newHeight;
            boolean wrap;
            int oldFont = 0;
            int hDC = OS.GetDC(this.handle);
            int newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(hDC, tm);
            int count = OS.SendMessage(this.handle, 186, 0, 0);
            height = count * tm.tmHeight;
            RECT rect = new RECT();
            int flags = 11264;
            boolean bl = wrap = (this.style & 2) != 0 && (this.style & 0x40) != 0;
            if (wrap && wHint != -1) {
                flags |= 0x10;
                rect.right = wHint;
            }
            String text = this.getText();
            TCHAR buffer = new TCHAR(this.getCodePage(), text, false);
            int length = buffer.length();
            if (length != 0) {
                OS.DrawText(hDC, buffer, length, rect, flags);
                width = rect.right - rect.left;
            }
            if (wrap && hHint == -1 && (newHeight = rect.bottom - rect.top) != 0) {
                height = newHeight;
            }
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int margins = OS.SendMessage(this.handle, 212, 0, 0);
        int marginWidth = (margins & 0xFFFF) + (margins >> 16 & 0xFFFF);
        width += marginWidth;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
            if ((this.style & 0x800) == 0) {
                ++width;
            }
        }
        if ((this.style & 0x800) != 0) {
            int border = this.getBorderWidth();
            width += border * 2 + 3;
            height += border * 2 + 3;
        }
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    void createWidget() {
        super.createWidget();
        this.doubleClick = true;
        this.tabs = 8;
        this.setTabStops(8);
        this.fixAlignment();
    }

    public void cut() {
        this.checkWidget();
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void fixAlignment() {
        if ((this.style & 0x8000000) != 0) {
            return;
        }
        int bits0 = OS.GetWindowLong(this.handle, -20);
        int bits1 = OS.GetWindowLong(this.handle, -16);
        if ((this.style & 0x2000000) != 0) {
            if ((this.style & 0x20000) != 0) {
                bits0 |= 0x1000;
                bits1 |= 2;
            }
            if ((this.style & 0x4000) != 0) {
                bits0 &= 0xFFFFEFFF;
                bits1 &= 0xFFFFFFFD;
            }
        } else {
            if ((this.style & 0x20000) != 0) {
                bits0 &= 0xFFFFEFFF;
                bits1 &= 0xFFFFFFFD;
            }
            if ((this.style & 0x4000) != 0) {
                bits0 |= 0x1000;
                bits1 |= 2;
            }
        }
        if ((this.style & 0x1000000) != 0) {
            bits1 |= 1;
        }
        OS.SetWindowLong(this.handle, -20, bits0);
        OS.SetWindowLong(this.handle, -16, bits1);
    }

    public int getBorderWidth() {
        this.checkWidget();
        return super.getBorderWidth();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 201, -1, 0);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        int[] start = new int[1];
        OS.SendMessage(this.handle, 176, start, null);
        int pos = OS.SendMessage(this.handle, 214, start[0], 0);
        if (pos == -1) {
            pos = 0;
            if (start[0] >= OS.GetWindowTextLength(this.handle)) {
                int cp = this.getCodePage();
                this.ignoreCharacter = true;
                OS.SendMessage(this.handle, 194, 0, new TCHAR(cp, " ", true));
                pos = OS.SendMessage(this.handle, 214, start[0], 0);
                OS.SendMessage(this.handle, 177, start[0], start[0] + 1);
                OS.SendMessage(this.handle, 194, 0, new TCHAR(cp, "", true));
                this.ignoreCharacter = false;
            }
        }
        return new Point((short)(pos & 0xFFFF), (short)(pos >> 16));
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        int startLine = OS.SendMessage(this.handle, 201, start[0], 0);
        int caretPos = OS.SendMessage(this.handle, 187, -1, 0);
        int caretLine = OS.SendMessage(this.handle, 201, caretPos, 0);
        int caret = end[0];
        if (caretLine == startLine) {
            caret = start[0];
        }
        if (OS.IsDBLocale) {
            caret = this.mbcsToWcsPos(caret);
        }
        return caret;
    }

    public int getCharCount() {
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        if (OS.IsDBLocale) {
            length = this.mbcsToWcsPos(length);
        }
        return length;
    }

    String getClipboardText() {
        String string = "";
        if (OS.OpenClipboard(0)) {
            int hMem = OS.GetClipboardData(OS.IsUnicode ? 13 : 1);
            if (hMem != 0) {
                int byteCount = OS.GlobalSize(hMem) / TCHAR.sizeof * TCHAR.sizeof;
                int ptr = OS.GlobalLock(hMem);
                if (ptr != 0) {
                    TCHAR buffer = new TCHAR(0, byteCount / TCHAR.sizeof);
                    OS.MoveMemory(buffer, ptr, byteCount);
                    string = buffer.toString(0, buffer.strlen());
                    OS.GlobalUnlock(hMem);
                }
            }
            OS.CloseClipboard();
        }
        return string;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        int echo = OS.SendMessage(this.handle, 210, 0, 0);
        if (echo != 0 && (echo = this.mbcsToWcs(echo, this.getCodePage())) == 0) {
            echo = 42;
        }
        return (char)echo;
    }

    public boolean getEditable() {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0x800) == 0;
    }

    public int getLineCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 186, 0, 0);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        int oldFont = 0;
        int hDC = OS.GetDC(this.handle);
        int newFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        return tm.tmHeight;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        if (OS.IsDBLocale) {
            start[0] = this.mbcsToWcsPos(start[0]);
            end[0] = this.mbcsToWcsPos(end[0]);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return selection.y - selection.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        int oldFont = 0;
        RECT rect = new RECT();
        int hDC = OS.GetDC(this.handle);
        int newFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        int flags = 3104;
        TCHAR SPACE = new TCHAR(this.getCodePage(), " ", false);
        OS.DrawText(hDC, SPACE, SPACE.length(), rect, flags);
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        return (rect.right - rect.left) * tabs;
    }

    public String getText() {
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        return buffer.toString(0, length);
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return "";
        }
        int length = OS.GetWindowTextLength(this.handle);
        if (OS.IsDBLocale) {
            length = this.mbcsToWcsPos(length);
        }
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        return this.getText().substring(start, end + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 213, 0, 0);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return OS.SendMessage(this.handle, 206, 0, 0);
    }

    public int getTopPixel() {
        this.checkWidget();
        int[] buffer = new int[2];
        int code = OS.SendMessage(this.handle, 1245, 0, buffer);
        if (code == 1) {
            return buffer[1];
        }
        return this.getTopIndex() * this.getLineHeight();
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if (this.hooks(25) || this.filters(25)) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.SendMessage(this.handle, 176, start, end);
            string = this.verifyText(string, start[0], end[0], null);
            if (string == null) {
                return;
            }
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, buffer);
        this.ignoreCharacter = false;
    }

    int mbcsToWcsPos(int mbcsPos) {
        if (mbcsPos == 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return mbcsPos;
        }
        int cp = this.getCodePage();
        int wcsTotal = 0;
        int mbcsTotal = 0;
        byte[] buffer = new byte[128];
        String delimiter = this.getLineDelimiter();
        int delimiterSize = delimiter.length();
        int count = OS.SendMessageA(this.handle, 186, 0, 0);
        int line = 0;
        while (line < count) {
            int wcsSize = 0;
            int linePos = OS.SendMessageA(this.handle, 187, line, 0);
            int mbcsSize = OS.SendMessageA(this.handle, 193, linePos, 0);
            if (mbcsSize != 0) {
                if (mbcsSize + delimiterSize > buffer.length) {
                    buffer = new byte[mbcsSize + delimiterSize];
                }
                buffer[0] = (byte)(mbcsSize & 0xFF);
                buffer[1] = (byte)(mbcsSize >> 8);
                mbcsSize = OS.SendMessageA(this.handle, 196, line, buffer);
                wcsSize = OS.MultiByteToWideChar(cp, 1, buffer, mbcsSize, null, 0);
            }
            if (line - 1 != count) {
                int i = 0;
                while (i < delimiterSize) {
                    buffer[mbcsSize++] = (byte)delimiter.charAt(i);
                    ++i;
                }
                wcsSize += delimiterSize;
            }
            if (mbcsTotal + mbcsSize >= mbcsPos) {
                int bufferSize = mbcsPos - mbcsTotal;
                wcsSize = OS.MultiByteToWideChar(cp, 1, buffer, bufferSize, null, 0);
                return wcsTotal + wcsSize;
            }
            wcsTotal += wcsSize;
            mbcsTotal += mbcsSize;
            ++line;
        }
        return wcsTotal;
    }

    public void paste() {
        this.checkWidget();
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 177, 0, -1);
    }

    boolean sendKeyEvent(int type, int msg, int wParam, int lParam, Event event) {
        String newText;
        if (!super.sendKeyEvent(type, msg, wParam, lParam, event)) {
            return false;
        }
        if (this.ignoreVerify) {
            return true;
        }
        if (type != 1) {
            return true;
        }
        if (msg != 258 && msg != 256 && msg != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char key = event.character;
        int stateMask = event.stateMask;
        switch (msg) {
            case 258: {
                if (key != '\b' && key != '\u007f' && key != '\r' && key != '\t' && key != '\n') break;
            }
            case 256: {
                if ((stateMask & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0) {
            return true;
        }
        String oldText = "";
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        switch (key) {
            case '\b': {
                if (start[0] != end[0]) break;
                if (start[0] == 0) {
                    return true;
                }
                int lineStart = OS.SendMessage(this.handle, 187, -1, 0);
                if (start[0] == lineStart) {
                    start[0] = start[0] - DELIMITER.length();
                } else {
                    start[0] = start[0] - 1;
                    if (OS.IsDBLocale) {
                        int[] newStart = new int[1];
                        int[] newEnd = new int[1];
                        OS.SendMessage(this.handle, 177, start[0], end[0]);
                        OS.SendMessage(this.handle, 176, newStart, newEnd);
                        if (start[0] != newStart[0]) {
                            start[0] = start[0] - 1;
                        }
                    }
                }
                start[0] = Math.max(start[0], 0);
                break;
            }
            case '\u007f': {
                if (start[0] != end[0]) break;
                int length = OS.GetWindowTextLength(this.handle);
                if (start[0] == length) {
                    return true;
                }
                int line = OS.SendMessage(this.handle, 201, end[0], 0);
                int lineStart = OS.SendMessage(this.handle, 187, line + 1, 0);
                if (end[0] == lineStart - DELIMITER.length()) {
                    end[0] = end[0] + DELIMITER.length();
                } else {
                    end[0] = end[0] + 1;
                    if (OS.IsDBLocale) {
                        int[] newStart = new int[1];
                        int[] newEnd = new int[1];
                        OS.SendMessage(this.handle, 177, start[0], end[0]);
                        OS.SendMessage(this.handle, 176, newStart, newEnd);
                        if (end[0] != newEnd[0]) {
                            end[0] = end[0] + 1;
                        }
                    }
                }
                end[0] = Math.min(end[0], length);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                oldText = DELIMITER;
                break;
            }
            default: {
                if (key != '\t' && key < ' ') {
                    return true;
                }
                oldText = new String(new char[]{key});
            }
        }
        if ((newText = this.verifyText(oldText, start[0], end[0], event)) == null) {
            return false;
        }
        if (newText == oldText) {
            return true;
        }
        newText = Display.withCrLf(newText);
        TCHAR buffer = new TCHAR(this.getCodePage(), newText, true);
        OS.SendMessage(this.handle, 177, start[0], end[0]);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, buffer);
        this.ignoreCharacter = false;
        return false;
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if ((flags & 1) == 0 && width != 0) {
            RECT rect = new RECT();
            OS.GetWindowRect(this.handle, rect);
            if (rect.right - rect.left == 0) {
                int[] start = new int[1];
                int[] end = new int[1];
                OS.SendMessage(this.handle, 176, start, end);
                if (start[0] != 0 || end[0] != 0) {
                    OS.SetWindowPos(this.handle, 0, x, y, width, height, flags);
                    OS.SendMessage(this.handle, 177, 0, 0);
                    OS.SendMessage(this.handle, 177, start[0], end[0]);
                    return;
                }
            }
        }
        super.setBounds(x, y, width, height, flags);
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (echo != '\u0000' && (echo = (char)this.wcsToMbcs(echo, this.getCodePage())) == '\u0000') {
            echo = (char)42;
        }
        OS.SendMessage(this.handle, 204, (int)echo, 0);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        OS.SendMessage(this.handle, 207, editable ? 0 : 1, 0);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.setTabStops(this.tabs);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        int bits = OS.GetWindowLong(this.handle, -20);
        bits = (this.style & 0x4000000) != 0 ? (bits |= 0x6000) : (bits &= 0xFFFF9FFF);
        OS.SetWindowLong(this.handle, -20, bits);
        this.fixAlignment();
    }

    public void setSelection(int start) {
        this.checkWidget();
        if (OS.IsDBLocale) {
            start = this.wcsToMbcsPos(start);
        }
        OS.SendMessage(this.handle, 177, start, start);
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (OS.IsDBLocale) {
            start = this.wcsToMbcsPos(start);
            end = this.wcsToMbcsPos(end);
        }
        OS.SendMessage(this.handle, 177, start, end);
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (this.drawCount != 0) {
            return;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        if (!redraw) {
            this.oldStart = start[0];
            this.oldEnd = end[0];
        } else {
            if (this.oldStart == start[0] && this.oldEnd == end[0]) {
                return;
            }
            OS.SendMessage(this.handle, 183, 0, 0);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        int width = this.getTabWidth(tabs) * 4 / (OS.GetDialogBaseUnits() & 0xFFFF);
        OS.SendMessage(this.handle, 203, 1, new int[]{width});
    }

    public void setText(String string) {
        int length;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, length = OS.GetWindowTextLength(this.handle), null)) == null) {
            return;
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, buffer);
        if ((this.style & 2) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.SendMessage(this.handle, 197, limit, 0);
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int count = OS.SendMessage(this.handle, 186, 0, 0);
        index = Math.min(Math.max(index, 0), count - 1);
        int topIndex = OS.SendMessage(this.handle, 206, 0, 0);
        OS.SendMessage(this.handle, 182, 0, index - topIndex);
    }

    public void showSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        if (this.ignoreVerify) {
            return string;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        if (OS.IsDBLocale) {
            event.start = this.mbcsToWcsPos(start);
            event.end = this.mbcsToWcsPos(end);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    int wcsToMbcsPos(int wcsPos) {
        if (wcsPos == 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return wcsPos;
        }
        int cp = this.getCodePage();
        int wcsTotal = 0;
        int mbcsTotal = 0;
        byte[] buffer = new byte[128];
        String delimiter = this.getLineDelimiter();
        int delimiterSize = delimiter.length();
        int count = OS.SendMessageA(this.handle, 186, 0, 0);
        int line = 0;
        while (line < count) {
            int wcsSize = 0;
            int linePos = OS.SendMessageA(this.handle, 187, line, 0);
            int mbcsSize = OS.SendMessageA(this.handle, 193, linePos, 0);
            if (mbcsSize != 0) {
                if (mbcsSize + delimiterSize > buffer.length) {
                    buffer = new byte[mbcsSize + delimiterSize];
                }
                buffer[0] = (byte)(mbcsSize & 0xFF);
                buffer[1] = (byte)(mbcsSize >> 8);
                mbcsSize = OS.SendMessageA(this.handle, 196, line, buffer);
                wcsSize = OS.MultiByteToWideChar(cp, 1, buffer, mbcsSize, null, 0);
            }
            if (line - 1 != count) {
                int i = 0;
                while (i < delimiterSize) {
                    buffer[mbcsSize++] = (byte)delimiter.charAt(i);
                    ++i;
                }
                wcsSize += delimiterSize;
            }
            if (wcsTotal + wcsSize >= wcsPos) {
                wcsSize = 0;
                int index = 0;
                while (index < mbcsSize) {
                    if (wcsTotal + wcsSize == wcsPos) {
                        return mbcsTotal + index;
                    }
                    if (OS.IsDBCSLeadByte(buffer[index++])) {
                        ++index;
                    }
                    ++wcsSize;
                }
                return mbcsTotal + mbcsSize;
            }
            wcsTotal += wcsSize;
            mbcsTotal += mbcsSize;
            ++line;
        }
        return mbcsTotal;
    }

    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 0x400000) != 0) {
            bits |= 0x20;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 1;
        }
        if ((this.style & 8) != 0) {
            bits |= 0x800;
        }
        if ((this.style & 4) != 0) {
            return bits | 0x80;
        }
        bits |= 0x184;
        if ((this.style & 0x40) != 0) {
            bits &= 0xFFEFFF7F;
        }
        return bits;
    }

    TCHAR windowClass() {
        return EditClass;
    }

    int windowProc() {
        return EditProc;
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 4) != 0) {
            switch (wParam) {
                case 13: {
                    this.postEvent(14);
                }
                case 9: 
                case 27: {
                    return LRESULT.ZERO;
                }
            }
        }
        return result;
    }

    LRESULT WM_CLEAR(int wParam, int lParam) {
        LRESULT result = super.WM_CLEAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return result;
        }
        if ((this.style & 8) != 0) {
            return result;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        if (start[0] == end[0]) {
            return result;
        }
        String newText = this.verifyText("", start[0], end[0], null);
        if (newText == null) {
            return LRESULT.ZERO;
        }
        if (newText.length() != 0) {
            result = new LRESULT(this.callWindowProc(771, 0, 0));
            newText = Display.withCrLf(newText);
            TCHAR buffer = new TCHAR(this.getCodePage(), newText, true);
            this.ignoreCharacter = true;
            OS.SendMessage(this.handle, 194, 0, buffer);
            this.ignoreCharacter = false;
        }
        return result;
    }

    LRESULT WM_CUT(int wParam, int lParam) {
        LRESULT result = super.WM_CUT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return result;
        }
        if ((this.style & 8) != 0) {
            return result;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        if (start[0] == end[0]) {
            return result;
        }
        String newText = this.verifyText("", start[0], end[0], null);
        if (newText == null) {
            return LRESULT.ZERO;
        }
        if (newText.length() != 0) {
            result = new LRESULT(this.callWindowProc(768, 0, 0));
            newText = Display.withCrLf(newText);
            TCHAR buffer = new TCHAR(this.getCodePage(), newText, true);
            this.ignoreCharacter = true;
            OS.SendMessage(this.handle, 194, 0, buffer);
            this.ignoreCharacter = false;
        }
        return result;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (OS.IsPPC && (this.style & 2) != 0 && (this.style & 8) == 0 && lParam == 0) {
            return new LRESULT(140);
        }
        if ((this.style & 8) != 0) {
            int code = this.callWindowProc(135, wParam, lParam);
            return new LRESULT(code &= 0xFFFFFFF8);
        }
        return null;
    }

    LRESULT WM_IME_CHAR(int wParam, int lParam) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = wParam;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, wParam, lParam)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int result = this.callWindowProc(646, wParam, lParam);
        MSG msg = new MSG();
        while (OS.PeekMessage(msg, this.handle, 258, 258, 1)) {
            OS.TranslateMessage(msg);
            OS.DispatchMessage(msg);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, wParam, lParam);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(result);
    }

    LRESULT WM_LBUTTONDBLCLK(int wParam, int lParam) {
        int result;
        int length;
        this.sendMouseEvent(3, 1, 513, wParam, lParam);
        this.sendMouseEvent(8, 1, 515, wParam, lParam);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (!this.doubleClick) {
            return LRESULT.ZERO;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        if (start[0] == end[0] && (length = OS.GetWindowTextLength(this.handle)) == start[0] && (result = OS.SendMessage(this.handle, 193, length, 0)) == 0) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_PASTE(int wParam, int lParam) {
        LRESULT result = super.WM_PASTE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return result;
        }
        if ((this.style & 8) != 0) {
            return result;
        }
        String oldText = this.getClipboardText();
        if (oldText == null) {
            return result;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        String newText = this.verifyText(oldText, start[0], end[0], null);
        if (newText == null) {
            return LRESULT.ZERO;
        }
        if (newText != oldText) {
            newText = Display.withCrLf(newText);
            TCHAR buffer = new TCHAR(this.getCodePage(), newText, true);
            this.ignoreCharacter = true;
            OS.SendMessage(this.handle, 194, 0, buffer);
            this.ignoreCharacter = false;
            return LRESULT.ZERO;
        }
        return result;
    }

    LRESULT WM_UNDO(int wParam, int lParam) {
        LRESULT result = super.WM_UNDO(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return result;
        }
        if (OS.SendMessage(this.handle, 198, 0, 0) == 0) {
            return result;
        }
        this.ignoreVerify = true;
        this.callWindowProc(772, wParam, lParam);
        String oldText = this.getSelectionText();
        this.callWindowProc(772, wParam, lParam);
        this.ignoreVerify = false;
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 176, start, end);
        String newText = this.verifyText(oldText, start[0], end[0], null);
        if (newText == null) {
            return LRESULT.ZERO;
        }
        if (newText != oldText) {
            newText = Display.withCrLf(newText);
            TCHAR buffer = new TCHAR(this.getCodePage(), newText, true);
            this.ignoreCharacter = true;
            OS.SendMessage(this.handle, 194, 0, buffer);
            this.ignoreCharacter = false;
            return LRESULT.ZERO;
        }
        this.ignoreVerify = true;
        this.callWindowProc(772, wParam, lParam);
        this.ignoreVerify = false;
        return LRESULT.ONE;
    }

    LRESULT wmCommandChild(int wParam, int lParam) {
        int code = wParam >> 16;
        switch (code) {
            case 768: {
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: {
                this.style &= 0xFBFFFFFF;
                this.style |= 0x2000000;
                this.fixAlignment();
                break;
            }
            case 1793: {
                this.style &= 0xFDFFFFFF;
                this.style |= 0x4000000;
                this.fixAlignment();
            }
        }
        return super.wmCommandChild(wParam, lParam);
    }
}

