/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHACTIVATEINFO;
import org.eclipse.swt.internal.win32.SIPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    Menu activeMenu;
    int hIMC;
    int hwndMDIClient;
    int toolTipHandle;
    int lpstrTip;
    int[] brushes;
    boolean showWithParent;
    Control lastActive;
    SHACTIVATEINFO psai;
    Region region;
    static final int DialogProc;
    static final TCHAR DialogClass;

    static {
        DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, DialogClass, lpWndClass);
        DialogProc = lpWndClass.lpfnWndProc;
    }

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, OS.IsWinCE ? 0 : 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, OS.IsWinCE ? 0 : 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0);
    }

    public static Shell win32_new(Display display, int handle) {
        return new Shell(display, null, 8, handle);
    }

    static int checkStyle(int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.parent != null) {
            if (this.handle == 0) {
                return 0;
            }
            switch (msg) {
                case 7: 
                case 8: {
                    return OS.DefWindowProc(this.handle, msg, wParam, lParam);
                }
            }
            return OS.CallWindowProc(DialogProc, this.handle, msg, wParam, lParam);
        }
        if (this.handle == 0) {
            return 0;
        }
        if (this.hwndMDIClient != 0) {
            return OS.DefFrameProc(this.handle, this.hwndMDIClient, msg, wParam, lParam);
        }
        return OS.DefWindowProc(this.handle, msg, wParam, lParam);
    }

    public void close() {
        this.checkWidget();
        OS.PostMessage(this.handle, 16, 0, 0);
    }

    void createHandle() {
        boolean embedded = this.handle != 0;
        super.createHandle();
        if (!embedded) {
            int bits = OS.GetWindowLong(this.handle, -16);
            bits &= ~(OS.WS_OVERLAPPED | 0xC00000);
            if (!OS.IsWinCE) {
                bits |= Integer.MIN_VALUE;
            }
            if ((this.style & 0x20) != 0) {
                bits |= 0xC00000;
            }
            if ((this.style & 8) == 0 && (this.style & 0x810) == 0) {
                bits |= 0x800000;
            }
            OS.SetWindowLong(this.handle, -16, bits);
            int flags = 55;
            OS.SetWindowPos(this.handle, 0, 0, 0, 0, 0, flags);
            if (OS.IsWinCE) {
                this.setMaximized(true);
            }
            if (OS.IsPPC) {
                this.psai = new SHACTIVATEINFO();
                this.psai.cbSize = 12;
            }
        }
        if (OS.IsDBLocale) {
            this.hIMC = OS.ImmCreateContext();
            if (this.hIMC != 0) {
                OS.ImmAssociateContext(this.handle, this.hIMC);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    int findBrush(int pixel) {
        int hBrush;
        if (pixel == OS.GetSysColor(OS.COLOR_BTNFACE)) {
            return OS.GetSysColorBrush(OS.COLOR_BTNFACE);
        }
        if (pixel == OS.GetSysColor(OS.COLOR_WINDOW)) {
            return OS.GetSysColorBrush(OS.COLOR_WINDOW);
        }
        if (this.brushes == null) {
            this.brushes = new int[4];
        }
        LOGBRUSH logBrush = new LOGBRUSH();
        int i = 0;
        while (i < this.brushes.length) {
            hBrush = this.brushes[i];
            if (hBrush == 0) break;
            OS.GetObject(hBrush, 12, logBrush);
            if (logBrush.lbColor == pixel) {
                return hBrush;
            }
            ++i;
        }
        int length = this.brushes.length;
        hBrush = this.brushes[--length];
        if (hBrush != 0) {
            OS.DeleteObject(hBrush);
        }
        System.arraycopy(this.brushes, 0, this.brushes, 1, length);
        this.brushes[0] = hBrush = OS.CreateSolidBrush(pixel);
        return hBrush;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    void fixShell(Shell newShell, Control control) {
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if (this.toolTipHandle != 0) {
            this.setToolTipText(control.handle, null);
        }
        newShell.setToolTipText(control.handle, control.toolTipText);
    }

    public void forceActive() {
        this.checkWidget();
        OS.SetForegroundWindow(this.handle);
    }

    void forceResize() {
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getBounds();
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public int getImeInputMode() {
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return 0;
        }
        int hIMC = OS.ImmGetContext(this.handle);
        int[] lpfdwConversion = new int[1];
        int[] lpfdwSentence = new int[1];
        boolean open = OS.ImmGetOpenStatus(hIMC);
        if (open) {
            open = OS.ImmGetConversionStatus(hIMC, lpfdwConversion, lpfdwSentence);
        }
        OS.ImmReleaseContext(this.handle, hIMC);
        if (!open) {
            return 0;
        }
        int result = 0;
        if ((lpfdwConversion[0] & 0x10) != 0) {
            result |= 0x20;
        }
        if ((lpfdwConversion[0] & 8) != 0) {
            result |= 2;
        }
        if ((lpfdwConversion[0] & 2) != 0) {
            return result | 0x10;
        }
        if ((lpfdwConversion[0] & 1) != 0) {
            return result | 8;
        }
        return result | 4;
    }

    public Point getLocation() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getLocation();
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        return new Point(rect.left, rect.top);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    int hwndMDIClient() {
        if (this.hwndMDIClient == 0) {
            int widgetStyle = 1174405121;
            this.hwndMDIClient = OS.CreateWindowEx(0, new TCHAR(0, "MDICLIENT", true), null, widgetStyle, 0, 0, 0, 0, this.handle, 0, OS.GetModuleHandle(null), new CREATESTRUCT());
        }
        return this.hwndMDIClient;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop();
        if (OS.IsWinCE) {
            OS.SetForegroundWindow(this.handle);
        }
        OS.SendMessage(this.handle, 295, 3, 0);
        this.setVisible(true);
        MSG msg = new MSG();
        OS.PeekMessage(msg, 0, 0, 0, 0);
        this.restoreFocus();
    }

    void releaseChild() {
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndMDIClient = 0;
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseShells();
        super.releaseWidget();
        this.activeMenu = null;
        this.display.clearModal(this);
        if (this.lpstrTip != 0) {
            int hHeap = OS.GetProcessHeap();
            OS.HeapFree(hHeap, 0, this.lpstrTip);
        }
        this.lpstrTip = 0;
        this.toolTipHandle = 0;
        if (this.brushes != null) {
            int i = 0;
            while (i < this.brushes.length) {
                int hBrush = this.brushes[i];
                if (hBrush != 0) {
                    OS.DeleteObject(hBrush);
                }
                ++i;
            }
        }
        this.brushes = null;
        if (OS.IsDBLocale && this.hIMC != 0) {
            OS.ImmDestroyContext(this.hIMC);
        }
        this.lastActive = null;
        this.region = null;
    }

    void remove(Menu menu) {
        super.remove(menu);
        if (menu == this.activeMenu) {
            this.activeMenu = null;
        }
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    LRESULT selectPalette(int hPalette) {
        int hDC = OS.GetDC(this.handle);
        int hOld = OS.SelectPalette(hDC, hPalette, false);
        int result = OS.RealizePalette(hDC);
        if (result > 0) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            OS.SelectPalette(hDC, hOld, true);
            OS.RealizePalette(hDC);
        }
        OS.ReleaseDC(this.handle, hDC);
        return result > 0 ? LRESULT.ONE : LRESULT.ZERO;
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if (OS.IsWinCE) {
            int bits;
            this.swFlags = OS.SW_RESTORE;
            if ((this.style & 8) == 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0xC00000) != 0xC00000) {
                OS.SetWindowLong(this.handle, -16, bits |= 0xC00000);
            }
        } else if (OS.IsIconic(this.handle) || OS.IsZoomed(this.handle)) {
            this.setPlacement(x, y, width, height, flags);
            return;
        }
        OS.SetWindowPos(this.handle, 0, x, y, width, height, flags);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFBF;
        if (!enabled) {
            this.state |= 0x40;
        }
        if (!Display.TrimEnabled) {
            super.setEnabled(enabled);
        } else if (this.isActive()) {
            this.setItemEnabled(61536, enabled);
        }
    }

    public void setImeInputMode(int mode) {
        int[] lpfdwSentence;
        int[] lpfdwConversion;
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return;
        }
        boolean imeOn = mode != 0 && mode != 32;
        int hIMC = OS.ImmGetContext(this.handle);
        OS.ImmSetOpenStatus(hIMC, imeOn);
        if (imeOn && OS.ImmGetConversionStatus(hIMC, lpfdwConversion = new int[1], lpfdwSentence = new int[1])) {
            int newBits = 0;
            int oldBits = 3;
            if ((mode & 0x10) != 0) {
                newBits = 3;
                oldBits = 0;
            } else if ((mode & 8) != 0) {
                newBits = 1;
                oldBits = 2;
            }
            if ((mode & 2) != 0) {
                newBits |= 8;
            } else {
                oldBits |= 8;
            }
            if ((mode & 0x20) != 0) {
                newBits |= 0x10;
            } else {
                oldBits |= 0x10;
            }
            lpfdwConversion[0] = lpfdwConversion[0] | newBits;
            lpfdwConversion[0] = lpfdwConversion[0] & ~oldBits;
            OS.ImmSetConversionStatus(hIMC, lpfdwConversion[0], lpfdwSentence[0]);
        }
        OS.ImmReleaseContext(this.handle, hIMC);
    }

    void setItemEnabled(int cmd, boolean enabled) {
        int hMenu = OS.GetSystemMenu(this.handle, false);
        if (hMenu == 0) {
            return;
        }
        int flags = 0;
        if (!enabled) {
            flags = 3;
        }
        OS.EnableMenuItem(hMenu, cmd, flags);
    }

    void setParent() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        int hRegion = 0;
        if (region != null) {
            hRegion = OS.CreateRectRgn(0, 0, 0, 0);
            OS.CombineRgn(hRegion, region.handle, hRegion, 2);
        }
        OS.SetWindowRgn(this.handle, hRegion, true);
        this.region = region;
    }

    void setToolTipText(int hwnd, String text) {
        if (OS.IsWinCE) {
            return;
        }
        if (this.toolTipHandle == 0) {
            this.toolTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 1, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
            if (this.toolTipHandle == 0) {
                this.error(2);
            }
            OS.SendMessage(this.toolTipHandle, 1048, 0, Short.MAX_VALUE);
        }
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        lpti.uId = hwnd;
        lpti.hwnd = this.handle;
        if (text == null) {
            OS.SendMessage(this.toolTipHandle, OS.TTM_DELTOOL, 0, lpti);
        } else {
            lpti.uFlags = 17;
            lpti.lpszText = -1;
            OS.SendMessage(this.toolTipHandle, OS.TTM_ADDTOOL, 0, lpti);
        }
        OS.SendMessage(this.toolTipHandle, 1053, 0, 0);
    }

    void setToolTipText(NMTTDISPINFO lpnmtdi, byte[] buffer) {
        if (!this.hasCursor()) {
            return;
        }
        int hHeap = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(hHeap, 0, this.lpstrTip);
        }
        int byteCount = buffer.length;
        this.lpstrTip = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(this.lpstrTip, buffer, byteCount);
        lpnmtdi.lpszText = this.lpstrTip;
    }

    void setToolTipText(NMTTDISPINFO lpnmtdi, char[] buffer) {
        if (!this.hasCursor()) {
            return;
        }
        int hHeap = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(hHeap, 0, this.lpstrTip);
        }
        int byteCount = buffer.length * 2;
        this.lpstrTip = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(this.lpstrTip, buffer, byteCount);
        lpnmtdi.lpszText = this.lpstrTip;
    }

    public void setVisible(boolean visible) {
        int mask;
        this.checkWidget();
        if (this.showWithParent && !visible && !OS.IsWinCE) {
            OS.ShowOwnedPopups(this.handle, false);
        }
        super.setVisible(visible);
        if (this.showWithParent == visible) {
            return;
        }
        this.showWithParent = visible;
        if (visible && !OS.IsWinCE) {
            OS.ShowOwnedPopups(this.handle, true);
        }
        if ((this.style & (mask = 229376)) != 0) {
            if (visible) {
                int hwndShell;
                this.display.setModalShell(this);
                Control control = this.display.getFocusControl();
                if (control != null && !control.isActive()) {
                    this.bringToTop();
                }
                if ((hwndShell = OS.GetActiveWindow()) == 0 && this.parent != null) {
                    hwndShell = this.parent.handle;
                }
                if (hwndShell != 0) {
                    OS.SendMessage(hwndShell, 31, 0, 0);
                }
                OS.ReleaseCapture();
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
    }

    boolean translateAccelerator(MSG msg) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        return this.translateMDIAccelerator(msg) || this.translateMenuAccelerator(msg);
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
        if (!Display.TrimEnabled) {
            super.setEnabled(this.isActive());
        } else {
            this.setItemEnabled(61536, this.isActive());
        }
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetParent() {
        if (this.handle != 0) {
            return this.handle;
        }
        return this.parent != null ? this.parent.handle : 0;
    }

    int widgetExtStyle() {
        int bits = super.widgetExtStyle() & 0xFFFFFFBF;
        if (OS.IsWin95) {
            return bits;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return bits;
        }
        if ((this.style & 0x4000) != 0) {
            bits |= 8;
        }
        return bits;
    }

    TCHAR windowClass() {
        if (OS.IsSP) {
            return DialogClass;
        }
        return this.parent != null ? DialogClass : super.windowClass();
    }

    int windowProc() {
        if (OS.IsSP) {
            return DialogProc;
        }
        return this.parent != null ? DialogProc : super.windowProc();
    }

    int widgetStyle() {
        int bits = super.widgetStyle();
        if (this.handle != 0) {
            return bits | 0x40000000;
        }
        bits &= 0xBFFFFFFF;
        if (OS.IsWinCE) {
            if (OS.IsSP) {
                return bits | Integer.MIN_VALUE;
            }
            return this.parent == null ? bits : bits | Integer.MIN_VALUE;
        }
        return bits | OS.WS_OVERLAPPED | 0xC00000;
    }

    LRESULT WM_ACTIVATE(int wParam, int lParam) {
        if (OS.IsPPC) {
            if (this.hooks(33) || this.hooks(34)) {
                int fActive = wParam & 0xFFFF;
                int hwnd = fActive != 0 ? this.handle : 0;
                int bVk = 193;
                while (bVk <= 198) {
                    OS.SHSetAppKeyWndAssoc((byte)bVk, hwnd);
                    ++bVk;
                }
            }
            if ((wParam & 0xFFFF) != 0) {
                OS.SHSipPreference(this.handle, this.psai.fSipUp == 0 ? 1 : 0);
            }
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 327681 && (wParam & 0xFFFF) == 0 && OS.IsDBLocale && this.hIMC != 0) {
            OS.ImmSetOpenStatus(this.hIMC, false);
        }
        LRESULT result = super.WM_ACTIVATE(wParam, lParam);
        if (this.parent != null) {
            return LRESULT.ZERO;
        }
        return result;
    }

    LRESULT WM_CLOSE(int wParam, int lParam) {
        if (Display.TrimEnabled && !this.isEnabled() || !this.isActive()) {
            return LRESULT.ZERO;
        }
        return super.WM_CLOSE(wParam, lParam);
    }

    LRESULT WM_COMMAND(int wParam, int lParam) {
        int hwndCB;
        int loWord;
        if (OS.IsPPC && (loWord = wParam & 0xFFFF) == 1 && (lParam == 0 || lParam == this.handle)) {
            OS.PostMessage(this.handle, 16, 0, 0);
            return LRESULT.ZERO;
        }
        if ((OS.IsPPC || OS.IsSP) && this.menuBar != null && (hwndCB = this.menuBar.hwndCB) != 0 && lParam == hwndCB) {
            return super.WM_COMMAND(wParam, 0);
        }
        return super.WM_COMMAND(wParam, lParam);
    }

    LRESULT WM_DESTROY(int wParam, int lParam) {
        LRESULT result = super.WM_DESTROY(wParam, lParam);
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x40000000) != 0) {
            this.releaseChild();
            this.releaseResources();
        }
        return result;
    }

    LRESULT WM_ENTERIDLE(int wParam, int lParam) {
        LRESULT result = super.WM_ENTERIDLE(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.display.runAsyncMessages();
        return result;
    }

    LRESULT WM_MOUSEACTIVATE(int wParam, int lParam) {
        int hwnd;
        LRESULT result = super.WM_MOUSEACTIVATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        int hittest = lParam & 0xFFFF;
        switch (hittest) {
            case -2: 
            case -1: 
            case 0: {
                break;
            }
            default: {
                Decorations decorations;
                Control control = this.display.getFocusControl();
                if (control == null || (decorations = control.menuShell()).getShell() != this || decorations == this) break;
                this.display.ignoreRestoreFocus = true;
                this.display.lastHittest = hittest;
                this.display.lastHittestControl = null;
                if (hittest == 5 || hittest == 3) {
                    this.display.lastHittestControl = control;
                    return null;
                }
                if (OS.IsWin95 && hittest == 2) {
                    this.display.lastHittestControl = control;
                }
                return new LRESULT(3);
            }
        }
        if (hittest == 5) {
            return null;
        }
        POINT pt = new POINT();
        if (!OS.GetCursorPos(pt)) {
            int pos = OS.GetMessagePos();
            pt.x = (short)(pos & 0xFFFF);
            pt.y = (short)(pos >> 16);
        }
        if ((hwnd = OS.WindowFromPoint(pt)) == 0) {
            return null;
        }
        Control control = this.display.findControl(hwnd);
        this.setActiveControl(control);
        return null;
    }

    LRESULT WM_NCHITTEST(int wParam, int lParam) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isEnabled() || !this.isActive()) {
            if (!Display.TrimEnabled) {
                return new LRESULT(0);
            }
            int hittest = this.callWindowProc(132, wParam, lParam);
            if (hittest == 1 || hittest == 5) {
                hittest = 18;
            }
            return new LRESULT(hittest);
        }
        if (this.menuBar != null && !this.menuBar.getEnabled()) {
            int hittest = this.callWindowProc(132, wParam, lParam);
            if (hittest == 5) {
                hittest = 18;
            }
            return new LRESULT(hittest);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(int wParam, int lParam) {
        Control focusControl;
        boolean fixActive;
        LRESULT result = super.WM_NCLBUTTONDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!this.display.ignoreRestoreFocus) {
            return result;
        }
        Display display = this.display;
        int hwndActive = 0;
        boolean bl = fixActive = OS.IsWin95 && display.lastHittest == 2;
        if (fixActive) {
            hwndActive = OS.SetActiveWindow(this.handle);
        }
        display.lockActiveWindow = true;
        int code = this.callWindowProc(161, wParam, lParam);
        display.lockActiveWindow = false;
        if (fixActive) {
            OS.SetActiveWindow(hwndActive);
        }
        if ((focusControl = display.lastHittestControl) != null && !focusControl.isDisposed()) {
            focusControl.setFocus();
        }
        display.lastHittestControl = null;
        display.ignoreRestoreFocus = false;
        return new LRESULT(code);
    }

    LRESULT WM_PALETTECHANGED(int wParam, int lParam) {
        int hPalette;
        if (wParam != this.handle && (hPalette = this.display.hPalette) != 0) {
            return this.selectPalette(hPalette);
        }
        return super.WM_PALETTECHANGED(wParam, lParam);
    }

    LRESULT WM_QUERYNEWPALETTE(int wParam, int lParam) {
        int hPalette = this.display.hPalette;
        if (hPalette != 0) {
            return this.selectPalette(hPalette);
        }
        return super.WM_QUERYNEWPALETTE(wParam, lParam);
    }

    LRESULT WM_SETCURSOR(int wParam, int lParam) {
        int msg = lParam >> 16;
        if (msg == 513) {
            int hwndPopup;
            int hwndModal;
            Shell modalShell;
            if (!Display.TrimEnabled && (modalShell = this.display.getModalShell()) != null && !this.isActive() && OS.IsWindowEnabled(hwndModal = modalShell.handle)) {
                OS.SetActiveWindow(hwndModal);
            }
            if (!OS.IsWindowEnabled(this.handle) && !OS.IsWinCE && (hwndPopup = OS.GetLastActivePopup(this.handle)) != 0 && hwndPopup != this.handle && this.display.getControl(hwndPopup) == null && OS.IsWindowEnabled(hwndPopup)) {
                OS.SetActiveWindow(hwndPopup);
            }
        }
        return super.WM_SETCURSOR(wParam, lParam);
    }

    LRESULT WM_SETTINGCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_SETTINGCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (OS.IsPPC && wParam == 224) {
            if ((this.style & 0x10) != 0) {
                OS.SHHandleWMSettingChange(this.handle, wParam, lParam, this.psai);
                return LRESULT.ZERO;
            }
            SIPINFO pSipInfo = new SIPINFO();
            pSipInfo.cbSize = 48;
            OS.SipGetInfo(pSipInfo);
            this.psai.fSipUp = pSipInfo.fdwFlags & 1;
        }
        return result;
    }

    LRESULT WM_SHOWWINDOW(int wParam, int lParam) {
        LRESULT result = super.WM_SHOWWINDOW(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (lParam == 3) {
            Composite control = this;
            while (control != null) {
                Shell shell = ((Control)control).getShell();
                if (!shell.showWithParent) {
                    return LRESULT.ZERO;
                }
                control = control.parent;
            }
        }
        return result;
    }
}

