/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int increment;
    int pageIncrement;

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void createWidget() {
        this.increment = 1;
        this.pageIncrement = 10;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        super.dispose();
        if (OS.IsWinCE) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = 28;
            info.fMask = 3;
            info.nPage = 101;
            info.nMax = 100;
            info.nMin = 0;
            OS.SetScrollInfo(hwnd, type, info, true);
        } else {
            OS.ShowScrollBar(hwnd, type, false);
        }
    }

    Rectangle getBounds() {
        int height;
        int width;
        RECT rect = new RECT();
        OS.GetClientRect(this.parent.handle, rect);
        int x = 0;
        int y = 0;
        if ((this.style & 0x100) != 0) {
            y = rect.bottom - rect.top;
            width = rect.right - rect.left;
            height = OS.GetSystemMetrics(3);
        } else {
            x = rect.right - rect.left;
            width = OS.GetSystemMetrics(2);
            height = rect.bottom - rect.top;
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 1;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        OS.GetScrollInfo(hwnd, type, info);
        return info.nMax;
    }

    public int getMinimum() {
        this.checkWidget();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 1;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        OS.GetScrollInfo(hwnd, type, info);
        return info.nMin;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 4;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        OS.GetScrollInfo(hwnd, type, info);
        return info.nPos;
    }

    public Point getSize() {
        int height;
        int width;
        this.checkWidget();
        RECT rect = new RECT();
        OS.GetClientRect(this.parent.handle, rect);
        if ((this.style & 0x100) != 0) {
            width = rect.right - rect.left;
            height = OS.GetSystemMetrics(3);
        } else {
            width = OS.GetSystemMetrics(2);
            height = rect.bottom - rect.top;
        }
        return new Point(width, height);
    }

    public int getThumb() {
        this.checkWidget();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 2;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        OS.GetScrollInfo(hwnd, type, info);
        if (info.nPage != 0) {
            --info.nPage;
        }
        return info.nPage;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x80) == 0;
    }

    int hwndScrollBar() {
        return this.parent.handle;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int scrollBarType() {
        if ((this.style & 0x200) != 0) {
            return 1;
        }
        return 0;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (!OS.IsWinCE) {
            int hwnd = this.hwndScrollBar();
            int type = this.scrollBarType();
            int flags = enabled ? 0 : 3;
            OS.EnableScrollBar(hwnd, type, flags);
            this.state &= 0xFFFFFFBF;
            if (!enabled) {
                this.state |= 0x40;
            }
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        info.fMask = 9;
        OS.GetScrollInfo(hwnd, type, info);
        if (value - info.nMin - info.nPage < 1) {
            return;
        }
        info.nMax = value;
        OS.SetScrollInfo(hwnd, type, info, (this.state & 0x40) == 0);
        if ((this.state & 0x80) != 0 && !OS.IsWinCE) {
            OS.ShowScrollBar(hwnd, type, false);
        }
        if ((this.state & 0x40) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(hwnd, type, 3);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        info.fMask = 9;
        OS.GetScrollInfo(hwnd, type, info);
        if (info.nMax - value - info.nPage < 1) {
            return;
        }
        info.nMin = value;
        OS.SetScrollInfo(hwnd, type, info, true);
        if ((this.state & 0x80) != 0 && !OS.IsWinCE) {
            OS.ShowScrollBar(hwnd, type, false);
        }
        if ((this.state & 0x40) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(hwnd, type, 3);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        info.fMask = 4;
        info.nPos = selection;
        OS.SetScrollInfo(hwnd, type, info, true);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        info.fMask = 11;
        OS.GetScrollInfo(hwnd, type, info);
        info.nPage = value;
        if (info.nPage != 0) {
            ++info.nPage;
        }
        OS.SetScrollInfo(hwnd, type, info, true);
        if ((this.state & 0x80) != 0 && !OS.IsWinCE) {
            OS.ShowScrollBar(hwnd, type, false);
        }
        if ((this.state & 0x40) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(hwnd, type, 3);
        }
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 15;
        info.nPos = selection;
        info.nMin = minimum;
        info.nMax = maximum;
        info.nPage = thumb;
        if (info.nPage != 0) {
            ++info.nPage;
        }
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        OS.SetScrollInfo(hwnd, type, info, true);
        if ((this.state & 0x80) != 0 && !OS.IsWinCE) {
            OS.ShowScrollBar(hwnd, type, false);
        }
        if ((this.state & 0x40) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(hwnd, type, 3);
        }
    }

    public void setVisible(boolean visible) {
        int type;
        boolean isVisible;
        this.checkWidget();
        boolean bl = isVisible = (this.state & 0x80) == 0;
        if (isVisible == visible) {
            return;
        }
        if (OS.IsWinCE) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = 28;
            int hwnd = this.hwndScrollBar();
            int type2 = this.scrollBarType();
            info.fMask = 3;
            if (visible) {
                info.fMask |= 8;
            }
            OS.GetScrollInfo(hwnd, type2, info);
            if (info.nPage == info.nMax - info.nMin + 1) {
                int max = info.nMax++;
                OS.SetScrollInfo(hwnd, type2, info, false);
                info.nMax = max;
                OS.SetScrollInfo(hwnd, type2, info, true);
            }
            return;
        }
        this.state = visible ? this.state & 0xFFFFFF7F : this.state | 0x80;
        int hwnd = this.hwndScrollBar();
        if (OS.ShowScrollBar(hwnd, type = this.scrollBarType(), visible)) {
            if ((this.state & 0x40) == 0) {
                SCROLLINFO info = new SCROLLINFO();
                info.cbSize = 28;
                info.fMask = 3;
                OS.GetScrollInfo(hwnd, type, info);
                if (info.nMax - info.nMin - info.nPage >= 0) {
                    OS.EnableScrollBar(hwnd, type, 0);
                }
            }
            this.sendEvent(visible ? 22 : 23);
        }
    }

    LRESULT wmScrollChild(int wParam, int lParam) {
        int code = wParam & 0xFFFF;
        if (code == 8) {
            return null;
        }
        Event event = new Event();
        switch (code) {
            case 5: {
                event.detail = 1;
                break;
            }
            case 6: {
                event.detail = 0x1000007;
                break;
            }
            case 7: {
                event.detail = 0x1000008;
                break;
            }
            case 1: {
                event.detail = 0x1000002;
                break;
            }
            case 0: {
                event.detail = 0x1000001;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
            }
        }
        this.sendEvent(13, event);
        return null;
    }
}

