/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.win32.OPENFILENAME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    static final String FILTER = "*.*";
    static int BUFFER_SIZE = 32768;

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        boolean success;
        boolean save;
        int hHeap = OS.GetProcessHeap();
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        if (this.title == null) {
            this.title = "";
        }
        TCHAR buffer3 = new TCHAR(0, this.title, true);
        int byteCount3 = buffer3.length() * TCHAR.sizeof;
        int lpstrTitle = OS.HeapAlloc(hHeap, 8, byteCount3);
        OS.MoveMemory(lpstrTitle, buffer3, byteCount3);
        String strFilter = "";
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int i = 0;
        while (i < this.filterExtensions.length) {
            String filterName = this.filterExtensions[i];
            if (i < this.filterNames.length) {
                filterName = this.filterNames[i];
            }
            strFilter = String.valueOf(strFilter) + filterName + '\u0000' + this.filterExtensions[i] + '\u0000';
            ++i;
        }
        if (this.filterExtensions.length == 0) {
            strFilter = String.valueOf(strFilter) + FILTER + '\u0000' + FILTER + '\u0000';
        }
        TCHAR buffer4 = new TCHAR(0, strFilter, true);
        int byteCount4 = buffer4.length() * TCHAR.sizeof;
        int lpstrFilter = OS.HeapAlloc(hHeap, 8, byteCount4);
        OS.MoveMemory(lpstrFilter, buffer4, byteCount4);
        if (this.fileName == null) {
            this.fileName = "";
        }
        TCHAR name = new TCHAR(0, this.fileName, true);
        int nMaxFile = 260;
        if ((this.style & 2) != 0) {
            nMaxFile = Math.max(nMaxFile, BUFFER_SIZE);
        }
        int byteCount = nMaxFile * TCHAR.sizeof;
        int lpstrFile = OS.HeapAlloc(hHeap, 8, byteCount);
        int byteCountFile = Math.min(name.length() * TCHAR.sizeof, byteCount - TCHAR.sizeof);
        OS.MoveMemory(lpstrFile, name, byteCountFile);
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        TCHAR path = new TCHAR(0, this.filterPath.replace('/', '\\'), true);
        int byteCount5 = 260 * TCHAR.sizeof;
        int lpstrInitialDir = OS.HeapAlloc(hHeap, 8, byteCount5);
        int byteCountDir = Math.min(path.length() * TCHAR.sizeof, byteCount5 - TCHAR.sizeof);
        OS.MoveMemory(lpstrInitialDir, path, byteCountDir);
        OPENFILENAME struct = new OPENFILENAME();
        struct.lStructSize = 76;
        struct.Flags = 12;
        if ((this.style & 2) != 0) {
            struct.Flags |= 0x80200;
        }
        struct.hwndOwner = hwndOwner;
        struct.lpstrTitle = lpstrTitle;
        struct.lpstrFile = lpstrFile;
        struct.nMaxFile = nMaxFile;
        struct.lpstrInitialDir = lpstrInitialDir;
        struct.lpstrFilter = lpstrFilter;
        struct.nFilterIndex = 0;
        int lpstrDefExt = 0;
        boolean bl = save = (this.style & 0x2000) != 0;
        if (save) {
            struct.lpstrDefExt = lpstrDefExt = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
        }
        boolean bl2 = success = save ? OS.GetSaveFileName(struct) : OS.GetOpenFileName(struct);
        if (OS.CommDlgExtendedError() == 12290) {
            OS.MoveMemory(lpstrFile, new TCHAR(0, "", true), TCHAR.sizeof);
            success = save ? OS.GetSaveFileName(struct) : OS.GetOpenFileName(struct);
        }
        this.fileNames = new String[0];
        String fullPath = null;
        if (success) {
            TCHAR buffer = new TCHAR(0, struct.nMaxFile);
            int byteCount1 = buffer.length() * TCHAR.sizeof;
            OS.MoveMemory(buffer, lpstrFile, byteCount1);
            int nFileOffset = struct.nFileOffset;
            if (OS.IsWinCE && nFileOffset == 0) {
                int index = 0;
                while (index < buffer.length()) {
                    int ch = buffer.tcharAt(index);
                    if (ch == 0) break;
                    if (ch == 92) {
                        nFileOffset = index + 1;
                    }
                    ++index;
                }
            }
            if (nFileOffset > 0) {
                String[] newFileNames;
                TCHAR prefix = new TCHAR(0, nFileOffset - 1);
                int byteCount2 = prefix.length() * TCHAR.sizeof;
                OS.MoveMemory(prefix, lpstrFile, byteCount2);
                this.filterPath = prefix.toString(0, prefix.length());
                int count = 0;
                this.fileNames = new String[(this.style & 2) != 0 ? 4 : 1];
                int start = nFileOffset;
                do {
                    int end = start;
                    while (end < buffer.length() && buffer.tcharAt(end) != 0) {
                        ++end;
                    }
                    String string = buffer.toString(start, end - start);
                    start = end;
                    if (count == this.fileNames.length) {
                        newFileNames = new String[this.fileNames.length + 4];
                        System.arraycopy(this.fileNames, 0, newFileNames, 0, this.fileNames.length);
                        this.fileNames = newFileNames;
                    }
                    this.fileNames[count++] = string;
                } while ((this.style & 2) != 0 && ++start < buffer.length() && buffer.tcharAt(start) != 0);
                if (this.fileNames.length > 0) {
                    this.fileName = this.fileNames[0];
                }
                String separator = "";
                int length = this.filterPath.length();
                if (length > 0 && this.filterPath.charAt(length - 1) != '\\') {
                    separator = "\\";
                }
                fullPath = String.valueOf(this.filterPath) + separator + this.fileName;
                if (count < this.fileNames.length) {
                    newFileNames = new String[count];
                    System.arraycopy(this.fileNames, 0, newFileNames, 0, count);
                    this.fileNames = newFileNames;
                }
            }
        }
        OS.HeapFree(hHeap, 0, lpstrFile);
        OS.HeapFree(hHeap, 0, lpstrFilter);
        OS.HeapFree(hHeap, 0, lpstrInitialDir);
        OS.HeapFree(hHeap, 0, lpstrTitle);
        if (lpstrDefExt != 0) {
            OS.HeapFree(hHeap, 0, lpstrDefExt);
        }
        return fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

